/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.kernel.app;

import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.util.SuffixSet;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@DefaultAnnotation(value={NonNull.class})
public class DriverMap
implements Runnable {
    private static final String TABLE_ATTRIBUTES = " border=\"2\" cellpadding=\"4\"";
    private static final String BEGIN_CODE = "<code>";
    private static final String END_CODE = "</code>";
    private static final String BEGIN_LINK = "<code>";
    private static final String END_LINK = "</code>";
    private final PrintStream out;
    private final FsDriverProvider provider;

    public DriverMap(PrintStream out, FsDriverProvider provider) {
        if (null == out || null == provider) {
            throw new NullPointerException();
        }
        this.out = out;
        this.provider = provider;
    }

    public static void main(String[] args) throws Exception {
        FsDriverLocator provider = 0 == args.length ? FsDriverLocator.SINGLETON : (FsDriverProvider)Class.forName(args[0]).newInstance();
        new DriverMap(System.out, (FsDriverProvider)provider).run();
    }

    @Override
    public void run() {
        Map map = this.provider.get();
        Map<String, SuffixSet> compact = DriverMap.compact(map);
        this.out.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n").append("  <head>\n").append("    <title>File System Driver Map</title>\n").append("  </head>\n").append("  <body>\n").append("    <table").append(TABLE_ATTRIBUTES).append(">\n").append("      <caption>File System Driver Provider Class ").append("<code>").append(this.provider.getClass().getName()).append("</code>").append("</caption>\n").append("      <thead>\n").append("        <tr>\n").append("          <th>URI Schemes</th>\n").append("          <th>Archive File System?</th>\n").append("          <th>File System Driver Class</th>\n").append("        </tr>\n").append("      </thead>\n").append("      <tbody>\n");
        for (Map.Entry<String, SuffixSet> entry : compact.entrySet()) {
            String clazz = entry.getKey();
            ArrayList set = new ArrayList((Collection)entry.getValue());
            String federated = Boolean.toString(((FsDriver)map.get(FsScheme.create((String)((String)set.iterator().next())))).isFederated());
            this.out.append("        <tr>\n").append("          <td>");
            for (int i = 0; i < set.size(); ++i) {
                if (0 < i) {
                    this.out.append(", ");
                }
                this.out.append("<code>").append((CharSequence)set.get(i)).append("</code>");
            }
            this.out.append("</td>\n").append("          <td>").append("<code>").append(federated).append("</code>").append("</td>\n").append("          <td>").append("<code>").append(clazz).append("</code>").append("</td>\n").append("        </tr>\n");
        }
        this.out.append("      </tbody>\n").append("    </table>\n").append("  </body>\n").append("</html>\n");
    }

    private static Map<String, SuffixSet> compact(Map<FsScheme, FsDriver> input) {
        TreeMap<String, SuffixSet> output = new TreeMap<String, SuffixSet>();
        for (Map.Entry<FsScheme, FsDriver> entry : input.entrySet()) {
            String scheme = entry.getKey().toString();
            String clazz = entry.getValue().getClass().getName();
            SuffixSet suffixes = (SuffixSet)output.get(clazz);
            if (null == suffixes) {
                suffixes = new SuffixSet();
                output.put(clazz, suffixes);
            }
            suffixes.add(scheme);
        }
        return Collections.unmodifiableMap(output);
    }
}

