/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.kernel.app;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsDefaultDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;

public final class Cat {
    private Cat() {
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        for (String path : args) {
            Cat.cat(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cat(String resource) throws IOException, URISyntaxException {
        FsManager manager = FsManagerLocator.SINGLETON.get();
        try {
            FsDefaultDriver driver = new FsDefaultDriver((FsDriverProvider)FsDriverLocator.SINGLETON);
            URI uri = new URI(resource);
            uri = uri.isAbsolute() ? uri : new TFile(resource).toURI();
            FsPath path = FsPath.create((URI)uri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            InputSocket socket = manager.getController(path.getMountPoint(), (FsCompositeDriver)driver).getInputSocket(path.getEntryName(), BitField.noneOf(FsInputOption.class));
            InputStream in = socket.newInputStream();
            try {
                Streams.cat((InputStream)in, (OutputStream)System.out);
            }
            finally {
                in.close();
            }
        }
        finally {
            manager.sync(FsManager.UMOUNT);
        }
    }
}

