/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.kernel.app;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsDefaultDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.IOException;
import java.net.URI;

public final class Copy {
    private Copy() {
    }

    public static void main(String[] args) throws IOException {
        Copy.copy(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(String src, String dst) throws IOException {
        FsManager manager = FsManagerLocator.SINGLETON.get();
        try {
            FsDefaultDriver driver = new FsDefaultDriver((FsDriverProvider)FsDriverLocator.SINGLETON);
            URI srcUri = URI.create(src);
            srcUri = srcUri.isAbsolute() ? srcUri : new TFile(src).toURI();
            FsPath srcPath = FsPath.create((URI)srcUri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            InputSocket srcSocket = manager.getController(srcPath.getMountPoint(), (FsCompositeDriver)driver).getInputSocket(srcPath.getEntryName(), BitField.noneOf(FsInputOption.class));
            URI dstUri = URI.create(dst);
            dstUri = dstUri.isAbsolute() ? dstUri : new TFile(dst).toURI();
            FsPath dstPath = FsPath.create((URI)dstUri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            OutputSocket dstSocket = manager.getController(dstPath.getMountPoint(), (FsCompositeDriver)driver).getOutputSocket(dstPath.getEntryName(), BitField.of((Enum)FsOutputOption.CREATE_PARENTS, (Enum[])new FsOutputOption[]{FsOutputOption.EXCLUSIVE}), (Entry)srcSocket.getLocalTarget());
            IOSocket.copy((InputSocket)srcSocket, (OutputSocket)dstSocket);
        }
        finally {
            manager.sync(FsManager.UMOUNT);
        }
    }
}

