/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.file.app;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileComparator;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.archive.tar.TarBZip2Driver;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarGZipDriver;
import de.schlichtherle.truezip.fs.archive.zip.CheckedJarDriver;
import de.schlichtherle.truezip.fs.archive.zip.CheckedReadOnlySfxDriver;
import de.schlichtherle.truezip.fs.archive.zip.CheckedZipDriver;
import de.schlichtherle.truezip.sample.file.app.Application;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

@DefaultAnnotation(value={NonNull.class})
public class Nzip
extends Application {
    private static final ResourceBundle resources = ResourceBundle.getBundle(Nzip.class.getName());
    private static final IOPoolProvider POOL_PROVIDER = IOPoolLocator.SINGLETON;
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private final FieldPosition fpos = new FieldPosition(0);

    protected TArchiveDetector newArchiveDetector() {
        return new TArchiveDetector((FsDriverProvider)TArchiveDetector.ALL, (Object[][])new Object[][]{{"ear|jar|war", new CheckedJarDriver(POOL_PROVIDER)}, {"zip", new CheckedZipDriver(POOL_PROVIDER)}, {"exe", new CheckedReadOnlySfxDriver(POOL_PROVIDER)}});
    }

    protected TArchiveDetector newArchiveDetector(final Charset charset) {
        assert (null != charset);
        return new TArchiveDetector((FsDriverProvider)TArchiveDetector.ALL, (Object[][])new Object[][]{{"ear|jar|war|zip", new CheckedZipDriver(POOL_PROVIDER){

            public Charset getCharset() {
                return charset;
            }
        }}, {"exe", new CheckedReadOnlySfxDriver(POOL_PROVIDER){

            public Charset getCharset() {
                return charset;
            }
        }}, {"tar", new TarDriver(POOL_PROVIDER){

            public Charset getCharset() {
                return charset;
            }
        }}, {"tgz|tar.gz", new TarGZipDriver(POOL_PROVIDER){

            public Charset getCharset() {
                return charset;
            }
        }}, {"tbz|tb2|tar.bz2", new TarBZip2Driver(POOL_PROVIDER){

            public Charset getCharset() {
                return charset;
            }
        }}});
    }

    public static void main(String[] args) throws FsSyncException {
        System.exit(new Nzip().run(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int runChecked(String[] args) throws IllegalUsageException, IOException {
        block26: {
            if (args.length < 1) {
                throw new IllegalUsageException();
            }
            String cmd = args[0].toLowerCase(Locale.ENGLISH);
            args = Nzip.lshift(args);
            TArchiveDetector oldDetector = TFile.getDefaultArchiveDetector();
            try {
                TFile.setDefaultArchiveDetector((TArchiveDetector)this.newArchiveDetector());
                if ("ls".equals(cmd)) {
                    this.ls(args, false, false);
                    break block26;
                }
                if ("ll".equals(cmd)) {
                    this.ls(args, true, false);
                    break block26;
                }
                if ("llr".equals(cmd)) {
                    this.ls(args, true, true);
                    break block26;
                }
                if ("cat".equals(cmd)) {
                    this.cat(args);
                    break block26;
                }
                if ("compact".equals(cmd)) {
                    this.compact(args);
                    break block26;
                }
                if ("cp".equals(cmd)) {
                    this.cpOrMv(args, false);
                    break block26;
                }
                if ("mv".equals(cmd)) {
                    this.cpOrMv(args, true);
                    break block26;
                }
                if ("touch".equals(cmd)) {
                    this.touch(args);
                    break block26;
                }
                if ("mkdir".equals(cmd)) {
                    this.mkdir(args, false);
                    break block26;
                }
                if ("mkdirs".equals(cmd)) {
                    this.mkdir(args, true);
                    break block26;
                }
                if ("rm".equals(cmd)) {
                    this.rm(args, false);
                    break block26;
                }
                if ("rmr".equals(cmd)) {
                    this.rm(args, true);
                    break block26;
                }
                if ("isarchive".equals(cmd)) {
                    int n = this.isArchive(args) ? 0 : 1;
                    return n;
                }
                if ("isdirectory".equals(cmd)) {
                    int n = this.isDirectory(args) ? 0 : 1;
                    return n;
                }
                if ("isfile".equals(cmd)) {
                    int n = this.isFile(args) ? 0 : 1;
                    return n;
                }
                if ("exists".equals(cmd)) {
                    int n = this.exists(args) ? 0 : 1;
                    return n;
                }
                if ("length".equals(cmd)) {
                    int n = this.length(args) ? 0 : 1;
                    return n;
                }
                throw new IllegalUsageException();
            }
            finally {
                TFile.setDefaultArchiveDetector((TArchiveDetector)oldDetector);
            }
        }
        return 0;
    }

    private static String[] lshift(String[] args) {
        return Nzip.lshift(args, 1);
    }

    private static String[] lshift(String[] args, int num) {
        int rem = args.length - num;
        if (rem < 0) {
            throw new IllegalArgumentException();
        }
        String[] ret = new String[rem];
        System.arraycopy(args, num, ret, 0, rem);
        return ret;
    }

    private void ls(String[] args, boolean detailed, boolean recursive) throws IOException {
        if (args.length <= 0) {
            args = new String[]{"."};
        }
        for (int i = 0; i < args.length; ++i) {
            TFile file = new TFile(args[i]);
            if (args.length > 1) {
                this.out.println(args[i] + ":");
            }
            if (file.isDirectory()) {
                this.ls(file, "", detailed, recursive);
                continue;
            }
            this.ls(file, file.getPath(), detailed, recursive);
        }
    }

    private void ls(TFile file, String path, boolean detailed, boolean recursive) throws IOException {
        if (file.isDirectory()) {
            TFile[] entries = file.listFiles();
            if (entries == null) {
                throw new IOException(path + " (" + resources.getString("ls.dia") + ")");
            }
            Arrays.sort(entries, new TFileComparator());
            for (int i = 0; i < entries.length; ++i) {
                TFile entry = entries[i];
                String entryPath = path.length() > 0 ? path + TFile.separator + entry.getName() : entry.getName();
                this.ls(entry, entryPath, detailed);
                if (!recursive || !entry.isDirectory()) continue;
                this.ls(entries[i], entryPath, detailed, true);
            }
        } else if (file.exists()) {
            this.ls(file, path, detailed);
        } else {
            throw new IOException(path + " (" + resources.getString("ls.nsfod") + ")");
        }
    }

    private void ls(TFile file, String path, boolean detailed) {
        StringBuffer buf = new StringBuffer();
        if (detailed) {
            this.align(buf, file.length(), 11);
            buf.append(' ');
            buf.append(this.dateFormat.format(new Date(file.lastModified())));
            buf.append(' ');
        }
        buf.append(path);
        if (detailed) {
            buf.append(file.isDirectory() ? (file.isFile() ? "+" : TFile.separator) : (file.isFile() ? "" : (file.exists() ? "?" : "\u2020")));
        }
        this.out.println(buf.toString());
    }

    private void align(StringBuffer buf, long number, int spacing) {
        int length = buf.length();
        this.numberFormat.format(number, buf, this.fpos);
        int i = spacing - this.fpos.getEndIndex();
        while (--i >= 0) {
            buf.insert(length, ' ');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cat(String[] args) throws IllegalUsageException, IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            TFileInputStream in = new TFileInputStream(args[i]);
            try {
                TFile.cat((InputStream)in, (OutputStream)this.out);
                continue;
            }
            finally {
                in.close();
            }
        }
    }

    private void compact(String[] args) throws IllegalUsageException, IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            TFile file = new TFile(args[i]);
            if (file.isArchive()) {
                file.compact();
                continue;
            }
            this.err.println(file + " (" + resources.getString("compact.na") + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cpOrMv(String[] args, boolean mv) throws IllegalUsageException, IOException {
        int srcI;
        if (args.length < 2) {
            throw new IllegalUsageException();
        }
        boolean unzip = false;
        boolean cp437out = false;
        boolean utf8out = false;
        boolean cp437in = false;
        boolean utf8in = false;
        boolean store = false;
        boolean compress = false;
        boolean grow = false;
        boolean encrypt = false;
        for (srcI = 0; srcI < args.length && args[srcI].charAt(0) == '-'; ++srcI) {
            if (mv) {
                throw new IllegalUsageException();
            }
            String opt = args[srcI].toLowerCase(Locale.ENGLISH);
            if ("-unzip".equals(opt)) {
                unzip = true;
                continue;
            }
            if ("-cp437out".equals(opt)) {
                cp437out = true;
                continue;
            }
            if ("-utf8out".equals(opt)) {
                utf8out = true;
                continue;
            }
            if ("-cp437in".equals(opt)) {
                cp437in = true;
                continue;
            }
            if ("-utf8in".equals(opt)) {
                utf8in = true;
                continue;
            }
            if ("-store".equals(opt)) {
                store = true;
                continue;
            }
            if ("-compress".equals(opt)) {
                compress = true;
                continue;
            }
            if ("-grow".equals(opt)) {
                grow = true;
                continue;
            }
            if ("-encrypt".equals(opt)) {
                encrypt = true;
                continue;
            }
            throw new IllegalUsageException();
        }
        TArchiveDetector srcDetector = cp437in ? this.newArchiveDetector(Charset.forName("IBM437")) : (utf8in ? this.newArchiveDetector(Charset.forName("UTF-8")) : TFile.getDefaultArchiveDetector());
        TArchiveDetector dstDetector = unzip ? TArchiveDetector.NULL : (cp437out ? this.newArchiveDetector(Charset.forName("IBM437")) : (utf8out ? this.newArchiveDetector(Charset.forName("UTF-8")) : TFile.getDefaultArchiveDetector()));
        int dstI = args.length - 1;
        TFile dst = new TFile(args[dstI], dstDetector);
        if (dstI - srcI < 1 || dstI - srcI > 1 && !dst.isArchive() && !dst.isDirectory()) {
            throw new IllegalUsageException();
        }
        TConfig config = TConfig.push();
        try {
            config.setOutputPreferences(config.getOutputPreferences().set((Enum)FsOutputOption.STORE, store).set((Enum)FsOutputOption.COMPRESS, compress).set((Enum)FsOutputOption.GROW, grow).set((Enum)FsOutputOption.ENCRYPT, encrypt));
            for (int i = srcI; i < dstI; ++i) {
                TFile tmp;
                TFile src = new TFile(args[i], srcDetector);
                TFile tFile = tmp = dstI - srcI > 1 || dst.isDirectory() ? new TFile((File)dst, src.getName(), dstDetector) : dst;
                if (mv) {
                    try {
                        if (tmp.isFile()) {
                            tmp.rm();
                        }
                        src.mv((File)tmp);
                        continue;
                    }
                    catch (IOException ex) {
                        throw new IOException(src + ": " + resources.getString("cpOrMv.cmt") + ": " + tmp, ex);
                    }
                }
                TFile.cp_rp((File)src, (File)tmp, (TArchiveDetector)srcDetector, (TArchiveDetector)dstDetector);
            }
        }
        finally {
            config.close();
        }
    }

    private void touch(String[] args) throws IllegalUsageException, IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            TFile file = new TFile(args[i]);
            boolean ok = !file.exists() ? file.createNewFile() : file.setLastModified(System.currentTimeMillis());
            if (ok) continue;
            String msg = !file.exists() ? resources.getString("touch.ccf") : (file.isDirectory() ? resources.getString("touch.culmtod") : (file.isFile() ? resources.getString("touch.culmtof") : resources.getString("touch.culmtosfod")));
            throw new IOException(file + " (" + msg + ")");
        }
    }

    private void mkdir(String[] args, boolean recursive) throws IllegalUsageException, IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            boolean ok;
            TFile file = new TFile(args[i]);
            boolean bl = ok = recursive ? file.mkdirs() : file.mkdir();
            if (ok) continue;
            String msg = !file.exists() ? resources.getString("mkdir.ccd") : (file.isDirectory() ? resources.getString("mkdir.dea") : (file.isFile() ? resources.getString("mkdir.fea") : resources.getString("mkdir.sfodea")));
            throw new IOException(file + " (" + msg + ")");
        }
    }

    private void rm(String[] args, boolean recursive) throws IllegalUsageException, IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            TFile file = new TFile(args[i]);
            try {
                if (recursive) {
                    file.rm_r();
                    continue;
                }
                file.rm();
                continue;
            }
            catch (IOException ex) {
                String msg = !file.exists() ? resources.getString("rm.nsfod") : (file.isDirectory() ? (file.list().length > 0 ? resources.getString("rm.dne") : resources.getString("rm.crd")) : (file.isFile() ? resources.getString("rm.crf") : resources.getString("rm.crsfod")));
                throw new IOException(file + " (" + msg + ")", ex);
            }
        }
    }

    private boolean isArchive(String[] args) throws IllegalUsageException {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        boolean success = new TFile(args[0]).isArchive();
        this.out.println(success);
        return success;
    }

    private boolean isDirectory(String[] args) throws IllegalUsageException {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        boolean success = new TFile(args[0]).isDirectory();
        this.out.println(success);
        return success;
    }

    private boolean isFile(String[] args) throws IllegalUsageException {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        boolean success = new TFile(args[0]).isFile();
        this.out.println(success);
        return success;
    }

    private boolean exists(String[] args) throws IllegalUsageException {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        boolean success = new TFile(args[0]).exists();
        this.out.println(success);
        return success;
    }

    private boolean length(String[] args) throws IllegalUsageException {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        long length = new TFile(args[0]).length();
        this.out.println(length);
        return true;
    }

    protected static class IllegalUsageException
    extends Application.IllegalUsageException {
        private static final long serialVersionUID = 2660653252314854276L;

        protected IllegalUsageException() {
            super(resources.getString("usage"));
        }
    }
}

