/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io.swing;

import de.schlichtherle.truezip.io.swing.FileComboBoxBrowser;
import de.schlichtherle.truezip.io.swing.FileComboBoxPanel;
import de.schlichtherle.truezip.swing.JemmyUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.junit.Assert;
import org.junit.Test;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;

public final class FileComboBoxBrowserIT
extends JemmyUtils {
    private static final Logger logger = Logger.getLogger(FileComboBoxBrowserIT.class.getName());

    @Test
    public void testDirectory() {
        FileComboBoxBrowser browser = new FileComboBoxBrowser();
        File cur = new File(".");
        File dir = browser.getDirectory();
        Assert.assertEquals((Object)cur, (Object)dir);
        browser.setDirectory(cur);
        dir = browser.getDirectory();
        Assert.assertSame((Object)cur, (Object)dir);
        browser.setDirectory(null);
        dir = browser.getDirectory();
        Assert.assertEquals((Object)cur, (Object)dir);
    }

    @Test
    public void testState4Update() {
        FileComboBoxBrowser browser = new FileComboBoxBrowser();
        try {
            browser.update("");
            Assert.fail((String)"Calling the previous method should throw a NullPointerException!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        JComboBox combo = new JComboBox();
        browser.setComboBox(combo);
        browser.update("");
    }

    @Test
    public void testAutoCompletion() throws IOException {
        File dir = new File(".");
        this.assertAutoCompletion(dir);
        this.assertAutoCompletion(dir.getCanonicalFile());
    }

    private void assertAutoCompletion(File dir) {
        String[] entries = dir.list();
        if (0 == entries.length) {
            logger.warning("Current directory does not contain any files - skipping test!");
            return;
        }
        JComboBox<String> combo = new JComboBox<String>();
        FileComboBoxBrowser browser = new FileComboBoxBrowser();
        browser.setDirectory(dir);
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i];
            for (int j = 0; j < entry.length(); ++j) {
                FileComboBoxBrowserIT.assertAutoCompletion(browser, combo, entry.substring(0, j));
            }
        }
    }

    private static void assertAutoCompletion(FileComboBoxBrowser browser, JComboBox<String> combo, String initials) {
        browser.setComboBox(null);
        combo.removeAllItems();
        combo.setEditable(true);
        combo.setSelectedItem(initials);
        browser.setComboBox(combo);
        Assert.assertEquals(FileComboBoxBrowserIT.filter(initials), FileComboBoxBrowserIT.asList(combo));
    }

    private static List<String> filter(final String initials) {
        String[] entries = new File(".").list(new FilenameFilter(){
            final int l;
            {
                this.l = initials.length();
            }

            @Override
            public boolean accept(File dir, String name) {
                if (name.length() >= this.l) {
                    return initials.equalsIgnoreCase(name.substring(0, this.l));
                }
                return false;
            }
        });
        Arrays.sort(entries, Collator.getInstance());
        return Arrays.asList(entries);
    }

    private static List<Object> asList(JComboBox<String> combo) {
        LinkedList<Object> list = new LinkedList<Object>();
        ComboBoxModel<String> model = combo.getModel();
        int l = model.getSize();
        for (int i = 0; i < l; ++i) {
            list.add(model.getElementAt(i));
        }
        return list;
    }

    @Test
    public void testGUI() throws InterruptedException {
        JFrameOperator frame = FileComboBoxBrowserIT.showFrameWith(new FileComboBoxPanel(null));
        JTextComponentOperator tc0 = new JTextComponentOperator((ContainerOperator)frame, 0);
        JTextComponentOperator tc1 = new JTextComponentOperator((ContainerOperator)frame, 1);
        tc0.typeText("?");
        tc0.getQueueTool().waitEmpty();
        Assert.assertEquals((Object)"?", (Object)tc1.getText());
        tc1.clearText();
        tc1.getQueueTool().waitEmpty();
        Assert.assertEquals((Object)"", (Object)tc0.getText());
        tc0.pressKey(40);
        tc0.getQueueTool().waitEmpty();
        String child = tc0.getText();
        Assert.assertEquals((Object)child, (Object)tc1.getText());
        frame.dispose();
    }
}

