/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.swing;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.swing.JFrame;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.drivers.ButtonDriver;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.drivers.buttons.ButtonMouseDriver;
import org.netbeans.jemmy.drivers.text.SwingTextKeyboardDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;

public class JemmyUtils {
    protected static final long WAIT_EMPTY = 100L;

    public static void pushJemmyProperties() throws InterruptedException {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JemmyProperties.push();
                    JemmyUtils.setUpJemmyProperties();
                }
            });
        }
        catch (InvocationTargetException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static void popJemmyProperties() throws InterruptedException {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JemmyProperties.pop();
                }
            });
        }
        catch (InvocationTargetException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static void setUpJemmyProperties() {
        JemmyProperties.setCurrentOutput((TestOut)TestOut.getNullOutput());
        DriverManager.setButtonDriver((ButtonDriver)new AtomicButtonDriver());
    }

    protected JemmyUtils() {
    }

    public static JFrameOperator showFrameWith(Component component) throws InterruptedException {
        class Show
        implements Runnable {
            JFrame frame;
            final /* synthetic */ Component val$component;

            Show(Component component) {
                this.val$component = component;
            }

            @Override
            public void run() {
                this.frame = new JFrame();
                this.frame.add(this.val$component);
                this.frame.setDefaultCloseOperation(2);
                this.frame.pack();
                this.frame.setLocationRelativeTo(null);
                this.frame.setVisible(true);
            }
        }
        Show show = new Show(component);
        JemmyUtils.runOnEdtNow(show);
        return new JFrameOperator(show.frame);
    }

    public static void runOnEdt(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    public static void runOnEdtNow(Runnable task) throws InterruptedException {
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (InvocationTargetException ex) {
                throw new UndeclaredThrowableException(ex);
            }
        }
    }

    static {
        JemmyUtils.setUpJemmyProperties();
    }

    private static final class AtomicTextDriver
    extends LightSupportiveDriver
    implements TextDriver {
        final TextDriver delegate = new SwingTextKeyboardDriver();

        public AtomicTextDriver() {
            super(new String[]{JTextComponentOperator.class.getName()});
        }

        public void changeCaretPosition(final ComponentOperator op, final int position) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicTextDriver.this.delegate.changeCaretPosition(op, position);
                }
            });
        }

        public void selectText(final ComponentOperator op, final int startPosition, final int finalPosition) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicTextDriver.this.delegate.selectText(op, startPosition, finalPosition);
                }
            });
        }

        public void clearText(final ComponentOperator op) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicTextDriver.this.delegate.clearText(op);
                }
            });
        }

        public void typeText(final ComponentOperator op, final String text, final int caretPosition) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicTextDriver.this.delegate.typeText(op, text, caretPosition);
                }
            });
        }

        public void changeText(final ComponentOperator op, final String text) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicTextDriver.this.delegate.changeText(op, text);
                }
            });
        }

        public void enterText(final ComponentOperator op, final String text) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicTextDriver.this.delegate.enterText(op, text);
                }
            });
        }
    }

    private static final class AtomicButtonDriver
    extends LightSupportiveDriver
    implements ButtonDriver {
        final ButtonDriver delegate = new ButtonMouseDriver();

        AtomicButtonDriver() {
            super(new String[]{ComponentOperator.class.getName()});
        }

        public void press(final ComponentOperator op) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicButtonDriver.this.delegate.press(op);
                }
            });
        }

        public void release(final ComponentOperator op) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicButtonDriver.this.delegate.release(op);
                }
            });
        }

        public void push(final ComponentOperator op) {
            op.getQueueTool().invoke(new Runnable(){

                @Override
                public void run() {
                    AtomicButtonDriver.this.delegate.push(op);
                }
            });
        }
    }
}

