package de.sebastianhesse.cdk.ses.email.forwarding;

/**
 * A construct for AWS SES to forward all emails of certain domains and email addresses to a list of target email addresses.
 * <p>
 * It also verifies (or at least initiates verification of) the related domains and email addresses in SES.
 * <p>
 * The construct can be helpful if you don't want to host your own SMTP server but still want to receive emails to your existing email inbox.
 * One use case is if you're just building some sort of landing page and want to quickly setup email receiving for your domain without yet another separate email inbox.
 * <p>
 * This construct can...
 * <p>
 * <ul>
 * <li>create a new receipt rule set (or use an existing one),</li>
 * <li>attach a list of rules to forward incoming emails to other target email addresses,</li>
 * <li>verify a given domain in SES (automatically if domain is managed by Route53, otherwise it'll just initiate the verification),</li>
 * <li>initiate verification for all target email addresses that are provided for receiving the forwarded emails.</li>
 * </ul>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.21.0 (build 4262b22)", date = "2021-02-28T09:57:11.547Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = de.sebastianhesse.cdk.ses.email.forwarding.$Module.class, fqn = "@seeebiii/ses-email-forwarding.EmailForwardingRuleSet")
public class EmailForwardingRuleSet extends software.amazon.awscdk.core.Construct {

    protected EmailForwardingRuleSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmailForwardingRuleSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parent This parameter is required.
     * @param name This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmailForwardingRuleSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct parent, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull de.sebastianhesse.cdk.ses.email.forwarding.IEmailForwardingRuleSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parent, "parent is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRuleSet getRuleSet() {
        return software.amazon.jsii.Kernel.get(this, "ruleSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRuleSet.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRuleSet value) {
        software.amazon.jsii.Kernel.set(this, "ruleSet", java.util.Objects.requireNonNull(value, "ruleSet is required"));
    }
}
