package de.sebastianhesse.cdk.ses.email.forwarding;

/**
 * A construct to define an email forwarding rule that can either be used together with {@link EmailForwardingRuleSet} or as a standalone rule.
 * <p>
 * It creates two rule actions:
 * <p>
 * <ul>
 * <li>One S3 action to save all incoming mails to an S3 bucket.</li>
 * <li>One Lambda action to forward all incoming mails to a list of configured emails.</li>
 * </ul>
 * <p>
 * The Lambda function is using the NPM package <code>aws-lambda-ses-forwarder</code> to forward the mails.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.21.0 (build 4262b22)", date = "2021-03-08T08:18:15.885Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = de.sebastianhesse.cdk.ses.email.forwarding.$Module.class, fqn = "@seeebiii/ses-email-forwarding.EmailForwardingRule")
public class EmailForwardingRule extends software.amazon.awscdk.core.Construct {

    protected EmailForwardingRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmailForwardingRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parent This parameter is required.
     * @param name This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmailForwardingRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct parent, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parent, "parent is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param parent This parameter is required.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct parent, final java.lang.String name) {
            return new Builder(parent, name);
        }

        private final software.amazon.awscdk.core.Construct parent;
        private final java.lang.String name;
        private final de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct parent, final java.lang.String name) {
            this.parent = parent;
            this.name = name;
            this.props = new de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleProps.Builder();
        }

        /**
         * The domain name of the email addresses, e.g. 'example.org'. It is used to connect the `fromPrefix` and `receivePrefix` properties with a proper domain.
         * <p>
         * @return {@code this}
         * @param domainName The domain name of the email addresses, e.g. 'example.org'. It is used to connect the `fromPrefix` and `receivePrefix` properties with a proper domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * An email mapping similar to what the NPM library `aws-lambda-ses-forwarder` expects.
         * <p>
         * @return {@code this}
         * @see EmailMapping
         * @param emailMapping An email mapping similar to what the NPM library `aws-lambda-ses-forwarder` expects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailMapping(final java.util.List<? extends de.sebastianhesse.cdk.ses.email.forwarding.EmailMapping> emailMapping) {
            this.props.emailMapping(emailMapping);
            return this;
        }

        /**
         * A prefix that is used as the sender address of the forwarded mail, e.g. `noreply`.
         * <p>
         * @return {@code this}
         * @param fromPrefix A prefix that is used as the sender address of the forwarded mail, e.g. `noreply`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fromPrefix(final java.lang.String fromPrefix) {
            this.props.fromPrefix(fromPrefix);
            return this;
        }

        /**
         * An id for the rule.
         * <p>
         * This will mainly be used to provide a name to the underlying rule but may also be used as a prefix for other resources.
         * <p>
         * @return {@code this}
         * @param id An id for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(final java.lang.String id) {
            this.props.id(id);
            return this;
        }

        /**
         * The rule set this rule belongs to.
         * <p>
         * @return {@code this}
         * @param ruleSet The rule set this rule belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSet(final software.amazon.awscdk.services.ses.ReceiptRuleSet ruleSet) {
            this.props.ruleSet(ruleSet);
            return this;
        }

        /**
         * A bucket to store the email files to.
         * <p>
         * If no bucket is provided, a new one will be created using a managed KMS key to encrypt the bucket.
         * <p>
         * Default: A new bucket will be created.
         * <p>
         * @return {@code this}
         * @param bucket A bucket to store the email files to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.Bucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * A prefix for the email files that are saved to the bucket.
         * <p>
         * Default: inbox/
         * <p>
         * @return {@code this}
         * @param bucketPrefix A prefix for the email files that are saved to the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(final java.lang.String bucketPrefix) {
            this.props.bucketPrefix(bucketPrefix);
            return this;
        }

        /**
         * @returns a newly built instance of {@link de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRule build() {
            return new de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRule(
                this.parent,
                this.name,
                this.props.build()
            );
        }
    }
}
