package de.sebastianhesse.cdk.ses.email.forwarding;

/**
 * A construct for AWS SES to forward all emails of certain domains and email addresses to a list of target email addresses.
 * <p>
 * It also verifies (or at least initiates verification of) the related domains and email addresses in SES.
 * <p>
 * The construct can be helpful if you don't want to host your own SMTP server but still want to receive emails to your existing email inbox.
 * One use case is if you're just building some sort of landing page and want to quickly setup email receiving for your domain without yet another separate email inbox.
 * <p>
 * This construct can...
 * <p>
 * <ul>
 * <li>create a new receipt rule set (or use an existing one),</li>
 * <li>attach a list of rules to forward incoming emails to other target email addresses,</li>
 * <li>verify a given domain in SES (automatically if domain is managed by Route53, otherwise it'll just initiate the verification),</li>
 * <li>initiate verification for all target email addresses that are provided for receiving the forwarded emails.</li>
 * </ul>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-27T09:56:00.627Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = de.sebastianhesse.cdk.ses.email.forwarding.$Module.class, fqn = "@seeebiii/ses-email-forwarding.EmailForwardingRuleSet")
public class EmailForwardingRuleSet extends software.amazon.awscdk.core.Construct {

    protected EmailForwardingRuleSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmailForwardingRuleSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parent This parameter is required.
     * @param name This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmailForwardingRuleSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct parent, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parent, "parent is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> getEmailForwardingMappings() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "emailForwardingMappings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRuleSet getRuleSet() {
        return software.amazon.jsii.Kernel.get(this, "ruleSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IReceiptRuleSet.class));
    }

    /**
     * A fluent builder for {@link de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param parent This parameter is required.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct parent, final java.lang.String name) {
            return new Builder(parent, name);
        }

        private final software.amazon.awscdk.core.Construct parent;
        private final java.lang.String name;
        private final de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleSetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct parent, final java.lang.String name) {
            this.parent = parent;
            this.name = name;
            this.props = new de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleSetProps.Builder();
        }

        /**
         * A list of mapping options to define how emails should be forwarded.
         * <p>
         * @return {@code this}
         * @param emailForwardingProps A list of mapping options to define how emails should be forwarded. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailForwardingProps(final java.util.List<? extends de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingProps> emailForwardingProps) {
            this.props.emailForwardingProps(emailForwardingProps);
            return this;
        }

        /**
         * Optional: whether to enable the rule set or not.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableRuleSet Optional: whether to enable the rule set or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableRuleSet(final java.lang.Boolean enableRuleSet) {
            this.props.enableRuleSet(enableRuleSet);
            return this;
        }

        /**
         * Optional: an existing SES receipt rule set.
         * <p>
         * If none is provided, a new one will be created using the name provided with <code>ruleSetName</code> or a default one.
         * <p>
         * @return {@code this}
         * @param ruleSet Optional: an existing SES receipt rule set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSet(final software.amazon.awscdk.services.ses.IReceiptRuleSet ruleSet) {
            this.props.ruleSet(ruleSet);
            return this;
        }

        /**
         * Optional: provide a name for the receipt rule set that this construct creates if you don't provide one.
         * <p>
         * Default: custom-rule-set
         * <p>
         * @return {@code this}
         * @param ruleSetName Optional: provide a name for the receipt rule set that this construct creates if you don't provide one. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetName(final java.lang.String ruleSetName) {
            this.props.ruleSetName(ruleSetName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleSet build() {
            return new de.sebastianhesse.cdk.ses.email.forwarding.EmailForwardingRuleSet(
                this.parent,
                this.name,
                this.props.build()
            );
        }
    }
}
