package de.sebastianhesse.cdk.ses.verify.constructs;

/**
 * A construct to verify a SES domain identity.
 * <p>
 * It initiates a domain verification and can automatically create appropriate records in Route53 to verify the domain. Also, it's possible to attach a notification topic for bounces, complaints or delivery notifications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>{@code
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * VerifySesDomain.Builder.create(this, "SesDomainVerification")
 *         .domainName("example.org")
 *         .build();}</pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-13T11:59:22.049Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = de.sebastianhesse.cdk.ses.verify.constructs.$Module.class, fqn = "@seeebiii/ses-verify-identities.VerifySesDomain")
public class VerifySesDomain extends software.amazon.awscdk.core.Construct {

    protected VerifySesDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VerifySesDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parent This parameter is required.
     * @param name This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VerifySesDomain(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct parent, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parent, "parent is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param domainName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getHostedZone(final @org.jetbrains.annotations.NotNull java.lang.String domainName) {
        return software.amazon.jsii.Kernel.call(this, "getHostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class), new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required") });
    }
}
