/**
 * <h1>&#64;seeebiii/ses-verify-identities</h1>
 * <p>
 * This package provides two constructs helping you to verify identities in <a href="https://aws.amazon.com/ses/">AWS SES</a> using the <a href="https://aws.amazon.com/cdk/">AWS CDK</a>.
 * <p>
 * For more information about verifying identities in AWS SES, <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">read the documentation</a>.
 * <p>
 * <h2>Install</h2>
 * <p>
 * <h3>npm</h3>
 * <p>
 * <blockquote><pre>
 * npm i -D &#64;seeebiii/ses-verify-identities
 * </pre></blockquote>
 * <p>
 * See more details on npmjs.com: https://www.npmjs.com/package/&#64;seeebiii/ses-verify-identities
 * <p>
 * <h3>Maven</h3>
 * <p>
 * <blockquote><pre>
 * &lt;dependency&gt;
 *   &lt;groupId&gt;de.sebastianhesse.cdk-constructs&lt;/groupId&gt;
 *   &lt;artifactId&gt;ses-verify-identities&lt;/artifactId&gt;
 *   &lt;version&gt;3.0.3&lt;/version&gt;
 * &lt;/dependency&gt;
 * </pre></blockquote>
 * <p>
 * See more details on mvnrepository.com: https://mvnrepository.com/artifact/de.sebastianhesse.cdk-constructs/ses-verify-identities/
 * <p>
 * <h3>Python</h3>
 * <p>
 * <blockquote><pre>
 * pip install ses-verify-identities
 * </pre></blockquote>
 * <p>
 * See more details on PyPi: https://pypi.org/project/ses-verify-identities/
 * <p>
 * <h3>Dotnet / C#</h3>
 * <p>
 * You can find the details here: https://www.nuget.org/packages/Ses.Verify.Identities/
 * <p>
 * <h2>Usage</h2>
 * <p>
 * Examples below are based on TypeScript.
 * See <a href="API.md">API.md</a> for a full reference.
 * <p>
 * <h3>Verify a Domain</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * VerifySesDomain.Builder.create(this, "SesDomainVerification")
 *         .domainName("example.org")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h4>Options</h4>
 * <p>
 * <ul>
 * <li><code>domainName</code> A domain name to be used for the SES domain identity, e.g. 'example.org'</li>
 * <li><code>hostedZoneName</code> A hostedZone name to be matched with Route 53 record. e.g. 'example.org'. Default: same as domainName.</li>
 * <li><code>addTxtRecord</code> Whether to automatically add a TXT record to the hosed zone of your domain. This only works if your domain is managed by Route53. Otherwise disable it. Default: <code>true</code>.</li>
 * <li><code>addMxRecord</code> Whether to automatically add a MX record to the hosted zone of your domain. This only works if your domain is managed by Route53. Otherwise disable it. Default: <code>true</code>.</li>
 * <li><code>addDkimRecord</code> Whether to automatically add DKIM records to the hosted zone of your domain. This only works if your domain is managed by Route53. Otherwise disable it. Default: <code>true</code>.</li>
 * <li><code>notificationTopic</code> An SNS topic where bounces, complaints or delivery notifications can be sent to. If none is provided, a new topic will be created and used for all different notification types.</li>
 * <li><code>notificationTypes</code> Select for which notification types you want to configure a topic. Default: <code>[Bounce, Complaint]</code>.</li>
 * </ul>
 * <p>
 * <h3>Verify an Email Address</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * VerifySesEmailAddress.Builder.create(this, "SesEmailVerification")
 *         .emailAddress("hello&#64;example.org")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h4>Options</h4>
 * <p>
 * <ul>
 * <li><code>emailAddress</code> The email address to be verified, e.g. <code>hello&#64;example.org</code>.</li>
 * <li><code>region</code> An optional AWS region to validate the email address. Default: The custom resource will be created in the stack region.</li>
 * </ul>
 * <p>
 * <h2>Contributing</h2>
 * <p>
 * I'm happy to receive any contributions!
 * Just open an issue or pull request :)
 * <p>
 * These commands should help you while developing:
 * <p>
 * <ul>
 * <li><code>npx projen</code>         synthesize changes in <a href=".projenrc.js">.projenrc.js</a> to the project</li>
 * <li><code>npm run build</code>      compile typescript to js</li>
 * <li><code>npm run watch</code>      watch for changes and compile</li>
 * <li><code>npm run test</code>       perform the jest unit tests</li>
 * <li><code>npm run lint</code>       validate code against best practices</li>
 * </ul>
 * <p>
 * <h2>Author</h2>
 * <p>
 * <a href="https://www.sebastianhesse.de">Sebastian Hesse</a> - Freelancer for serverless cloud projects on AWS.
 * <p>
 * <h2>License</h2>
 * <p>
 * MIT License
 * <p>
 * Copyright (c) 2020 <a href="https://www.sebastianhesse.de">Sebastian Hesse</a>
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package de.sebastianhesse.cdk.ses.verify.constructs;
