package de.sebastianhesse.cdk.ses.verify.constructs;

/**
 * A construct to verify a SES domain identity.
 * <p>
 * It initiates a domain verification and can automatically create appropriate records in Route53 to verify the domain. Also, it's possible to attach a notification topic for bounces, complaints or delivery notifications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * new VerifySesDomain(this, 'SesDomainVerification', {
 *   domainName: 'example.org'
 * });
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.59.0 (build eb02c92)", date = "2022-06-02T06:59:06.352Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = de.sebastianhesse.cdk.ses.verify.constructs.$Module.class, fqn = "@seeebiii/ses-verify-identities.VerifySesDomain")
public class VerifySesDomain extends software.constructs.Construct {

    protected VerifySesDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VerifySesDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parent This parameter is required.
     * @param name This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VerifySesDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct parent, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parent, "parent is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param domainName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getHostedZone(final @org.jetbrains.annotations.NotNull java.lang.String domainName) {
        return software.amazon.jsii.Kernel.call(this, "getHostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class), new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required") });
    }

    /**
     * A fluent builder for {@link de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param parent This parameter is required.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct parent, final java.lang.String name) {
            return new Builder(parent, name);
        }

        private final software.constructs.Construct parent;
        private final java.lang.String name;
        private final de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesDomainProps.Builder props;

        private Builder(final software.constructs.Construct parent, final java.lang.String name) {
            this.parent = parent;
            this.name = name;
            this.props = new de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesDomainProps.Builder();
        }

        /**
         * A domain name to be used for the SES domain identity, e.g. 'sub-domain.example.org'.
         * <p>
         * @return {@code this}
         * @param domainName A domain name to be used for the SES domain identity, e.g. 'sub-domain.example.org'. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * Whether to automatically add DKIM records to the hosted zone of your domain.
         * <p>
         * This only works if your domain is managed by Route53. Otherwise disable it.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param addDkimRecords Whether to automatically add DKIM records to the hosted zone of your domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addDkimRecords(final java.lang.Boolean addDkimRecords) {
            this.props.addDkimRecords(addDkimRecords);
            return this;
        }

        /**
         * Whether to automatically add a MX record to the hosted zone of your domain.
         * <p>
         * This only works if your domain is managed by Route53. Otherwise disable it.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param addMxRecord Whether to automatically add a MX record to the hosted zone of your domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addMxRecord(final java.lang.Boolean addMxRecord) {
            this.props.addMxRecord(addMxRecord);
            return this;
        }

        /**
         * Whether to automatically add a TXT record to the hosed zone of your domain.
         * <p>
         * This only works if your domain is managed by Route53. Otherwise disable it.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param addTxtRecord Whether to automatically add a TXT record to the hosed zone of your domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addTxtRecord(final java.lang.Boolean addTxtRecord) {
            this.props.addTxtRecord(addTxtRecord);
            return this;
        }

        /**
         * A hostedZone name to be matched with Route 53 record.
         * <p>
         * e.g. 'example.org'
         * <p>
         * Default: same as domainName
         * <p>
         * @return {@code this}
         * @param hostedZoneName A hostedZone name to be matched with Route 53 record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneName(final java.lang.String hostedZoneName) {
            this.props.hostedZoneName(hostedZoneName);
            return this;
        }

        /**
         * An SNS topic where bounces, complaints or delivery notifications can be sent to.
         * <p>
         * If none is provided, a new topic will be created and used for all different notification types.
         * <p>
         * Default: new topic will be created
         * <p>
         * @return {@code this}
         * @param notificationTopic An SNS topic where bounces, complaints or delivery notifications can be sent to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopic(final software.amazon.awscdk.services.sns.Topic notificationTopic) {
            this.props.notificationTopic(notificationTopic);
            return this;
        }

        /**
         * Select for which notification types you want to configure a topic.
         * <p>
         * Default: [Bounce, Complaint]
         * <p>
         * @return {@code this}
         * @param notificationTypes Select for which notification types you want to configure a topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTypes(final java.util.List<java.lang.String> notificationTypes) {
            this.props.notificationTypes(notificationTypes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain build() {
            return new de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain(
                this.parent,
                this.name,
                this.props.build()
            );
        }
    }
}
