package de.sebastianhesse.cdk.ses.verify.constructs;

/**
 * A construct to verify an SES email address identity.
 * <p>
 * It initiates a verification so that SES sends a verification email to the desired email address. This means the owner of the email address still needs to act by clicking the link in the verification email.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * .org'
 * });
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-11T08:59:10.888Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = de.sebastianhesse.cdk.ses.verify.constructs.$Module.class, fqn = "@seeebiii/ses-verify-identities.VerifySesEmailAddress")
public class VerifySesEmailAddress extends software.constructs.Construct {

    protected VerifySesEmailAddress(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VerifySesEmailAddress(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parent This parameter is required.
     * @param name This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VerifySesEmailAddress(final @org.jetbrains.annotations.NotNull software.constructs.Construct parent, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesEmailAddressProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parent, "parent is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link de.sebastianhesse.cdk.ses.verify.constructs.VerifySesEmailAddress}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<de.sebastianhesse.cdk.ses.verify.constructs.VerifySesEmailAddress> {
        /**
         * @return a new instance of {@link Builder}.
         * @param parent This parameter is required.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct parent, final java.lang.String name) {
            return new Builder(parent, name);
        }

        private final software.constructs.Construct parent;
        private final java.lang.String name;
        private final de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesEmailAddressProps.Builder props;

        private Builder(final software.constructs.Construct parent, final java.lang.String name) {
            this.parent = parent;
            this.name = name;
            this.props = new de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesEmailAddressProps.Builder();
        }

        /**
         * The email address to be verified, e.g. 'hello@example.org'.
         * <p>
         * @return {@code this}
         * @param emailAddress The email address to be verified, e.g. 'hello@example.org'. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailAddress(final java.lang.String emailAddress) {
            this.props.emailAddress(emailAddress);
            return this;
        }

        /**
         * An optional AWS region to validate the email address.
         * <p>
         * Default: The custom resource will be created in the stack region
         * <p>
         * @return {@code this}
         * @param region An optional AWS region to validate the email address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * Whether to DESTROY or RETAIN the email address on removal.
         * <p>
         * Default: DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Whether to DESTROY or RETAIN the email address on removal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link de.sebastianhesse.cdk.ses.verify.constructs.VerifySesEmailAddress}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public de.sebastianhesse.cdk.ses.verify.constructs.VerifySesEmailAddress build() {
            return new de.sebastianhesse.cdk.ses.verify.constructs.VerifySesEmailAddress(
                this.parent,
                this.name,
                this.props.build()
            );
        }
    }
}
