/**
 * <h1>projen-test</h1>
 * <p>
 * This project tests and describes the workflow of creating an <a href="https://aws.amazon.com/cdk/">AWS CDK</a> construct using <a href="https://github.com/projen/projen">projen</a> + <a href="https://github.com/aws/jsii">jsii</a> and publishing it to various repositories like npm, Maven Central, PyPi and NuGet.
 * <p>
 * In order to verify the process is working as expected, this project contains an <a href="src/index.ts"><code>InlineLambdaConstruct</code></a>.
 * It only creates a very simple Lambda function using inline code that prints out the event it's receiving.
 * Btw. did you know there are multiple <a href="https://www.sebastianhesse.de/2021/01/16/5-ways-to-bundle-a-lambda-function-within-an-aws-cdk-construct/">ways to bundle an AWS Lambda function in a CDK construct</a>?
 * <p>
 * <h2>Questions?</h2>
 * <p>
 * Do you have further questions?
 * Feel free to reach out via <a href="https://twitter.com/seeebiii">Twitter</a> or visit my website - I'm a <a href="https://www.sebastianhesse.de">Freelance Software Engineer</a> focusing on serverless cloud projects.
 * <p>
 * There's also a <a href="https://cdk.dev/">CDK developer Slack workspace</a> that you can join to ask questions.
 * <p>
 * <h2>Table of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#about-projen">About projen</a></li>
 * <li><a href="#about-jsii">About jsii</a></li>
 * <li><a href="#requirements">Requirements</a></li>
 * <li><a href="#setup-project">Setup Project</a>
 * <p>
 * <ul>
 * <li><a href="#write-cdk-construct">Write CDK Construct</a></li>
 * <li><a href="#connect-to-github">Connect to GitHub</a></li>
 * <li><a href="#publishing-to-different-repositories">Publish to Different Repositories</a></li>
 * </ul></li>
 * <li><a href="#verify-your-cdk-construct">Verify Your CDK Construct</a></li>
 * <li><a href="#additional-help">Additional Help</a></li>
 * </ul>
 * <p>
 * <h2>About projen</h2>
 * <p>
 * <a href="https://github.com/projen/projen">projen</a> is a tool to write your project configuration using code instead of managing it yourself.
 * It was initially created to help you writing CDK constructs but can also be used to create any other project stub like a React app.
 * <p>
 * The important thing to note is that you only define the project configuration in the <a href=".projenrc.js">.projenrc.js</a> file and it will generate everything for you, like <code>package.json</code> or other files.
 * <strong>Remember:</strong> do not manually change the generated files, otherwise changes will be lost after you run <code>projen</code> again.
 * <p>
 * Besides that, it is recommended to create an alias in your command line to avoid typing <code>npx projen</code> over and over again.
 * For example: <code>alias pj='npx projen'</code>
 * <p>
 * Further links:
 * <p>
 * <ul>
 * <li><a href="https://dev.to/aws-builders/a-beginner-s-guide-to-create-aws-cdk-construct-library-with-projen-5eh4">A Beginner's Guide to Create AWS CDK Construct Library with projen</a></li>
 * <li><a href="https://www.matthewbonig.com/2020/10/04/converting-to-projen/">Converting a CDK construct to using projen</a></li>
 * </ul>
 * <p>
 * <h2>About jsii</h2>
 * <p>
 * <a href="https://github.com/aws/jsii">jsii</a> is the technology behind the AWS CDK that allows you to write CDK constructs in TypeScript/JavaScript and compile them to other languages like Java or Python.
 * <p>
 * There are a few jsii related projects that support us in the steps below, e.g. for releasing our artifacts.
 * <p>
 * <h2>Requirements</h2>
 * <p>
 * <ul>
 * <li>Node.js/npm installed on your machine</li>
 * <li>AWS CDK installed on your machine</li>
 * <li>GitHub Account (free account is enough)</li>
 * </ul>
 * <p>
 * <h3>Optional</h3>
 * <p>
 * <ul>
 * <li>AWS Account (for verification)</li>
 * <li>Java + Maven (for local packaging &amp; verification)</li>
 * <li>Python (for local packaging &amp; verification)</li>
 * </ul>
 * <p>
 * <h2>Steps For Creating a New CDK Construct Using projen</h2>
 * <p>
 * In case you want to test <code>projen</code> as well, here are the steps I've performed.
 * <p>
 * <h3>Setup Project</h3>
 * <p>
 * <ol>
 * <li>Initialize a new project using <code>projen</code>:
 * <p>
 * <blockquote><pre>
 * mkdir projen-test
 * cd projen-test
 * npx projen new awscdk-construct
 * </pre></blockquote></li>
 * <li>Now create a new Git repository using <code>git init</code> and connect an existing Git project using <code>git remote add origin &lt;REMOTE_URL&gt;</code>.
 * (Create your Git repository in GitHub first before you call <code>git remote add ...</code>)
 * <p>
 * <ul>
 * <li>Note: if your local branch is <code>master</code> but your remote branch is <code>main</code>, then use <code>git branch -M main</code> to rename the local branch.</li>
 * </ul></li>
 * <li>Create an alias for your command-line if you haven't done already: <code>alias pj='npx projen'</code></li>
 * <li>Adjust the <code>projen</code> options in <code>.projenrc.js</code> a bit. For example:
 * <p>
 * <ul>
 * <li>adjust metadata like <code>name</code>, <code>author</code>, <code>authorName</code>, <code>authorAddress</code>, <code>repositoryUrl</code>.
 * By default <code>name</code> is also used as the <code>name</code> in the generated <code>package.json</code>.
 * However, you can define a custom one by using <code>packageName</code>.</li>
 * <li>add <code>projectType: ProjectType.LIB</code> since we'll create a library</li>
 * <li>add <code>cdkAssert: true</code> for being able to test my CDK construct</li>
 * <li>add <code>cdkDependencies: ['&#64;aws-cdk/core', '&#64;aws-cdk/aws-lambda']</code> to let <code>projen</code> add these CDK dependencies for me</li>
 * <li>optional: add <code>mergify: false</code> if you don't want to use it at the moment</li>
 * <li>optional: explicitly add <code>docgen: true</code> so it automatically generates API documentation 🙌</li>
 * <li>optional: explicitly add <code>eslint: true</code> to make sure you use common coding standards</li>
 * <li>optional: add <code>dependabot: true</code> and <code>dependabotOptions: {...}</code> to enable <a href="https://dependabot.com/">Dependabot</a> if you hate managing dependency updates manually</li>
 * <li>optional: add <code>gitignore: ['.idea']</code> if you love using IntelliJ ♥️ but don't want to commit its settings</li>
 * <li>optional: use <code>packageManager: NodePackageManager.NPM</code> if you want to use npm instead of Yarn - might be important in case you are migrating an existing CDK Construct to <code>projen</code>.</li>
 * </ul>
 * <p>
 * Don't forget to add necessary imports in the config file when applying the <code>projen</code> settings, e.g. for using <code>ProjectType</code> or <code>NodePackageManager</code>.</li>
 * <li>Set a version number in <a href="version.json">version.json</a>, e.g. <code>0.0.1</code>.</li>
 * <li>Run <code>pj</code> again on your command-line.
 * This will update all project files like <a href="package.json">package.json</a> and similar based on what you have configured in <a href=".projenrc.js">.projenrc.js</a>.
 * Remember to not manually update these files as <code>projen</code> will override your changes otherwise.</li>
 * </ol>
 * <p>
 * <h3>Write CDK Construct</h3>
 * <p>
 * <ol>
 * <li>Write a simple CDK construct in <a href="src/index.ts">src/index.ts</a>.</li>
 * <li>Write a simple test for this construct in <a href="test/index.test.ts">test/index.test.ts</a>.</li>
 * <li>Run <code>yarn run build</code>.
 * This command will execute the tests using <a href="https://jestjs.io/">Jest</a> and also generate <a href="API.md">API.md</a> 😍</li>
 * </ol>
 * <p>
 * <h3>Connect to GitHub</h3>
 * <p>
 * Add all files to Git, commit and push your changes.
 * <p>
 * <blockquote><pre>
 * # Maybe adjust this to really add all files from every folder, or use IntelliJ or some Git GUI to do this
 * git add .
 * git commit -M "Initial commit"
 * git push -u origin main
 * </pre></blockquote>
 * <p>
 * <h3>Publishing to Different Repositories</h3>
 * <p>
 * If you want to release your package to one or multiple repositories like npm or Maven Central, you'll have to enable this in <a href=".projenrc.js">.projenrc.js</a>.
 * After changing the configuration as described below and calling <code>pj</code> (or <code>npx projen</code> if you're not using the alias), you'll notice that there are a few files in <a href=".github/workflows">.github/workflows</a> folder.
 * They take care of running <a href="https://github.com/features/actions">GitHub Actions</a> to build and release/publish the library to npm and other repositories.
 * The action steps are using <a href="https://github.com/aws/jsii/tree/main/superchain">jsii-superchain</a> as the Docker image to run a step.
 * <p>
 * The release process is also using the npm module <a href="https://github.com/aws/jsii-release">jsii-release</a> to help releasing the artifacts.
 * The project's README is explaining all the different parameters that you need to set for publishing to the different repositories that are supported.
 * Currently npm (Node.js), Maven (Java), NuGet (C#) and PyPi (Python) are supported.
 * <p>
 * <h4>Publish to npm</h4>
 * <p>
 * I'm assuming you already have an <a href="https://www.npmjs.com/">npm</a> account.
 * If not, register first.
 * <p>
 * <ol>
 * <li>Update <a href=".projenrc.js">.projenrc.js</a> and enable npm releases:
 * <p>
 * <ul>
 * <li><code>releaseBranches: ['main']</code></li>
 * <li><code>releaseToNpm: true</code> -&gt; Yes, I want to publish a new version to npm every time :)</li>
 * <li><code>releaseWorkflow: true</code></li>
 * <li>Optional: <code>releaseEveryCommit: true</code> -&gt; will run the release GitHub Action on each push to the defined <code>releaseBranches</code></li>
 * </ul></li>
 * <li>Run <code>pj</code> to update your project files.
 * You'll notice <a href=".github/workflows/release.yml">release.yml</a> contains a few steps to build and release your artifact.
 * The <code>release_npm</code> step requires an <code>NPM_TOKEN</code> so that the GitHub Action can publish your package for you.</li>
 * <li>Create an <a href="https://docs.npmjs.com/about-access-tokens">access token</a> for npm.
 * Use type 'Automation' for the token type.
 * The token will be used in a GitHub Action to release your package.</li>
 * <li>Add the access token as a <a href="https://docs.github.com/en/actions/reference/encrypted-secrets">repository secret</a> to your GitHub repository.
 * Use <code>NPM_TOKEN</code> as name and insert the access token from the previous step.
 * This is</li>
 * <li>Commit and push your changes.
 * If you have configured <code>releaseBranches: ['main']</code> in <a href=".projenrc.js">.projenrc.js</a> as discussed above, then a new Action run is triggered that builds your CDK construct and publishes it to npm.</li>
 * </ol>
 * <p>
 * After the last step, you'll notice that the first GitHub Action should be running.
 * <p>
 * <h4>Publish to Maven Repository</h4>
 * <p>
 * Since we want to make our CDK construct public, I'm describing the steps to publish it to <a href="https://oss.sonatype.org/">Maven Central</a>, the main Maven repository (like npm fo Node.js packages).
 * However, this process requires a few more steps compared to npm.
 * <p>
 * <strong>Maven Requirements</strong>
 * <p>
 * In order to publish to Maven Central, you need an account and also "authenticate" yourself using GPG.
 * This ensures that others can verify the correctness of your artifacts and no one else distributes them to introduce vulnerable code.
 * <p>
 * <ol>
 * <li>Create an account for Maven Central and register your own namespace like <code>org.example</code> if you are the owner of the domain <code>example.org</code>.
 * This is described in <a href="https://central.sonatype.org/pages/ossrh-guide.html#initial-setup">this OSSRH Guide</a>.
 * If you don't have your own domain, you can also use <code>com.github.&lt;your-github-user&gt;</code> instead.
 * The Jira system has a bot installed that helps you verifying your domain or your GitHub user, so just register and create an issue as described.
 * The bot will tell you what to do next 😊</li>
 * <li>Upload a PGP key to a well-known key registry, so other people can verify that the artifacts are from you.
 * This is explained well in the <a href="https://github.com/aws/jsii-release#maven">jsii-release README</a> in the subsection <strong>How to create a GPG key?</strong>.</li>
 * <li>Please save the passphrase of your PGP key somewhere safe, e.g. a password manager.
 * You'll need it in a step below!</li>
 * </ol>
 * <p>
 * <strong>Setup Maven Release Action</strong>
 * <p>
 * <ol>
 * <li>Update <a href=".projenrc.js">.projenrc.js</a> and enable Java releases to Maven Central:
 * <p>
 * <blockquote><pre>
 * publishToMaven: {
 *   mavenGroupId: '&lt;your_package_group_id',
 *   mavenArtifactId: '&lt;your_package_target_id&gt;',
 *   javaPackage: '&lt;your_java_package&gt;',
 * }
 * </pre></blockquote>
 * <p>
 * You can specify anything you want as long as the namespace you've registered with Maven Central is a prefix of <code>mavenGroupId</code>.
 * For example, I have registered <code>de.sebastianhesse</code> since I also own the domain <a href="https://www.sebastianhesse.de">www.sebastianhesse.de</a>.</li>
 * <li>Run <code>pj</code> to update your project files.
 * You'll notice changes in the <a href=".github/workflows/release.yml">release.yml</a> and a new step <code>release_maven</code>.
 * As you can see, it uses a few secrets like <code>MAVEN_GPG_PRIVATE_KEY</code>, <code>MAVEN_GPG_PRIVATE_KEY_PASSPHRASE</code>, <code>MAVEN_USERNAME</code>, <code>MAVEN_PASSWORD</code>, and <code>MAVEN_STAGING_PROFILE_ID</code>.
 * These are the same as described in the <a href="https://github.com/aws/jsii-release#maven">jsii-release README</a>.
 * If you need help figuring out the <code>MAVEN_STAGING_PROFILE_ID</code>, then please see below in the <a href="#additional-help">Additional Help</a> section.</li>
 * <li>Add all the required secrets as <a href="https://docs.github.com/en/actions/reference/encrypted-secrets">repository secrets</a> to your GitHub repository.</li>
 * <li>Commit and push your changes.</li>
 * </ol>
 * <p>
 * Like with the npm release process above, as soon as you push your changes a GitHub Action is triggered and performs the release.
 * You'll notice that the release process for Maven takes a lot more time than the one for npm.
 * Also take care that it might take some time to find your artifact in Maven Central (usually within a few minutes but it can take longer).
 * <p>
 * <h4>Publish to PyPi</h4>
 * <p>
 * TODO
 * <p>
 * Note: If you are eager to go through this tutorial and explore the steps for PyPi / Python, feel free to contribute to this README :)
 * <p>
 * <h3>Publish to NuGet</h3>
 * <p>
 * TODO
 * <p>
 * Note: If you are eager to go through this tutorial and explore the steps for NuGet / C#, feel free to contribute to this README :)
 * <p>
 * <h2>Verify Your CDK Construct</h2>
 * <p>
 * Congratulations 🙌
 * You have successfully published your first CDK construct using <code>projen</code> to multiple repositories.
 * (At least you hope so at the moment 😀)
 * <p>
 * Let's verify that our construct is working as expected in different languages.
 * Since my main programming languages are Java and Node.js/JavaScript, I'll only present those two here.
 * If I have time, I'll add the others as well - or if you want to contribute something? 😉
 * <p>
 * <strong>Note</strong>: when deploying a CDK app, you need to provide the AWS Account ID and Region.
 * You can do this either using environment variables in the CLI or by explicitly providing <code>environment</code> details in the file/class where the CDK app is defined.
 * See <a href="https://docs.aws.amazon.com/cdk/latest/guide/environments.html">this page</a> for further help.
 * <p>
 * <h3>Verify in Node.js</h3>
 * <p>
 * <ol>
 * <li>Initialize a new CDK app in TypeScript:
 * <p>
 * <blockquote><pre>
 * mkdir cdk-npm-test
 * cd cdk-npm-test
 * cdk init app --language=typescript
 * </pre></blockquote>
 * <p>
 * This will initialize a new CDK app project.
 * You can also use <code>--language=javascript</code> which initializes the project using JavaScript instead of TypeScript.
 * In <code>bin/cdk-npm-test.ts</code> you'll find the CDK app definition and in <code>lib/cdk-npm-test-stack.ts</code> you can find the stack definition.</li>
 * <li>Add your new CDK construct as a dev dependency: <code>npm i -D &lt;your-package-name&gt;</code>
 * <p>
 * <strong>Take care</strong> that the versions for all AWS CDK dependencies in <code>package.json</code> (e.g. for <code>aws-cdk</code> or <code>&#64;aws-cdk/core</code>) are matching the version that you have specified in <a href=".projenrc.js">.projenrc.js</a> under <code>cdkVersion</code>.
 * Otherwise you'll see some funny compilation errors.
 * If you need to update the dependencies, you can use <code>npm i -S &lt;dependency&gt;&#64;latest</code> (for dependencies) or <code>npm i -D &lt;dependency&gt;&#64;latest</code> (for dev dependencies).</li>
 * <li>Add your new CDK construct in <code>bin/cdk-npm-test-stack.ts</code> like: <code>new InlineLambdaConstruct(this, 'NpmSample');</code></li>
 * <li>Build your code: <code>npm run build</code></li>
 * <li>Now you can deploy your app using <code>cdk deploy</code>.
 * Wait for the stack to be created and test that everything looks like expected.</li>
 * </ol>
 * <p>
 * <h3>Verify in Java</h3>
 * <p>
 * <ol>
 * <li>Initialize new CDK app in Java:
 * <p>
 * <blockquote><pre>
 * mkdir cdk-java-test
 * cd cdk-java-test
 * cdk init app --language=java
 * </pre></blockquote>
 * <p>
 * This will initialize a new CDK app project.
 * In <code>src/main/java/com/myorg</code> you'll see the files <code>CdkJavaTestApp</code> and <code>CdkJavaTestStack</code> that contain CDK samples.</li>
 * <li>Add the CDK construct you've just published to the project's <code>pom.xml</code>:
 * <p>
 * <blockquote><pre>
 * &lt;dependency&gt;
 *     &lt;groupId&gt;org.example&lt;/groupId&gt;
 *     &lt;artifactId&gt;projen-test&lt;/artifactId&gt;
 *     &lt;version&gt;0.0.1&lt;/version&gt;
 * &lt;/dependency&gt;
 * </pre></blockquote>
 * <p>
 * Replace the Maven coordinates based on your settings that you've configured with <code>publishToMaven</code> in <a href=".projenrc.js">.projenrc.js</a> and the correct version.</li>
 * <li>Then go to <code>CdkJavaTestStack</code> and make use of your CDK construct.
 * In my case, I have added the following line in the constructor: <code>new InlineLambdaConstruct(this, "JavaSample");</code></li>
 * <li>Package your code (including running the tests): <code>mvn package</code></li>
 * <li>Now you can deploy your app using <code>cdk deploy</code>.
 * Wait for the stack to be created and test that everything looks like expected.</li>
 * </ol>
 * <p>
 * <h3>Verify in Python</h3>
 * <p>
 * TODO
 * <p>
 * Note: If you are eager to go through this tutorial and explore the steps for Python, feel free to contribute to this README :)
 * <p>
 * <h3>Verify in C#</h3>
 * <p>
 * TODO
 * <p>
 * Note: If you are eager to go through this tutorial and explore the steps for NuGet / C#, feel free to contribute to this README :)
 * <p>
 * <h2>Additional Help</h2>
 * <p>
 * Below are a few topics that I've discovered along the way and would like to explain further.
 * <p>
 * <h3>Find The <code>MAVEN_STAGING_PROFILE_ID</code></h3>
 * <p>
 * In order to figure out the <code>MAVEN_STAGING_PROFILE_ID</code>, follow these steps:
 * <p>
 * <ul>
 * <li>Login to <a href="https://oss.sonatype.org/">oss.sonatype.org</a> using your Maven Central credentials.</li>
 * <li>On the left, click on <code>Staging Profiles</code></li>
 * <li>In the main window, make sure you select the tab <code>Staging Profiles</code> and select the entry matching your namespace <code>org.example</code></li>
 * <li>You'll notice the URL has changed to <code>https://oss.sonatype.org/#stagingProfiles;12abc3456789</code></li>
 * <li>Use the id after the <code>;</code> semicolon as the <code>MAVEN_STAGING_PROFILE_ID</code></li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package de.sebastianhesse.examples.projen.test;
