/*
 * Decompiled with CFR 0.152.
 */
package de.sematre.mathparser;

import java.util.ArrayList;
import java.util.HashMap;

public class MathParser {
    private HashMap<String, MathFunction> functions = new HashMap();
    private char argumentSeparator = (char)44;
    private String equation = null;
    private Integer position = -1;
    private Integer ch = null;
    private Boolean parsingFunction = false;
    private Double[] args = null;

    public Double parse() {
        if (this.equation == null || this.equation.length() <= 0) {
            MathParsingExeption exeption = new MathParsingExeption("Equation is invalid!", "Equation is invalid!");
            exeption.setEquation(this.equation);
            throw exeption;
        }
        this.position = -1;
        this.ch = null;
        this.nextChar();
        Double x = this.parseExpression();
        if (this.position < this.equation.length()) {
            throw MathParser.createParsingExeption("Unexpected \"" + (char)this.ch.intValue() + "\" at " + (this.position + 1), this.equation, this.position);
        }
        return x;
    }

    public Double parse(String equation) {
        this.setEquation(equation);
        return this.parse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Double parseFactor() {
        Double x;
        block23: {
            if (this.parseChar(43).booleanValue()) {
                return this.parseFactor();
            }
            if (this.parseChar(45).booleanValue()) {
                return -this.parseFactor().doubleValue();
            }
            Integer startPos = this.position;
            x = null;
            if (this.parseChar(40).booleanValue()) {
                if (!this.parsingFunction.booleanValue()) {
                    x = this.parseExpression();
                    this.parseChar(41);
                    break block23;
                } else {
                    this.parsingFunction = false;
                    ArrayList<Double> args = new ArrayList<Double>();
                    args.add(this.parseExpression());
                    while (this.parseChar(this.argumentSeparator).booleanValue()) {
                        args.add(this.parseExpression());
                    }
                    this.args = new Double[args.size()];
                    Integer i = 0;
                    while (true) {
                        if (i >= args.size()) {
                            this.parseChar(41);
                            return null;
                        }
                        this.args[i.intValue()] = (Double)args.get(i);
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                }
            }
            if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    this.nextChar();
                }
                try {
                    x = Double.parseDouble(this.equation.substring(startPos, this.position));
                }
                catch (NumberFormatException e) {
                    Integer n;
                    String string = "Invalid number at " + startPos;
                    if (this.position - startPos == 1) {
                        n = startPos;
                        throw MathParser.createParsingExeption(string, this.equation, startPos, n);
                    }
                    n = this.position;
                    throw MathParser.createParsingExeption(string, this.equation, startPos, n);
                }
            }
            if (this.ch < 97 || this.ch > 122) {
                if (this.ch < 65) throw MathParser.createParsingExeption("Unexpected \"" + (char)this.ch.intValue() + "\" at " + (this.position + 1), this.equation, startPos);
                if (this.ch > 90) throw MathParser.createParsingExeption("Unexpected \"" + (char)this.ch.intValue() + "\" at " + (this.position + 1), this.equation, startPos);
            }
            while (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90 || this.ch == 46) {
                this.nextChar();
            }
            this.nextChar();
            if (this.parseChar(41).booleanValue()) {
                String func = this.equation.substring(startPos, this.position - 2);
                x = this.parseFunction(func, startPos, new Double[0]);
            } else {
                if (this.position > this.equation.length()) {
                    throw MathParser.createParsingExeption("Missing chars: \"()\" at " + this.position, this.equation, this.position - 1, this.position);
                }
                this.previousChar();
                String func = this.equation.substring(startPos, this.position);
                this.parsingFunction = true;
                this.parseFactor();
                try {
                    x = this.parseFunction(func, startPos, this.args);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    int n;
                    String string = "Missing argument for function \"" + func + "\" at " + this.position;
                    if (func.length() == 1) {
                        n = startPos;
                        throw MathParser.createParsingExeption(string, this.equation, startPos, n);
                    }
                    n = startPos + func.length();
                    throw MathParser.createParsingExeption(string, this.equation, startPos, n);
                }
            }
        }
        if (this.parseChar(94).booleanValue()) {
            x = Math.pow(x, this.parseFactor());
        }
        if (this.parseChar(63).booleanValue()) {
            x = x % this.parseFactor();
        }
        if (this.parseChar(37) == false) return x;
        return x / 100.0;
    }

    private Double parseExpression() {
        Double x = this.parseTerm();
        while (true) {
            if (this.parseChar(43).booleanValue()) {
                x = x + this.parseTerm();
                continue;
            }
            if (!this.parseChar(45).booleanValue()) break;
            x = x - this.parseTerm();
        }
        return x;
    }

    private Double parseTerm() {
        Double x = this.parseFactor();
        while (true) {
            if (this.parseChar(42).booleanValue()) {
                x = x * this.parseFactor();
                continue;
            }
            if (!this.parseChar(47).booleanValue()) break;
            x = x / this.parseFactor();
        }
        return x;
    }

    private Double parseFunction(String function, Integer startPos, Double[] args) {
        Double x = null;
        if (function.equalsIgnoreCase("sqrt")) {
            x = Math.sqrt(args[0]);
        } else if (function.equalsIgnoreCase("root")) {
            x = Math.pow(args[1], 1.0 / args[0]);
        } else if (function.equalsIgnoreCase("sin")) {
            x = Math.sin(args[0]);
        } else if (function.equalsIgnoreCase("cos")) {
            x = Math.cos(args[0]);
        } else if (function.equalsIgnoreCase("tan")) {
            x = Math.tan(args[0]);
        } else if (function.equalsIgnoreCase("toRadians")) {
            x = Math.toRadians(args[0]);
        } else if (function.equalsIgnoreCase("toDegrees")) {
            x = Math.toDegrees(args[0]);
        } else if (function.equalsIgnoreCase("log")) {
            x = Math.log(args[0]);
        } else if (function.equalsIgnoreCase("logx")) {
            x = Math.log(args[1]) / Math.log(args[0]);
        } else if (function.equalsIgnoreCase("log10")) {
            x = Math.log10(args[0]);
        } else if (function.equalsIgnoreCase("pi")) {
            x = Math.PI;
        } else if (function.equalsIgnoreCase("e")) {
            x = Math.E;
        } else if (function.equalsIgnoreCase("min")) {
            x = Math.min(args[0], args[1]);
        } else if (function.equalsIgnoreCase("max")) {
            x = Math.max(args[0], args[1]);
        } else if (function.equalsIgnoreCase("random")) {
            x = Math.random();
        } else {
            Double result = null;
            for (String currentFunction : this.functions.keySet()) {
                if (!currentFunction.equalsIgnoreCase(function)) continue;
                result = this.functions.get(currentFunction).execute(args);
                if (result != null) break;
                throw MathParser.createParsingExeption("Function \"" + currentFunction + "\" returns null at " + (startPos + 1), this.equation, startPos, startPos + function.length());
            }
            if (result == null) {
                throw MathParser.createParsingExeption("Unknown function: \"" + function + "\" at " + (startPos + 1), this.equation, startPos, startPos + (function.length() > 1 ? function.length() : 0));
            }
            x = result;
        }
        return x;
    }

    private void nextChar() {
        this.position = this.position + 1;
        this.ch = this.position < this.equation.length() ? (int)this.equation.charAt(this.position) : -1;
    }

    private void previousChar() {
        this.position = this.position - 1;
        this.ch = this.position >= 0 ? (int)this.equation.charAt(this.position) : -1;
    }

    private Boolean parseChar(int regex) {
        while (this.ch == 32) {
            this.nextChar();
        }
        if (this.ch == regex) {
            this.nextChar();
            return true;
        }
        return false;
    }

    public String getEquation() {
        return this.equation;
    }

    public void setEquation(String equation) {
        this.equation = equation;
    }

    public char getArgumentSeparator() {
        return this.argumentSeparator;
    }

    public void setArgumentSeparator(char argumentSeparator) {
        this.argumentSeparator = argumentSeparator;
    }

    public void addFunction(String functionName, MathFunction function) {
        this.functions.put(functionName, function);
    }

    public void removeFunction(String functionName) {
        this.functions.remove(functionName);
    }

    public HashMap<String, MathFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(HashMap<String, MathFunction> functions) {
        this.functions = functions;
    }

    private static MathParsingExeption createParsingExeption(String message, String equation, Integer position) {
        return MathParser.createParsingExeption(message, equation, position, position);
    }

    private static MathParsingExeption createParsingExeption(String message, String equation, Integer position, Integer target) {
        Integer n;
        Integer n2;
        String errorReport = message + '\n' + equation + '\n';
        Integer i = 0;
        while (i < position) {
            errorReport = errorReport + ' ';
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
        errorReport = errorReport + '^';
        if (position != target) {
            i = 1;
            while (i + 1 < target - position) {
                errorReport = errorReport + '~';
                n2 = i;
                n = i = Integer.valueOf(i + 1);
            }
            errorReport = errorReport + '^';
        }
        MathParsingExeption exeption = new MathParsingExeption(message, errorReport);
        exeption.setEquation(equation);
        exeption.setStartPosition(position);
        exeption.setStopPosition(target);
        return exeption;
    }

    public static class MathParsingExeption
    extends RuntimeException {
        private static final long serialVersionUID = 13688365781979795L;
        private String errorReport = null;
        private String equation = null;
        private Integer startPosition = null;
        private Integer stopPosition = null;

        public MathParsingExeption() {
        }

        public MathParsingExeption(String message) {
            super(message);
        }

        public MathParsingExeption(Throwable cause) {
            super(cause);
        }

        public MathParsingExeption(String message, Throwable cause) {
            super(message, cause);
        }

        public MathParsingExeption(String message, String errorReport) {
            super(message);
            this.errorReport = errorReport;
        }

        public String getErrorReport() {
            return this.errorReport;
        }

        public void setErrorReport(String errorReport) {
            this.errorReport = errorReport;
        }

        public String getEquation() {
            return this.equation;
        }

        public void setEquation(String equation) {
            this.equation = equation;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStopPosition() {
            return this.stopPosition;
        }

        public void setStopPosition(Integer stopPosition) {
            this.stopPosition = stopPosition;
        }
    }

    @FunctionalInterface
    public static interface MathFunction {
        public Double execute(Double[] var1);
    }
}

