/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import de.serviceflow.codegenj.Node;
import de.serviceflow.codegenj.TemplateBlock;
import de.serviceflow.codegenj.TemplateParser;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Map;

public class MakefileGenerator {
    private final Node nodeDef;
    private final String destination;
    private final Map<String, String> parameters;
    private String fileBaseName = null;

    public MakefileGenerator(Node nodeDef, Map<String, String> parameters, String destination) {
        this.nodeDef = nodeDef;
        this.parameters = parameters;
        this.destination = destination;
    }

    public void open() {
        this.fileBaseName = "Makefile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        PrintWriter w;
        String jnidir = this.destination + "/src/main/jni";
        TemplateParser t = new TemplateParser("template/Makefile.txt");
        t.open();
        try {
            w = new PrintWriter(new FileOutputStream(jnidir + "/" + this.fileBaseName));
        }
        catch (FileNotFoundException e) {
            throw new Error("Can't create output file: " + e.getLocalizedMessage());
        }
        try {
            new TemplateBlock(this.nodeDef, this.parameters, t, w).process();
        }
        finally {
            w.close();
        }
        t.close();
    }

    public void close() {
    }
}

