/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import de.serviceflow.codegenj.Block;
import de.serviceflow.codegenj.CaseBlock;
import de.serviceflow.codegenj.ForBlock;
import de.serviceflow.codegenj.Naming;
import de.serviceflow.codegenj.Node;
import de.serviceflow.codegenj.ObjectiveBlockHandler;
import de.serviceflow.codegenj.ProcessingObjective;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CodeGenerationProcessing {
    private final Map<String, ObjectiveBlockHandler> blockMap = new HashMap<String, ObjectiveBlockHandler>();
    private final Map<String, String> wireToJavaTypeMap = new HashMap<String, String>();
    private final Map<String, String> wireToJniTypeMap = new HashMap<String, String>();
    private final Map<String, String> wireToCTypeMap = new HashMap<String, String>();
    private final Map<String, String> wireBasedJava2CAssignFormatMap = new HashMap<String, String>();
    private final Map<String, String> wireBasedJava2CCleanupFormatMap = new HashMap<String, String>();
    private final Map<String, String> wireBasedC2JavaAssignFormatMap = new HashMap<String, String>();
    private final Set<String> forbiddenIdentifiers = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    public void initializeProcessing() {
        this.initializeWireToJavaTypeMapping();
        this.initializeWireToJniTypeMapping();
        this.initializeWireToCTypeMapping();
        this.initializeWireBasedJava2CAssignFormatMapping();
        this.initializeWireBasedJava2CCleanupFormatMapping();
        this.initializeWireBasedC2JavaAssignFormatMapping();
        this.initializeTemplateProcessingEvaluators();
    }

    public void processInterface(Map<String, String> parameters, Node.Interface i) {
        parameters.put("interface.name", i.getName());
        parameters.put("interface.uname", Naming.javaUName(i.getName()));
        parameters.put("classname", i.getName());
        String pname = Naming.javaPName(i.getName());
        if (pname == null) {
            parameters.put("interface.pcode", "");
        } else {
            parameters.put("interface.pname", pname);
            parameters.put("interface.pcode", "package " + pname + ";\n");
        }
        parameters.put("interface.cname", Naming.cName(Naming.javaUName(i.getName())));
        parameters.put("interface.jname", Naming.jName(i.getName()));
    }

    private void initializeTemplateProcessingEvaluators() {
        this.blockMap.put(Node.Interface.class.getName(), new ObjectiveBlockHandler(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void process(Block p, ProcessingObjective o, String blockArg, PrintWriter w) {
                Node.Interface objective = (Node.Interface)o;
                if (!(p instanceof ForBlock)) throw new Error("No processing objective for " + p.getBlockname() + " (" + p.getClass().getName() + ")");
                if ("method".equals(blockArg)) {
                    boolean supported = true;
                    for (Node.Interface.Method m : objective.getMethods()) {
                        ((ForBlock)p).changeContext(m);
                        p.getParameters().put("method.name", m.getName());
                        p.getParameters().put("method.jname", Naming.javaMemberName(m.getName()));
                        p.getParameters().put("method.cname", Naming.cName(m.getName()));
                        p.getParameters().put("method.sname", Naming.cName(m.getName()).replace('_', '-'));
                        String comment = m.getComment();
                        if (comment == null) {
                            comment = "";
                        }
                        p.getParameters().put("method.comment", comment);
                        String javareturntype = "void";
                        String jnireturntype = "void";
                        StringBuffer javaargs = new StringBuffer();
                        StringBuffer jniargs = new StringBuffer();
                        StringBuffer cparams = new StringBuffer();
                        StringBuffer cargmapcode = new StringBuffer();
                        StringBuffer cleanupcode = new StringBuffer();
                        StringBuffer creturncode = new StringBuffer();
                        for (Node.Interface.Member.Arg a : m.getArgs()) {
                            Object[] fArgs;
                            MessageFormat form;
                            String code;
                            String javaargbasetype;
                            int aDims;
                            String wireType;
                            if ("out".equals(a.getDirection())) {
                                String ctype;
                                wireType = a.getType();
                                aDims = 0;
                                while (wireType.startsWith("a")) {
                                    ++aDims;
                                    wireType = wireType.substring(1);
                                }
                                String javareturnbasetype = javareturntype = (String)CodeGenerationProcessing.this.wireToJavaTypeMap.get(wireType);
                                jnireturntype = (String)CodeGenerationProcessing.this.wireToJniTypeMap.get(wireType);
                                String cbasetype = ctype = (String)CodeGenerationProcessing.this.wireToCTypeMap.get(wireType);
                                for (int d = 0; d < aDims; ++d) {
                                    javareturntype = javareturntype + "[]";
                                }
                                if (javareturntype == null || jnireturntype == null) {
                                    supported = false;
                                    javareturntype = "?";
                                    jnireturntype = "?";
                                }
                                if (aDims >= 2) {
                                    jnireturntype = "jobject";
                                    supported = false;
                                } else if (aDims == 1) {
                                    if ("jstring".equals(jnireturntype)) {
                                        jnireturntype = "jobjectArray";
                                        supported = false;
                                    } else if ("jobject".equals(jnireturntype)) {
                                        jnireturntype = "jobjectArray";
                                        supported = false;
                                    } else {
                                        jnireturntype = jnireturntype + "Array";
                                        ctype = ctype + " *";
                                    }
                                }
                                cargmapcode.append(ctype);
                                if (ctype.charAt(ctype.length() - 1) != '*') {
                                    cargmapcode.append(' ');
                                }
                                cargmapcode.append("_result;\n    ");
                                cparams.append("&_result,\n        ");
                                creturncode.append("    ");
                                creturncode.append(jnireturntype);
                                creturncode.append(" _jniresult;\n");
                                if (aDims == 0) {
                                    creturncode.append("    _jniresult = _result;\n");
                                } else if (aDims == 1) {
                                    creturncode.append("    gint size = sizeof(_result) / sizeof(");
                                    creturncode.append(cbasetype);
                                    creturncode.append(");\n");
                                    creturncode.append("    _jniresult = (*env)->New");
                                    creturncode.append(Character.toUpperCase(javareturnbasetype.charAt(0)));
                                    creturncode.append(javareturnbasetype.substring(1));
                                    creturncode.append("Array(env, size);\n");
                                    creturncode.append("    if (_jniresult == NULL) {\n");
                                    creturncode.append("        return NULL; // out of memory error thrown\n");
                                    creturncode.append("    }\n");
                                    creturncode.append("    (*env)->Set");
                                    creturncode.append(Character.toUpperCase(javareturnbasetype.charAt(0)));
                                    creturncode.append(javareturnbasetype.substring(1));
                                    creturncode.append("ArrayRegion(env, _jniresult, 0, size, _result);\n");
                                }
                                creturncode.append("    return _jniresult;\n");
                                continue;
                            }
                            if (!"in".equals(a.getDirection())) continue;
                            wireType = a.getType();
                            aDims = 0;
                            while (wireType.startsWith("a")) {
                                ++aDims;
                                wireType = wireType.substring(1);
                            }
                            String javaargtype = javaargbasetype = (String)CodeGenerationProcessing.this.wireToJavaTypeMap.get(wireType);
                            String jniargtype = (String)CodeGenerationProcessing.this.wireToJniTypeMap.get(wireType);
                            String ctype = (String)CodeGenerationProcessing.this.wireToCTypeMap.get(wireType);
                            if (javaargbasetype == null || ctype == null) {
                                supported = false;
                                javaargbasetype = "?";
                            }
                            if (aDims >= 2 || aDims == 1 && "jstring".equals(jniargtype)) {
                                jniargtype = "jobject";
                                supported = false;
                            } else if (aDims == 1) {
                                javaargtype = javaargbasetype + " []";
                                jniargtype = jniargtype + "Array";
                            }
                            if (javaargs.length() > 0) {
                                javaargs.append(", ");
                            }
                            javaargs.append(javaargtype);
                            javaargs.append(' ');
                            javaargs.append(a.getName());
                            jniargs.append(", ");
                            jniargs.append(jniargtype);
                            jniargs.append(' ');
                            jniargs.append(a.getName());
                            cargmapcode.append(ctype);
                            if (ctype != null && ctype.charAt(ctype.length() - 1) != '*') {
                                cargmapcode.append(' ');
                            }
                            if (aDims == 1) {
                                cargmapcode.append("*");
                            }
                            cargmapcode.append("c_arg_");
                            cargmapcode.append(a.getName());
                            cargmapcode.append(" = ");
                            if (aDims == 0) {
                                code = (String)CodeGenerationProcessing.this.wireBasedJava2CAssignFormatMap.get(wireType);
                                if (code != null) {
                                    if ("?".equals(code)) {
                                        supported = false;
                                    }
                                    form = new MessageFormat(code);
                                    fArgs = new Object[]{a.getName()};
                                    cargmapcode.append(form.format(fArgs));
                                } else {
                                    cargmapcode.append(a.getName());
                                    cargmapcode.append(';');
                                }
                            } else if (aDims == 1) {
                                cargmapcode.append("(*env)->Get");
                                cargmapcode.append(Character.toUpperCase(javaargbasetype.charAt(0)));
                                cargmapcode.append(javaargbasetype.substring(1));
                                cargmapcode.append("ArrayElements(env, ");
                                cargmapcode.append(a.getName());
                                cargmapcode.append(", 0);");
                            } else {
                                supported = false;
                            }
                            cargmapcode.append("\n    ");
                            if (CodeGenerationProcessing.this.isPrimitiveJniType(jniargtype)) {
                                cparams.append("&");
                            }
                            cparams.append("c_arg_");
                            cparams.append(a.getName());
                            cparams.append(",\n        ");
                            if (aDims == 0) {
                                code = (String)CodeGenerationProcessing.this.wireBasedJava2CAssignFormatMap.get(wireType);
                                if (code != null) {
                                    if ("?".equals(code)) {
                                        supported = false;
                                    }
                                    form = new MessageFormat(code);
                                    fArgs = new Object[]{a.getName()};
                                    cleanupcode.append("    ");
                                    cleanupcode.append(form.format(fArgs));
                                    cleanupcode.append("\n");
                                    continue;
                                }
                                cleanupcode.append(a.getName());
                                cleanupcode.append(";\n");
                                continue;
                            }
                            if (aDims == 1) {
                                cleanupcode.append("    (*env)->Release");
                                cleanupcode.append(Character.toUpperCase(javaargbasetype.charAt(0)));
                                cleanupcode.append(javaargbasetype.substring(1));
                                cleanupcode.append("ArrayElements(env, ");
                                cleanupcode.append(a.getName());
                                cleanupcode.append(", c_arg_");
                                cleanupcode.append(a.getName());
                                cleanupcode.append(", 0);\n");
                                continue;
                            }
                            supported = false;
                        }
                        p.getParameters().put("method.javareturntype", javareturntype);
                        p.getParameters().put("method.javaargs", javaargs.toString());
                        p.getParameters().put("method.jnireturntype", jnireturntype);
                        p.getParameters().put("method.jniargs", jniargs.toString());
                        p.getParameters().put("method.cparams", cparams.toString());
                        p.getParameters().put("method.cargmapcode", cargmapcode.toString());
                        p.getParameters().put("method.cleanupcode", cleanupcode.toString());
                        p.getParameters().put("method.creturncode", creturncode.toString());
                        if (supported) {
                            w.print(p.process(this.getContent()));
                            continue;
                        }
                        w.print("// Method signature unsupported: " + m.getName());
                    }
                    return;
                } else if ("de.serviceflow.codegenj.CollectorAPI".equals(blockArg)) {
                    StringBuffer initCode = new StringBuffer();
                    StringBuffer addCode = new StringBuffer();
                    StringBuffer removeCode = new StringBuffer();
                    String existingCode = p.getParameters().get("api.init");
                    if (existingCode != null) {
                        initCode.append(existingCode);
                    }
                    if ((existingCode = p.getParameters().get("api.add")) != null) {
                        addCode.append(existingCode);
                    }
                    if ((existingCode = p.getParameters().get("api.remove")) != null) {
                        removeCode.append(existingCode);
                    }
                    for (Map.Entry<Node.Interface, String> entry : objective.getInterfaceCollectorMap().entrySet()) {
                        Node.Interface i = entry.getKey();
                        String mname = entry.getValue();
                        int index = mname.indexOf(35);
                        if (index < 0) {
                            throw new Error("Value of annotation de.serviceflow.codegenj.CollectorAPI must be 'class#method' or 'class#*method' for " + p.getBlockname() + " (" + p.getClass().getName() + ")");
                        }
                        String templateclassname = p.getParameters().get("classname");
                        if (!templateclassname.equals(mname.substring(0, index))) continue;
                        mname = mname.substring(index + 1);
                        p.getParameters().put("opmode", String.valueOf(!mname.startsWith("*")));
                        if (mname.startsWith("*")) {
                            mname = mname.substring(1);
                        }
                        String name = i.getName();
                        p.getParameters().put("cinterfacename", name);
                        index = name.lastIndexOf(46);
                        if (index > 0) {
                            name = name.substring(index + 1);
                        }
                        p.getParameters().put("cname", name);
                        p.getParameters().put("vname", name.toLowerCase());
                        p.getParameters().put("mname", mname);
                        w.print(p.process(this.getContent()));
                        initCode.append("    \t");
                        initCode.append(p.getParameters().get("interface.name"));
                        initCode.append(".initialize");
                        initCode.append(name);
                        initCode.append("Mapping();\n");
                        addCode.append("    \tif (\"");
                        addCode.append(i.getName());
                        addCode.append("\".equals(interfaceName)) { ");
                        addCode.append(p.getParameters().get("interface.name"));
                        addCode.append(".add");
                        addCode.append(name);
                        addCode.append("Object(objectpath,  proxy); }\n");
                        removeCode.append("    \tif (\"");
                        removeCode.append(i.getName());
                        removeCode.append("\".equals(interfaceName)) { ");
                        removeCode.append(p.getParameters().get("interface.name"));
                        removeCode.append(".remove");
                        removeCode.append(name);
                        removeCode.append("Object(objectpath,  proxy); }\n");
                    }
                    p.getParameters().put("api.init", initCode.toString());
                    p.getParameters().put("api.add", addCode.toString());
                    p.getParameters().put("api.remove", removeCode.toString());
                    return;
                } else {
                    if (!"properties".equals(blockArg)) throw new Error("No processing objective for block argument '" + blockArg + "' at " + p.getBlockname() + " (" + p.getClass().getName() + ")");
                    for (Node.Interface.Property pr : objective.getProperties()) {
                        ((ForBlock)p).changeContext(pr);
                        w.print(p.process(this.getContent()));
                    }
                    p.getParameters().remove("property.access");
                }
            }
        });
        this.blockMap.put(Node.class.getName(), new ObjectiveBlockHandler(){

            @Override
            public void process(Block p, ProcessingObjective o, String blockArg, PrintWriter w) {
                Node objective = (Node)o;
                if (p instanceof ForBlock) {
                    if ("de.serviceflow.codegenj.CollectorAPI".equals(blockArg)) {
                        StringBuffer initCode = new StringBuffer();
                        StringBuffer addCode = new StringBuffer();
                        StringBuffer removeCode = new StringBuffer();
                        String existingCode = p.getParameters().get("api.init");
                        if (existingCode != null) {
                            initCode.append(existingCode);
                        }
                        if ((existingCode = p.getParameters().get("api.add")) != null) {
                            addCode.append(existingCode);
                        }
                        if ((existingCode = p.getParameters().get("api.remove")) != null) {
                            removeCode.append(existingCode);
                        }
                        for (Map.Entry<Node.Interface, String> entry : objective.getInterfaceCollectorMap().entrySet()) {
                            Node.Interface i = entry.getKey();
                            String mname = entry.getValue();
                            int index = mname.indexOf(35);
                            if (index < 0) {
                                throw new Error("Value of annotation de.serviceflow.codegenj.CollectorAPI must be 'class#method' or 'class#*method' for " + p.getBlockname() + " (" + p.getClass().getName() + ")");
                            }
                            String templateclassname = p.getParameters().get("classname");
                            if (!templateclassname.equals(mname.substring(0, index))) continue;
                            mname = mname.substring(index + 1);
                            String name = i.getName();
                            p.getParameters().put("interfacename", name);
                            index = name.lastIndexOf(46);
                            if (index > 0) {
                                name = name.substring(index + 1);
                            }
                            p.getParameters().put("opmode", String.valueOf(!name.startsWith("*")));
                            if (name.startsWith("*")) {
                                name = name.substring(1);
                            }
                            p.getParameters().put("cname", name);
                            p.getParameters().put("vname", name.toLowerCase());
                            p.getParameters().put("mname", mname);
                            w.print(p.process(this.getContent()));
                            initCode.append("    \tde.serviceflow.codegenj.ObjectManager.initialize");
                            initCode.append(name);
                            initCode.append("Mapping();\n");
                            addCode.append("    \tif (\"");
                            addCode.append(i.getName());
                            addCode.append("\".equals(interfaceName)) { de.serviceflow.codegenj.ObjectManager.add");
                            addCode.append(name);
                            addCode.append("Object(objectpath,  proxy); }");
                            removeCode.append("    \tif (\"");
                            removeCode.append(i.getName());
                            removeCode.append("\".equals(interfaceName)) { de.serviceflow.codegenj.ObjectManager.remove");
                            removeCode.append(name);
                            removeCode.append("Object(objectpath,  proxy); }");
                        }
                        p.getParameters().put("api.init", initCode.toString());
                        p.getParameters().put("api.add", addCode.toString());
                        p.getParameters().put("api.remove", removeCode.toString());
                    }
                } else {
                    throw new Error("No processing objective for " + p.getBlockname() + " (" + p.getClass().getName() + ")");
                }
            }
        });
        this.blockMap.put(Node.Interface.Property.class.getName(), new ObjectiveBlockHandler(){

            @Override
            public void process(Block p, ProcessingObjective o, String blockArg, PrintWriter w) {
                Node.Interface.Property objective = (Node.Interface.Property)o;
                if ("ao".equals(objective.getType())) {
                    for (Node.Interface.Member.Annotation a : objective.getAnnotations()) {
                        if (!"de.serviceflow.codegenj.CollectorAPI".equals(a.getName())) continue;
                        return;
                    }
                }
                if (p instanceof CaseBlock) {
                    String comment;
                    boolean supported = true;
                    String casename = ((CaseBlock)p).getCaseName();
                    String accessvalue = objective.getAccess();
                    System.out.println("... property '" + objective.getName() + "': casename : " + casename + "   accessvalue: " + accessvalue);
                    String suffix = "";
                    if (CodeGenerationProcessing.this.forbiddenIdentifiers.contains(objective.getName().toLowerCase())) {
                        suffix = "Property";
                    }
                    if ((comment = objective.getComment()) == null) {
                        comment = "";
                    }
                    p.getParameters().put("method.comment", comment);
                    if ("read".equals(casename) && ("read".equals(accessvalue) || "readwrite".equals(accessvalue)) || "write".equals(casename) && ("write".equals(accessvalue) || "readwrite".equals(accessvalue))) {
                        p.getParameters().put("property.name", objective.getName());
                        p.getParameters().put("property.type", objective.getType());
                        p.getParameters().put("property.access", accessvalue);
                        String javareturntype = "void";
                        String jnireturntype = "void";
                        StringBuffer javaargs = new StringBuffer();
                        StringBuffer jniargs = new StringBuffer();
                        StringBuffer cargmapcode = new StringBuffer();
                        StringBuffer cleanupcode = new StringBuffer();
                        StringBuffer creturncode = new StringBuffer();
                        p.getParameters().put("method.cname", Naming.cName(objective.getName()));
                        if ("read".equals(casename)) {
                            String ctype;
                            p.getParameters().put("method.jname", "get" + objective.getName() + suffix);
                            String wireType = objective.getType();
                            int aDims = 0;
                            while (wireType.startsWith("a")) {
                                ++aDims;
                                wireType = wireType.substring(1);
                            }
                            javareturntype = (String)CodeGenerationProcessing.this.wireToJavaTypeMap.get(wireType);
                            if (javareturntype == null) {
                                supported = false;
                            }
                            String javareturnbasetype = javareturntype;
                            jnireturntype = (String)CodeGenerationProcessing.this.wireToJniTypeMap.get(wireType);
                            String cbasetype = ctype = (String)CodeGenerationProcessing.this.wireToCTypeMap.get(wireType);
                            for (int d = 0; d < aDims; ++d) {
                                javareturntype = javareturntype + "[]";
                            }
                            if (javareturntype == null || jnireturntype == null) {
                                supported = false;
                                javareturntype = "?";
                                jnireturntype = "?";
                            }
                            if (aDims >= 2) {
                                jnireturntype = "jobject";
                                supported = false;
                            } else if (aDims == 1) {
                                if ("jstring".equals(jnireturntype)) {
                                    jnireturntype = "jobjectArray";
                                    ctype = "char *const *";
                                } else if ("jobject".equals(jnireturntype)) {
                                    jnireturntype = "jobjectArray";
                                    ctype = "void *";
                                    supported = false;
                                } else {
                                    jnireturntype = jnireturntype + "Array";
                                    ctype = ctype + " *";
                                }
                            }
                            if (supported) {
                                cargmapcode.append(ctype);
                                if (ctype.charAt(ctype.length() - 1) != '*') {
                                    cargmapcode.append(' ');
                                }
                                cargmapcode.append("_result = (");
                                cargmapcode.append(ctype);
                                cargmapcode.append(")");
                                if (aDims == 0 && CodeGenerationProcessing.this.wireBasedC2JavaAssignFormatMap.get(wireType) != null) {
                                    creturncode.append("    if (_result==NULL)\n");
                                    creturncode.append("        return NULL;\n");
                                }
                                creturncode.append("    ");
                                creturncode.append(jnireturntype);
                                creturncode.append(" _jniresult = ");
                                if (aDims == 0) {
                                    String code = (String)CodeGenerationProcessing.this.wireBasedC2JavaAssignFormatMap.get(wireType);
                                    if (code != null) {
                                        if ("?".equals(code)) {
                                            supported = false;
                                        }
                                        MessageFormat form = new MessageFormat(code);
                                        Object[] fArgs = new Object[]{"_result"};
                                        creturncode.append(form.format(fArgs));
                                    } else {
                                        creturncode.append("_result");
                                        creturncode.append(';');
                                    }
                                } else if (aDims == 1) {
                                    if ("s".equals(wireType)) {
                                        creturncode.append("NULL;\n");
                                        creturncode.append("    int asize = 0;\n");
                                        creturncode.append("    int i;\n");
                                        creturncode.append("    for (i=0; _result[i] != NULL; i++)  asize++;\n");
                                        creturncode.append("    ");
                                        creturncode.append("_jniresult = ");
                                        creturncode.append("(jobjectArray) (*env) -> NewObjectArray(env, asize, (*env) -> FindClass(env, \"java/lang/String\"), NULL);\n");
                                        creturncode.append("    for(i=0;i<asize;i++) { (*env)->SetObjectArrayElement(env, _jniresult, i, (*env)->NewStringUTF(env, _result[i])); }");
                                    } else {
                                        creturncode.append("NULL;\n");
                                        creturncode.append("    int asize = 0;\n");
                                        creturncode.append("    int i;\n");
                                        creturncode.append("    for (i=0; _result[i] != (");
                                        creturncode.append(cbasetype);
                                        creturncode.append(")0; i++)  asize++;\n");
                                        creturncode.append("    ");
                                        creturncode.append("_jniresult = ");
                                        creturncode.append("(jobjectArray) (*env) -> New");
                                        creturncode.append(Character.toUpperCase(javareturnbasetype.charAt(0)));
                                        creturncode.append(javareturnbasetype.substring(1));
                                        creturncode.append("Array(env, asize);\n");
                                        creturncode.append("    (*env)->Set");
                                        creturncode.append(Character.toUpperCase(javareturnbasetype.charAt(0)));
                                        creturncode.append(javareturnbasetype.substring(1));
                                        creturncode.append("ArrayRegion(env, _jniresult, 0, asize, _result);");
                                    }
                                } else {
                                    supported = false;
                                }
                                creturncode.append("\n");
                                creturncode.append("    return _jniresult;\n");
                            }
                        } else {
                            Object[] fArgs;
                            MessageFormat form;
                            String code;
                            String javaargbasetype;
                            p.getParameters().put("method.jname", "set" + objective.getName() + suffix);
                            String wireType = objective.getType();
                            int aDims = 0;
                            while (wireType.startsWith("a")) {
                                ++aDims;
                                wireType = wireType.substring(1);
                            }
                            String javaargtype = javaargbasetype = (String)CodeGenerationProcessing.this.wireToJavaTypeMap.get(wireType);
                            String jniargtype = (String)CodeGenerationProcessing.this.wireToJniTypeMap.get(wireType);
                            String ctype = (String)CodeGenerationProcessing.this.wireToCTypeMap.get(wireType);
                            if (javaargbasetype == null) {
                                supported = false;
                                javaargbasetype = "?";
                            }
                            if (aDims >= 2 || aDims == 1 && "jstring".equals(jniargtype)) {
                                jniargtype = "jobject";
                                supported = false;
                            } else if (aDims == 1) {
                                javaargtype = javaargbasetype + " []";
                                jniargtype = jniargtype + "Array";
                            }
                            if (javaargs.length() > 0) {
                                javaargs.append(", ");
                            }
                            javaargs.append(javaargtype);
                            javaargs.append(' ');
                            javaargs.append(objective.getName());
                            jniargs.append(", ");
                            jniargs.append(jniargtype);
                            jniargs.append(' ');
                            jniargs.append("value");
                            cargmapcode.append(ctype);
                            if (ctype.charAt(ctype.length() - 1) != '*') {
                                cargmapcode.append(' ');
                            }
                            if (aDims == 1) {
                                cargmapcode.append("*");
                            }
                            cargmapcode.append("c_arg_");
                            cargmapcode.append("value");
                            cargmapcode.append(" = ");
                            if (aDims == 0) {
                                code = (String)CodeGenerationProcessing.this.wireBasedJava2CAssignFormatMap.get(wireType);
                                if (code != null) {
                                    if ("?".equals(code)) {
                                        supported = false;
                                    }
                                    form = new MessageFormat(code);
                                    fArgs = new Object[]{"value"};
                                    cargmapcode.append(form.format(fArgs));
                                } else {
                                    cargmapcode.append("value");
                                    cargmapcode.append(';');
                                }
                            } else if (aDims == 1) {
                                cargmapcode.append("(*env)->Get");
                                cargmapcode.append(Character.toUpperCase(javaargbasetype.charAt(0)));
                                cargmapcode.append(javaargbasetype.substring(1));
                                cargmapcode.append("ArrayElements(env, ");
                                cargmapcode.append("value");
                                cargmapcode.append(", 0);");
                            } else {
                                supported = false;
                            }
                            cargmapcode.append("\n    ");
                            if (aDims == 0) {
                                code = (String)CodeGenerationProcessing.this.wireBasedJava2CAssignFormatMap.get(wireType);
                                if (code != null) {
                                    if ("?".equals(code)) {
                                        supported = false;
                                    }
                                    form = new MessageFormat(code);
                                    fArgs = new Object[]{objective.getName()};
                                    cleanupcode.append("    ");
                                    cleanupcode.append(form.format(fArgs));
                                    cleanupcode.append("\n");
                                } else {
                                    cleanupcode.append(objective.getName());
                                    cleanupcode.append(";\n");
                                }
                            } else if (aDims == 1) {
                                cleanupcode.append("    (*env)->Release");
                                cleanupcode.append(Character.toUpperCase(javaargbasetype.charAt(0)));
                                cleanupcode.append(javaargbasetype.substring(1));
                                cleanupcode.append("ArrayElements(env, ");
                                cleanupcode.append(objective.getName());
                                cleanupcode.append(", c_arg_");
                                cleanupcode.append(objective.getName());
                                cleanupcode.append(", 0);\n");
                            } else {
                                supported = false;
                            }
                        }
                        p.getParameters().put("method.javareturntype", javareturntype);
                        p.getParameters().put("method.javaargs", javaargs.toString());
                        p.getParameters().put("method.jnireturntype", jnireturntype);
                        p.getParameters().put("method.jniargs", jniargs.toString());
                        p.getParameters().put("method.cargmapcode", cargmapcode.toString());
                        p.getParameters().put("method.cleanupcode", cleanupcode.toString());
                        p.getParameters().put("method.creturncode", creturncode.toString());
                        if (supported) {
                            w.print(p.process(this.getContent()));
                        } else {
                            w.print("// property signature unsupported: " + objective.getName());
                        }
                    }
                } else {
                    throw new Error("No processing objective for " + p.getBlockname() + " (" + p.getClass().getName() + ")");
                }
            }
        });
    }

    public Map<String, ObjectiveBlockHandler> getBlockMap() {
        return this.blockMap;
    }

    private void initializeWireToJavaTypeMapping() {
        this.wireToJavaTypeMap.put("y", "byte");
        this.wireToJavaTypeMap.put("b", "boolean");
        this.wireToJavaTypeMap.put("n", "short");
        this.wireToJavaTypeMap.put("q", "short");
        this.wireToJavaTypeMap.put("i", "int");
        this.wireToJavaTypeMap.put("u", "int");
        this.wireToJavaTypeMap.put("x", "long");
        this.wireToJavaTypeMap.put("t", "long");
        this.wireToJavaTypeMap.put("d", "double");
        this.wireToJavaTypeMap.put("h", "int");
        this.wireToJavaTypeMap.put("s", "String");
        this.wireToJavaTypeMap.put("o", "Object");
    }

    private void initializeWireToJniTypeMapping() {
        this.wireToJniTypeMap.put("y", "jbyte");
        this.wireToJniTypeMap.put("b", "jboolean");
        this.wireToJniTypeMap.put("n", "jshort");
        this.wireToJniTypeMap.put("q", "jshort");
        this.wireToJniTypeMap.put("i", "jint");
        this.wireToJniTypeMap.put("u", "jint");
        this.wireToJniTypeMap.put("x", "jlong");
        this.wireToJniTypeMap.put("t", "jlong");
        this.wireToJniTypeMap.put("d", "jdouble");
        this.wireToJniTypeMap.put("h", "jint");
        this.wireToJniTypeMap.put("s", "jstring");
        this.wireToJniTypeMap.put("o", "jobject");
    }

    private void initializeWireToCTypeMapping() {
        this.wireToCTypeMap.put("y", "gchar");
        this.wireToCTypeMap.put("b", "gboolean");
        this.wireToCTypeMap.put("n", "gint16");
        this.wireToCTypeMap.put("q", "guint16");
        this.wireToCTypeMap.put("i", "gint32");
        this.wireToCTypeMap.put("u", "guint32");
        this.wireToCTypeMap.put("x", "gint64");
        this.wireToCTypeMap.put("t", "guint64");
        this.wireToCTypeMap.put("d", "gdouble");
        this.wireToCTypeMap.put("h", "guint32");
        this.wireToCTypeMap.put("s", "const gchar *");
        this.wireToCTypeMap.put("o", "const gchar *");
        this.wireToCTypeMap.put("g", "?");
    }

    private void initializeWireBasedJava2CAssignFormatMapping() {
        this.wireBasedJava2CAssignFormatMap.put("s", "(*env)->GetStringUTFChars(env, {0}, NULL);");
        this.wireBasedJava2CAssignFormatMap.put("o", "(*env)->GetStringUTFChars(env, {0}, NULL);");
        this.wireBasedJava2CAssignFormatMap.put("g", "?");
    }

    private void initializeWireBasedJava2CCleanupFormatMapping() {
        this.wireBasedJava2CCleanupFormatMap.put("s", "(*env)->ReleaseStringUTFChars(env, {0}, c_arg_{0});");
        this.wireBasedJava2CCleanupFormatMap.put("g", "; // ?");
    }

    private void initializeWireBasedC2JavaAssignFormatMapping() {
        this.wireBasedC2JavaAssignFormatMap.put("s", "(*env)->NewStringUTF(env, {0});");
        this.wireBasedC2JavaAssignFormatMap.put("o", "?");
        this.wireBasedC2JavaAssignFormatMap.put("g", "?");
    }

    private boolean isPrimitiveJniType(String jniargtype) {
        return !"jobject".equals(jniargtype) && !"jstring".equals(jniargtype);
    }
}

