/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import de.serviceflow.codegenj.CodeGenerationProcessing;
import de.serviceflow.codegenj.InterfaceSourceGenerator;
import de.serviceflow.codegenj.MakefileGenerator;
import de.serviceflow.codegenj.Node;
import de.serviceflow.codegenj.ObjectManagerGenerator;
import de.serviceflow.codegenj.ObjectiveBlockHandler;
import de.serviceflow.codegenj.ProcessingObjective;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class CodegenJ {
    private static CodegenJ instance = null;
    public final CodeGenerationProcessing initHelper = new CodeGenerationProcessing();
    private String xmlFile;
    private String destination = "target";
    private String busname = "my.dum";
    private String iprefix = "my.dum.";
    private String library = "dummydbus";

    public static void main(String[] args) {
        new CodegenJ().run(args);
    }

    public CodegenJ() {
        instance = this;
    }

    private void run(String[] args) {
        try {
            this.initHelper.initializeProcessing();
            String xmlfile = this.parseOptions(args);
            Node rootNode = this.parseXML(xmlfile);
            this.generateCode(rootNode, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (SAXException e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(-1);
        }
        catch (XMLStreamException e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(-1);
        }
    }

    public String parseOptions(String[] args) throws FileNotFoundException {
        if (args.length < 1 || !this.stripOptions(args)) {
            System.err.println("Usage: CodegenJ [-d <destination>] -l <library> -b <busname> -i <interfaceprefix> <xmlfile>");
            System.exit(-1);
        }
        return this.xmlFile;
    }

    private boolean stripOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if ("-d".equals(args[i])) {
                    if (++i == args.length) {
                        return false;
                    }
                    this.destination = args[i];
                    continue;
                }
                if ("-b".equals(args[i])) {
                    if (++i == args.length) {
                        return false;
                    }
                    this.busname = args[i];
                    continue;
                }
                if ("-i".equals(args[i])) {
                    if (++i == args.length) {
                        return false;
                    }
                    this.iprefix = args[i];
                    continue;
                }
                if ("-l".equals(args[i])) {
                    if (++i == args.length) {
                        return false;
                    }
                    this.library = args[i];
                    continue;
                }
                return false;
            }
            if (this.xmlFile != null) {
                return false;
            }
            this.xmlFile = args[i];
        }
        return this.xmlFile != null;
    }

    public Node parseXML(String xmlfile) throws JAXBException, SAXException, XMLStreamException, FileNotFoundException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(this.getClass().getResourceAsStream("/dbus.xsd"), this.getClass().getResource("/dbus.xsd").toString());
        Schema schema = schemaFactory.newSchema(schemaSource);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Node.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setSchema(schema);
        unmarshaller.setEventHandler((ValidationEventHandler)new DBusValidationEventHandler());
        Node node = (Node)unmarshaller.unmarshal((InputStream)new FileInputStream(xmlfile));
        XMLInputFactory xif = XMLInputFactory.newFactory();
        XMLStreamReader xsr = xif.createXMLStreamReader(new FileInputStream(xmlfile));
        String comment = null;
        Stack<ProcessingObjective> xmlStack = new Stack<ProcessingObjective>();
        ProcessingObjective currentObject = null;
        while (xsr.hasNext()) {
            if (xsr.getEventType() == 5) {
                comment = xsr.getText();
            } else if (xsr.getEventType() == 1) {
                xmlStack.push(currentObject);
                String name = xsr.getName().toString();
                if (name.equals("node")) {
                    currentObject = node;
                } else if (currentObject != null) {
                    currentObject = currentObject.getProcessingObjective(name);
                }
                if (currentObject != null) {
                    currentObject.startScan();
                }
                if (comment != null && currentObject != null) {
                    currentObject.setComment(comment);
                }
                comment = null;
            } else if (xsr.getEventType() == 2) {
                if (currentObject != null) {
                    currentObject.endScan();
                }
                currentObject = (ProcessingObjective)xmlStack.pop();
            }
            xsr.next();
        }
        return node;
    }

    public void generateCode(Node node, Node parent) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("node.name", node.getName());
        parameters.put("busname", this.busname);
        parameters.put("iprefix", this.iprefix);
        parameters.put("library", this.library);
        StringBuffer headerFiles = new StringBuffer();
        StringBuffer classlist = new StringBuffer();
        StringBuffer objFiles = new StringBuffer();
        for (Node.Interface i : node.getInterfaces()) {
            for (Node.Interface.Member.Annotation a : i.getAnnotations()) {
                if (!"de.serviceflow.codegenj.CollectorAPI".equals(a.getName())) continue;
                String mname = a.getValue();
                int index = mname.indexOf(35);
                if (index < 0) {
                    throw new Error("Value of annotation de.serviceflow.codegenj.CollectorAPI must be 'class#method' at interface " + i.getName());
                }
                String templateclassname = "de.serviceflow.codegenj.ObjectManager";
                String targettemplate = mname.substring(0, index);
                if (templateclassname.equals(targettemplate)) {
                    node.getInterfaceCollectorMap().put(i, a.getValue());
                    continue;
                }
                for (Node.Interface i2 : node.getInterfaces()) {
                    templateclassname = i2.getName();
                    if (!templateclassname.equals(targettemplate)) continue;
                    i2.getInterfaceCollectorMap().put(i, a.getValue());
                    templateclassname = null;
                    break;
                }
                if (templateclassname == null) continue;
                throw new Error("Value of annotation de.serviceflow.codegenj.CollectorAPI contains a unkown target interface class at interface " + i.getName() + ": " + templateclassname);
            }
            for (Node.Interface.Property p : i.getProperties()) {
                for (Node.Interface.Member.Annotation a : p.getAnnotations()) {
                    if (!"de.serviceflow.codegenj.CollectorAPI".equals(a.getName())) continue;
                    if (!"read".equals(p.getAccess())) {
                        throw new Error("property-access at annotation de.serviceflow.codegenj.CollectorAPI must be 'read' at interface " + i.getName() + " at property " + p.getName());
                    }
                    if (!"ao".equals(p.getType())) {
                        throw new Error("property-type at annotation de.serviceflow.codegenj.CollectorAPI must be 'ao' at interface " + i.getName() + " at property " + p.getName());
                    }
                    String mname = a.getValue();
                    int index = mname.indexOf(35);
                    if (index >= 0) {
                        throw new Error("Value of annotation de.serviceflow.codegenj.CollectorAPI must be 'interfacename' at interface " + i.getName() + " at property " + p.getName());
                    }
                    String targettemplate = mname;
                    for (Node.Interface i2 : node.getInterfaces()) {
                        String templateclassname = i2.getName();
                        if (!templateclassname.equals(targettemplate)) continue;
                        i.getInterfaceCollectorMap().put(i2, i.getName() + "#*get" + p.getName());
                        targettemplate = null;
                        break;
                    }
                    if (targettemplate == null) continue;
                    throw new Error("Value of annotation de.serviceflow.codegenj.CollectorAPI contains a unkown target interface class at interface " + i.getName() + ": " + targettemplate);
                }
            }
        }
        classlist.append("de.serviceflow.codegenj.ObjectManager");
        for (Node.Interface i : node.getInterfaces()) {
            this.initHelper.processInterface(parameters, i);
            InterfaceSourceGenerator itp = new InterfaceSourceGenerator(i, parameters, this.destination);
            itp.open();
            itp.generate();
            itp.close();
            headerFiles.append(' ');
            headerFiles.append((String)parameters.get("interface.jname"));
            headerFiles.append(".h");
            classlist.append(' ');
            classlist.append((String)parameters.get("interface.name"));
            objFiles.append(' ');
            objFiles.append((String)parameters.get("interface.uname"));
            objFiles.append(".o");
        }
        parameters.remove("interface.name");
        for (Node c : node.getChilds()) {
            this.generateCode(c, node);
        }
        parameters.remove("node.name");
        parameters.put("headerfiles", headerFiles.toString());
        parameters.put("classlist", classlist.toString());
        parameters.put("objfiles", objFiles.toString());
        String xml = this.xmlFile;
        if (xml.lastIndexOf(47) >= 0) {
            xml = xml.substring(xml.lastIndexOf(47) + 1);
        }
        parameters.put("xmlfile", xml);
        MakefileGenerator mg = new MakefileGenerator(node, parameters, this.destination);
        mg.open();
        mg.generate();
        mg.close();
        ObjectManagerGenerator omg = new ObjectManagerGenerator(node, parameters, this.destination);
        omg.open();
        omg.generate();
        omg.close();
    }

    public static CodegenJ getInstance() {
        return instance;
    }

    public ObjectiveBlockHandler findProcessing(String processingObjectiveClassName) {
        return this.initHelper.getBlockMap().get(processingObjectiveClassName);
    }

    public class DBusValidationEventHandler
    implements ValidationEventHandler {
        public boolean handleEvent(ValidationEvent event) {
            System.out.println("*** Validation of XML input failed ***");
            System.out.println("MESSAGE:  " + event.getMessage());
            return false;
        }
    }
}

