/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import de.serviceflow.codegenj.TemplateParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class TemplateBlockParser
extends TemplateParser {
    private BufferedReader r;
    private int lineno = 0;
    private boolean returnBlockToken = false;
    private String[] bufferedTokens = null;
    private int bufferedTokensPointer = 0;
    private final String content;

    TemplateBlockParser(TemplateParser parent, String content) {
        super(parent.getTemplatePath());
        this.content = content;
    }

    @Override
    public void open() {
        this.r = new BufferedReader(new StringReader(this.content));
    }

    @Override
    public String readNext() {
        try {
            if (this.bufferedTokens == null || this.bufferedTokensPointer > this.bufferedTokens.length) {
                String strLine = this.r.readLine();
                if (strLine != null) {
                    ++this.lineno;
                    this.returnBlockToken = false;
                    this.bufferedTokens = strLine.split("###");
                    this.bufferedTokensPointer = 0;
                } else {
                    return EOF_TOKEN;
                }
            }
            if (this.bufferedTokensPointer < this.bufferedTokens.length) {
                if (this.returnBlockToken) {
                    this.returnBlockToken = !this.returnBlockToken;
                    return "###";
                }
                if (this.bufferedTokensPointer + 1 < this.bufferedTokens.length) {
                    this.returnBlockToken = !this.returnBlockToken;
                }
                return this.bufferedTokens[this.bufferedTokensPointer++];
            }
            if (this.returnBlockToken) {
                this.returnBlockToken = !this.returnBlockToken;
                return "###";
            }
            ++this.bufferedTokensPointer;
            return "\n";
        }
        catch (IOException e) {
            throw new Error("Internal error", e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String location() {
        return this.getTemplatePath() + ":" + this.lineno;
    }
}

