/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj.java;

import de.serviceflow.codegenj.Naming;
import de.serviceflow.codegenj.Node;
import de.serviceflow.codegenj.TemplateBlock;
import de.serviceflow.codegenj.TemplateParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Map;

public class InterfaceSourceGenerator {
    private final Node.Interface interfaceDef;
    private final String destination;
    private final Map<String, String> parameters;
    private String fileBaseName = null;
    private boolean isSkeleton = false;

    public InterfaceSourceGenerator(Node.Interface interfaceDef, Map<String, String> parameters, String destination) {
        this.interfaceDef = interfaceDef;
        this.parameters = parameters;
        this.destination = destination;
    }

    public void open() {
        String uname = this.parameters.get("interface.uname");
        this.fileBaseName = Naming.javaClassName(uname);
        for (Node.Interface.Member.Annotation a : this.interfaceDef.getAnnotations()) {
            if (!"de.serviceflow.codegenj.SkeletonAPI".equals(a.getName())) continue;
            this.isSkeleton = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        PrintWriter w;
        String ppath = this.packagePath();
        String dir = this.destination + "/generated";
        new File(dir + '/' + ppath).mkdirs();
        String jnidir = this.destination + "/jni";
        new File(jnidir).mkdirs();
        String jnihdir = jnidir + "/include";
        new File(jnihdir).mkdirs();
        TemplateParser t = new TemplateParser("template/java/interface_java.txt");
        t.open();
        try {
            w = new PrintWriter(new FileOutputStream(dir + "/" + ppath + this.fileBaseName + ".java"));
        }
        catch (FileNotFoundException e) {
            throw new Error("Can't create output file: " + e.getLocalizedMessage());
        }
        try {
            new TemplateBlock(this.interfaceDef, this.parameters, t, w).process();
        }
        finally {
            w.close();
        }
        t.close();
        if (this.isSkeleton) {
            t = new TemplateParser("template/java/skeleton_java.txt");
            t.open();
            try {
                w = new PrintWriter(new FileOutputStream(dir + "/" + ppath + this.fileBaseName + "CB.java"));
            }
            catch (FileNotFoundException e) {
                throw new Error("Can't create output file: " + e.getLocalizedMessage());
            }
            try {
                new TemplateBlock(this.interfaceDef, this.parameters, t, w).process();
            }
            finally {
                w.close();
            }
            t.close();
            t = new TemplateParser("template/java/skeleton_c.txt");
            t.open();
            try {
                w = new PrintWriter(new FileOutputStream(jnidir + "/" + this.fileBaseName + "CB.c"));
            }
            catch (FileNotFoundException e) {
                throw new Error("Can't create output file: " + e.getLocalizedMessage());
            }
            w.println("// " + this.interfaceDef.getName() + "CB.c");
            try {
                new TemplateBlock(this.interfaceDef, this.parameters, t, w).process();
            }
            finally {
                w.close();
            }
            t.close();
        } else {
            t = new TemplateParser("template/java/interfaceproxy_java.txt");
            t.open();
            try {
                w = new PrintWriter(new FileOutputStream(dir + "/" + ppath + this.fileBaseName + "Proxy.java"));
            }
            catch (FileNotFoundException e) {
                throw new Error("Can't create output file: " + e.getLocalizedMessage());
            }
            try {
                new TemplateBlock(this.interfaceDef, this.parameters, t, w).process();
            }
            finally {
                w.close();
            }
            t.close();
            t = new TemplateParser("template/java/interfaceskeleton_java.txt");
            t.open();
            try {
                w = new PrintWriter(new FileOutputStream(dir + "/" + ppath + this.fileBaseName + "Skeleton.java"));
            }
            catch (FileNotFoundException e) {
                throw new Error("Can't create output file: " + e.getLocalizedMessage());
            }
            try {
                new TemplateBlock(this.interfaceDef, this.parameters, t, w).process();
            }
            finally {
                w.close();
            }
            t.close();
            t = new TemplateParser("template/java/interfaceproxy_c.txt");
            t.open();
            try {
                w = new PrintWriter(new FileOutputStream(jnidir + "/" + this.fileBaseName + "Proxy.c"));
            }
            catch (FileNotFoundException e) {
                throw new Error("Can't create output file: " + e.getLocalizedMessage());
            }
            w.println("// " + this.interfaceDef.getName() + "Proxy.c");
            try {
                new TemplateBlock(this.interfaceDef, this.parameters, t, w).process();
            }
            finally {
                w.close();
            }
            t.close();
            t = new TemplateParser("template/java/interfaceskeleton_c.txt");
            t.open();
            try {
                w = new PrintWriter(new FileOutputStream(jnidir + "/" + this.fileBaseName + "Skeleton.c"));
            }
            catch (FileNotFoundException e) {
                throw new Error("Can't create output file: " + e.getLocalizedMessage());
            }
            w.println("// " + this.interfaceDef.getName() + "Skeleton.c");
            try {
                new TemplateBlock(this.interfaceDef, this.parameters, t, w).process();
            }
            finally {
                w.close();
            }
            t.close();
        }
    }

    private String packagePath() {
        String pname = this.parameters.get("busname");
        if (pname == null) {
            return "";
        }
        StringBuffer packagePath = new StringBuffer();
        int fromIndex = 0;
        int index = pname.indexOf(46, fromIndex);
        while (index >= 0) {
            packagePath.append(pname.substring(fromIndex, index));
            packagePath.append('/');
            fromIndex = index + 1;
            index = pname.indexOf(46, fromIndex);
        }
        packagePath.append(pname.substring(fromIndex));
        packagePath.append('/');
        return packagePath.toString();
    }

    public void close() {
        for (Node.Interface.Member.Annotation a : this.interfaceDef.getAnnotations()) {
            if (!"de.serviceflow.codegenj.CollectorAPI".equals(a.getName())) continue;
            String apiValue = a.getValue();
            int sep = apiValue.indexOf(35);
            if (sep < 0) {
                throw new Error("Syntax Error at annotation de.serviceflow.codegenj.CollectorAPI for interface " + this.interfaceDef.getName());
            }
            String apiClass = apiValue.substring(0, sep);
            String apiMethod = apiValue.substring(sep + 1);
            if (!"de.serviceflow.codegenj.ObjectManager".equals(apiClass)) continue;
        }
    }
}

