/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.ParameterProvider;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Paging
extends ParameterProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Paging.class);
    public static final Paging DEFAULT_START = new Paging(0, 64);
    private final int offset;
    private final int limit;

    private Paging(int myOffset, int myLimit) {
        if (myOffset < 0) {
            throw new IllegalArgumentException("Offset is " + myOffset + ", but must be >= 0");
        }
        if (myLimit <= 0) {
            throw new IllegalArgumentException("Limit is " + myLimit + ", but must be > 0");
        }
        this.offset = myOffset;
        this.limit = myLimit;
    }

    public static Paging at(int offset, int limit) {
        return new Paging(offset, limit);
    }

    public Paging previous() {
        int newOffset = this.offset - this.limit;
        if (newOffset < 0) {
            newOffset = 0;
        }
        return new Paging(newOffset, this.limit);
    }

    public Paging next() {
        return new Paging(this.offset + this.limit, this.limit);
    }

    @Override
    protected void apply(MultivaluedMap<String, String> requestParams) {
        log.info("paging={}", (Object)this);
        requestParams.put((Object)"limit", Collections.singletonList(Integer.toString(this.getLimit())));
        requestParams.put((Object)"offset", Collections.singletonList(Integer.toString(this.getOffset())));
    }

    @Generated
    public String toString() {
        return "Paging(offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Paging)) {
            return false;
        }
        Paging other = (Paging)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.getLimit() == other.getLimit();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Paging;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        return result;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }
}

