/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiorecorder.ConnectionHandler;
import de.sfuhrm.radiorecorder.ConsumerContext;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RadioRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RadioRunnable.class);
    public static final int BUFFER_SIZE = 8192;
    private final ConsumerContext consumerContext;
    private final ConnectionHandler configurator;

    public RadioRunnable(ConsumerContext consumerContext) {
        this.consumerContext = Objects.requireNonNull(consumerContext);
        this.configurator = new ConnectionHandler(consumerContext);
    }

    @Override
    public void run() {
        MDC.put((String)"id", (String)Integer.toString(this.consumerContext.getId()));
        log.debug("Station UUID is {}", (Object)this.consumerContext.getRadio().getUuid());
        try {
            this.configurator.consume(this.consumerContext.getUrl());
        }
        finally {
            MDC.remove((String)"id");
        }
    }
}

