/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import de.sfuhrm.radiorecorder.http.AbstractHttpConnectionBuilder;
import de.sfuhrm.radiorecorder.http.ApacheHttpClient4Connection;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheHttpClient4ConnectionBuilder
extends AbstractHttpConnectionBuilder
implements HttpConnectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClient4ConnectionBuilder.class);
    private final RequestConfig.Builder configBuilder = RequestConfig.custom();
    private final RequestBuilder requestBuilder;

    ApacheHttpClient4ConnectionBuilder(URL url) throws URISyntaxException {
        this.requestBuilder = RequestBuilder.get((URI)url.toURI());
        log.debug("Request for uri {}", (Object)this.requestBuilder.getUri());
    }

    @Override
    public HttpConnection build() throws IOException {
        if (this.connectTimeout.isPresent()) {
            this.configBuilder.setConnectTimeout(((Integer)this.connectTimeout.get()).intValue());
            this.configBuilder.setConnectionRequestTimeout(((Integer)this.connectTimeout.get()).intValue());
        }
        this.readTimeout.ifPresent(arg_0 -> ((RequestConfig.Builder)this.configBuilder).setSocketTimeout(arg_0));
        if (!this.requestProperties.isEmpty()) {
            this.requestProperties.forEach((arg_0, arg_1) -> ((RequestBuilder)this.requestBuilder).addHeader(arg_0, arg_1));
        }
        if (this.proxy.isPresent()) {
            HttpHost proxyHost = new HttpHost(((URL)this.proxy.get()).getHost(), ((URL)this.proxy.get()).getPort(), ((URL)this.proxy.get()).getProtocol());
            this.configBuilder.setProxy(proxyHost);
        }
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(this.configBuilder.build()).build();
        return new ApacheHttpClient4Connection(client, client.execute(this.requestBuilder.build()), this.requestBuilder.getUri());
    }
}

