/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import de.sfuhrm.radiorecorder.http.AbstractHttpConnectionBuilder;
import de.sfuhrm.radiorecorder.http.ApacheHttpClient5Connection;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheHttpClient5ConnectionBuilder
extends AbstractHttpConnectionBuilder
implements HttpConnectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClient5ConnectionBuilder.class);
    private final RequestConfig.Builder configBuilder = RequestConfig.custom();
    private final ClassicRequestBuilder requestBuilder;

    ApacheHttpClient5ConnectionBuilder(URL url) throws URISyntaxException {
        this.requestBuilder = ClassicRequestBuilder.get((URI)url.toURI());
        log.debug("Request for uri {}", (Object)this.requestBuilder.getUri());
    }

    @Override
    public HttpConnection build() throws IOException {
        if (this.connectTimeout.isPresent()) {
            this.configBuilder.setConnectTimeout(Timeout.ofMilliseconds((long)((Integer)this.connectTimeout.get()).intValue()));
            this.configBuilder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)((Integer)this.connectTimeout.get()).intValue()));
        }
        this.readTimeout.ifPresent(integer -> this.configBuilder.setResponseTimeout(Timeout.ofMilliseconds((long)integer.intValue())));
        if (!this.requestProperties.isEmpty()) {
            this.requestProperties.forEach((arg_0, arg_1) -> ((ClassicRequestBuilder)this.requestBuilder).addHeader(arg_0, arg_1));
        }
        if (this.proxy.isPresent()) {
            HttpHost proxyHost = new HttpHost(((URL)this.proxy.get()).getProtocol(), ((URL)this.proxy.get()).getHost(), ((URL)this.proxy.get()).getPort());
            this.configBuilder.setProxy(proxyHost);
        }
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(this.configBuilder.build()).build();
        return new ApacheHttpClient5Connection(client, client.execute(this.requestBuilder.build()), this.requestBuilder.getUri());
    }
}

