/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.base;

import de.sg_o.app.miio.base.CommandExecutionException;
import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.base.messages.Command;
import de.sg_o.app.miio.base.messages.Response;
import de.sg_o.app.miio.util.ByteArray;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class Device {
    private static final int PORT = 54321;
    private byte[] rcv = new byte[65507];
    private InetAddress ip;
    private Token token;
    private int retries;
    private String[] acceptableModels;
    private DatagramSocket socket;
    private int deviceID = -1;
    private int timeStamp = -1;
    private long methodID;

    public Device(InetAddress ip, Token token, String[] acceptableModels, int timeout, int retries) {
        this.ip = ip;
        this.token = token;
        this.acceptableModels = acceptableModels;
        if (timeout < 1) {
            timeout = 1000;
        }
        if (retries < 0) {
            retries = 0;
        }
        this.retries = retries;
        try {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    private boolean hello(InetAddress broadcast) {
        DatagramPacket packet;
        if (this.socket == null) {
            return false;
        }
        Command hello = new Command();
        byte[] helloMsg = hello.create();
        if (this.ip == null) {
            if (this.acceptableModels == null) {
                return false;
            }
            packet = new DatagramPacket(helloMsg, helloMsg.length, broadcast, 54321);
        } else {
            packet = new DatagramPacket(helloMsg, helloMsg.length, this.ip, 54321);
        }
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            return false;
        }
        packet = new DatagramPacket(this.rcv, this.rcv.length);
        try {
            this.socket.receive(packet);
        }
        catch (IOException e) {
            return false;
        }
        if (this.ip == null) {
            this.ip = packet.getAddress();
        }
        byte[] worker = new byte[2];
        System.arraycopy(this.rcv, 2, worker, 0, 2);
        int length = (int)ByteArray.fromBytes(worker);
        worker = new byte[length];
        System.arraycopy(this.rcv, 0, worker, 0, length);
        Response response = new Response(worker, null);
        if (!response.getToken().equals(new Token("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16))) {
            this.token = response.getToken();
        } else if (this.token == null) {
            return false;
        }
        if (response.getDeviceID() != -1 && response.getTimeStamp() != -1) {
            this.deviceID = response.getDeviceID();
            this.timeStamp = response.getTimeStamp();
            this.methodID = this.timeStamp & 0x1FFF;
            if (this.acceptableModels != null) {
                boolean modelOk = false;
                for (String s : this.acceptableModels) {
                    try {
                        if (!s.equals(this.model())) continue;
                        modelOk = true;
                    }
                    catch (CommandExecutionException commandExecutionException) {
                        // empty catch block
                    }
                }
                return modelOk;
            }
            return true;
        }
        return false;
    }

    public boolean discover() {
        boolean helloResponse = false;
        for (int helloRetries = this.retries; helloRetries >= 0; --helloRetries) {
            List<InetAddress> broadcast = this.listAllBroadcastAddresses();
            if (broadcast == null) {
                return false;
            }
            for (InetAddress i : broadcast) {
                if (!this.hello(i)) continue;
                helloResponse = true;
                break;
            }
            if (helloResponse) break;
        }
        return helloResponse;
    }

    public Response send(String method, Object params) throws CommandExecutionException {
        if (!(this.deviceID != -1 && this.timeStamp != -1 && this.token != null && this.ip != null || this.discover())) {
            throw new CommandExecutionException(CommandExecutionException.Error.DEVICE_NOT_FOUND);
        }
        if (this.methodID >= 10000L) {
            this.methodID = 1L;
        }
        if (this.ip == null || this.token == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.IP_OR_TOKEN_UNKNOWN);
        }
        if (this.socket == null) {
            return null;
        }
        ++this.timeStamp;
        Command msg = new Command(this.token, this.deviceID, this.timeStamp, this.methodID, method, params);
        ++this.methodID;
        int retriesLeft = this.retries;
        while (true) {
            try {
                return this.parseResponse(this.send(msg.create()));
            }
            catch (CommandExecutionException e) {
                if (retriesLeft > 0) {
                    --retriesLeft;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public String send(String payload) throws CommandExecutionException {
        if (payload == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        if (!(this.deviceID != -1 && this.timeStamp != -1 && this.token != null && this.ip != null || this.discover())) {
            throw new CommandExecutionException(CommandExecutionException.Error.DEVICE_NOT_FOUND);
        }
        if (this.methodID >= 10000L) {
            this.methodID = 1L;
        }
        if (this.ip == null || this.token == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.IP_OR_TOKEN_UNKNOWN);
        }
        if (this.socket == null) {
            return null;
        }
        ++this.timeStamp;
        Command msg = new Command(this.token, this.deviceID, this.timeStamp, this.methodID, "", null);
        ++this.methodID;
        int retriesLeft = this.retries;
        while (true) {
            try {
                byte[] resp;
                do {
                    if (Response.testMessage(resp = this.send(msg.create(payload)), this.token)) continue;
                    throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
                } while (resp.length <= 32);
                byte[] pl = new byte[resp.length - 32];
                System.arraycopy(resp, 32, pl, 0, pl.length);
                String payloadString = Response.decryptPayload(pl, this.token);
                if (payloadString == null) {
                    throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
                }
                return payloadString;
            }
            catch (CommandExecutionException e) {
                if (retriesLeft > 0) {
                    --retriesLeft;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private byte[] send(byte[] binMsg) throws CommandExecutionException {
        DatagramPacket packet = new DatagramPacket(binMsg, binMsg.length, this.ip, 54321);
        try {
            this.socket.send(packet);
        }
        catch (SocketTimeoutException to) {
            throw new CommandExecutionException(CommandExecutionException.Error.TIMEOUT);
        }
        catch (IOException e) {
            return null;
        }
        packet = new DatagramPacket(this.rcv, this.rcv.length);
        try {
            this.socket.receive(packet);
        }
        catch (SocketTimeoutException to) {
            throw new CommandExecutionException(CommandExecutionException.Error.TIMEOUT);
        }
        catch (IOException e) {
            return null;
        }
        byte[] worker = new byte[2];
        System.arraycopy(this.rcv, 2, worker, 0, 2);
        int length = (int)ByteArray.fromBytes(worker);
        worker = new byte[length];
        System.arraycopy(this.rcv, 0, worker, 0, length);
        return worker;
    }

    private Response parseResponse(byte[] rawData) throws CommandExecutionException {
        Response response = new Response(rawData, this.token);
        if (!response.isValid()) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        if (response.getPayloadID() != this.methodID - 1L) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        if (response.getDeviceID() != -1 && response.getTimeStamp() != -1) {
            if (response.getParams() == null) {
                throw new CommandExecutionException(CommandExecutionException.Error.EMPTY_RESPONSE);
            }
            if (response.getParams().getClass() == String.class && response.getParams().equals("unknown_method")) {
                throw new CommandExecutionException(CommandExecutionException.Error.UNKNOWN_METHOD);
            }
            return response;
        }
        throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
    }

    private List<InetAddress> listAllBroadcastAddresses() {
        Enumeration<NetworkInterface> interfaces;
        ArrayList<InetAddress> broadcastList = new ArrayList<InetAddress>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            try {
                if (networkInterface.isLoopback()) continue;
                if (!networkInterface.isUp()) {
                }
            }
            catch (SocketException e) {}
            continue;
            networkInterface.getInterfaceAddresses().stream().map(InterfaceAddress::getBroadcast).filter(Objects::nonNull).forEach(broadcastList::add);
        }
        return broadcastList;
    }

    public JSONObject sendToObject(String method, Object params) throws CommandExecutionException {
        Response resp = this.send(method, params);
        if (resp == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        if (resp.getParams() == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        if (resp.getParams().getClass() != JSONObject.class) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return (JSONObject)resp.getParams();
    }

    public JSONObject sendToObject(String method) throws CommandExecutionException {
        return this.sendToObject(method, null);
    }

    public JSONArray sendToArray(String method, Object params) throws CommandExecutionException {
        Response resp = this.send(method, params);
        if (resp == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        if (resp.getParams() == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        if (resp.getParams().getClass() != JSONArray.class) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return (JSONArray)resp.getParams();
    }

    public JSONArray sendToArray(String method) throws CommandExecutionException {
        return this.sendToArray(method, null);
    }

    public boolean sendOk(String method, Object params) throws CommandExecutionException {
        return this.sendToArray(method, params).optString(0).toLowerCase().equals("ok");
    }

    public boolean sendOk(String method) throws CommandExecutionException {
        return this.sendOk(method, null);
    }

    public JSONObject info() throws CommandExecutionException {
        return this.sendToObject("miIO.info");
    }

    public boolean update(String url, String md5) throws CommandExecutionException {
        if (url == null || md5 == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        if (md5.length() != 32) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONObject params = new JSONObject();
        params.put("mode", (Object)"normal");
        params.put("install", (Object)"1");
        params.put("app_url", (Object)url);
        params.put("file_md5", (Object)md5);
        params.put("proc", (Object)"dnld install");
        return this.sendOk("miIO.ota", params);
    }

    public int updateProgress() throws CommandExecutionException {
        int resp = this.sendToArray("miIO.get_ota_progress").optInt(0, -1);
        if (resp < 0 || resp > 100) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return resp;
    }

    public String updateStatus() throws CommandExecutionException {
        String resp = this.sendToArray("miIO.get_ota_state").optString(0, null);
        if (resp == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return resp;
    }

    public boolean configureRouter(String ssid, String password) throws CommandExecutionException {
        return this.configureRouter(ssid, password, 0);
    }

    public boolean configureRouter(String ssid, String password, int uid) throws CommandExecutionException {
        if (ssid == null || password == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONObject params = new JSONObject();
        params.put("ssid", (Object)ssid);
        params.put("passwd", (Object)password);
        params.put("uid", uid);
        return this.sendOk("miIO.config_router", params);
    }

    public String model() throws CommandExecutionException {
        JSONObject in = this.info();
        if (in == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return in.optString("model");
    }

    public String firmware() throws CommandExecutionException {
        JSONObject in = this.info();
        if (in == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return in.optString("fw_ver");
    }
}

