/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.base;

import de.sg_o.app.miio.util.ByteArray;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Token {
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final String ENCRYPTION_ALGORITHM_IMPLEMENTATION = "AES/CBC/PKCS5Padding";
    private byte[] token;

    public Token(byte[] token) {
        if (token == null) {
            token = new byte[]{};
        }
        this.token = token;
    }

    public Token(String token, int fallbackLength) {
        byte[] tmp = ByteArray.hexToBytes(token);
        if (tmp == null) {
            tmp = new byte[fallbackLength];
        }
        this.token = tmp;
    }

    public byte[] getToken() {
        return this.token;
    }

    public boolean checkToken() {
        return this.token.length == 16;
    }

    public byte[] getMd5() throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(this.token);
        return md.digest();
    }

    public byte[] getIv() throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(ByteArray.append(this.getMd5(), this.token));
        return md.digest();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token1 = (Token)o;
        return Arrays.equals(this.token, token1.token);
    }

    public int hashCode() {
        return Arrays.hashCode(this.token);
    }

    public String toString() {
        return ByteArray.bytesToHex(this.token).toLowerCase();
    }

    public byte[] encrypt(byte[] msg) {
        if (msg == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM_IMPLEMENTATION);
            SecretKeySpec key = new SecretKeySpec(this.getMd5(), ENCRYPTION_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(this.getIv());
            cipher.init(1, (Key)key, iv);
            return cipher.doFinal(msg);
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] decrypt(byte[] msg) {
        if (msg == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM_IMPLEMENTATION);
            SecretKeySpec key = new SecretKeySpec(this.getMd5(), ENCRYPTION_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(this.getIv());
            cipher.init(2, (Key)key, iv);
            return cipher.doFinal(msg);
        }
        catch (Exception e) {
            return null;
        }
    }
}

