/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.base.messages;

import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.base.messages.Message;
import java.nio.charset.Charset;
import org.json.JSONArray;
import org.json.JSONObject;

public class Response
extends Message {
    private Object params;

    public Response(Token token, int deviceID, int timeStamp, long payloadID, Object params) {
        super(token, 0, deviceID, timeStamp, payloadID);
        this.params = params;
    }

    public Response(byte[] message, Token token) {
        super(message, token);
        if (super.isValid() && message.length > 32) {
            byte[] payload = new byte[message.length - 32];
            System.arraycopy(message, 32, payload, 0, payload.length);
            payload = super.getToken().decrypt(payload);
            if (payload != null) {
                int i;
                Charset charset = Charset.forName("ISO-8859-1");
                for (i = 0; i < payload.length && payload[i] != 0; ++i) {
                }
                String pl = new String(payload, 0, i, charset);
                JSONObject ob = new JSONObject(pl);
                this.params = ob.optJSONObject("result");
                if (this.params == null) {
                    this.params = ob.optJSONArray("result");
                }
                if (this.params == null) {
                    this.params = ob.optString("result", null);
                }
            }
        }
    }

    public Response(Token token, int deviceID, int timeStamp) {
        super(token, 0, deviceID, timeStamp, 0L);
        this.params = null;
    }

    public Object getParams() {
        return this.params;
    }

    private String constructPayload() {
        JSONObject out = new JSONObject();
        out.put("id", super.getPayloadID());
        if (this.params != null) {
            Object paramsObj;
            if (this.params.getClass() == JSONObject.class) {
                paramsObj = (JSONObject)this.params;
                out.put("result", paramsObj);
            }
            if (this.params.getClass() == JSONArray.class) {
                paramsObj = (JSONArray)this.params;
                out.put("result", paramsObj);
            }
            if (this.params.getClass() == String.class) {
                paramsObj = (String)this.params;
                out.put("result", paramsObj);
            }
        }
        return out.toString();
    }

    @Override
    public boolean isHello() {
        return super.isHello() || this.params == null;
    }

    public byte[] create() {
        if (this.isHello()) {
            return super.create(null);
        }
        return super.create(this.constructPayload());
    }
}

