/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import de.sg_o.app.miio.base.CommandExecutionException;
import de.sg_o.app.miio.base.Device;
import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.vacuum.VacuumCleanup;
import de.sg_o.app.miio.vacuum.VacuumConsumableStatus;
import de.sg_o.app.miio.vacuum.VacuumDoNotDisturb;
import de.sg_o.app.miio.vacuum.VacuumSounpackInstallState;
import de.sg_o.app.miio.vacuum.VacuumStatus;
import de.sg_o.app.miio.vacuum.VacuumTimer;
import java.awt.Point;
import java.net.InetAddress;
import java.time.ZoneId;
import org.json.JSONArray;
import org.json.JSONObject;

public class Vacuum
extends Device {
    private int manualControlSequence = -1;

    public Vacuum(InetAddress ip, Token token, int timeout, int retries) {
        super(ip, token, new String[]{"rockrobo.vacuum.v1", "rockrobo.vacuum.v2"}, timeout, retries);
    }

    public VacuumStatus status() throws CommandExecutionException {
        JSONArray resp = this.sendToArray("get_status");
        JSONObject stat = resp.optJSONObject(0);
        if (stat == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return new VacuumStatus(stat);
    }

    public ZoneId getTimezone() throws CommandExecutionException {
        JSONArray resp = this.sendToArray("get_timezone");
        String zone = resp.optString(0, null);
        if (zone == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return ZoneId.of(zone);
    }

    public boolean setTimezone(ZoneId zone) throws CommandExecutionException {
        if (zone == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray tz = new JSONArray();
        tz.put((Object)zone.getId());
        return this.sendOk("set_timezone", tz);
    }

    public VacuumConsumableStatus consumableStatus() throws CommandExecutionException {
        JSONArray resp = this.sendToArray("get_consumable");
        JSONObject stat = resp.optJSONObject(0);
        if (stat == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return new VacuumConsumableStatus(stat);
    }

    public boolean resetConsumable(VacuumConsumableStatus.Names consumable) throws CommandExecutionException {
        if (consumable == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray params = new JSONArray();
        params.put((Object)consumable.toString());
        return this.sendOk("reset_consumable", params);
    }

    public boolean start() throws CommandExecutionException {
        return this.sendOk("app_start");
    }

    public boolean pause() throws CommandExecutionException {
        return this.sendOk("app_pause");
    }

    public boolean stop() throws CommandExecutionException {
        return this.sendOk("app_stop");
    }

    public boolean home() throws CommandExecutionException {
        this.stop();
        return this.sendOk("app_charge");
    }

    public boolean spotCleaning() throws CommandExecutionException {
        return this.sendOk("app_spot");
    }

    public boolean findMe() throws CommandExecutionException {
        return this.sendOk("find_me");
    }

    public int getFanSpeed() throws CommandExecutionException {
        int resp = this.sendToArray("get_custom_mode").optInt(0, -1);
        if (resp < 0 || resp > 100) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return resp;
    }

    public boolean setFanSpeed(int speed) throws CommandExecutionException {
        if (speed < 0 || speed > 100) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray params = new JSONArray();
        params.put(speed);
        return this.sendOk("set_custom_mode", params);
    }

    public VacuumTimer[] getTimers() throws CommandExecutionException {
        JSONArray tm = this.sendToArray("get_timer");
        if (tm == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        VacuumTimer[] timers = new VacuumTimer[tm.length()];
        for (int i = 0; i < tm.length(); ++i) {
            timers[i] = new VacuumTimer(tm.optJSONArray(i));
        }
        return timers;
    }

    public boolean addTimer(VacuumTimer timer) throws CommandExecutionException {
        if (timer == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray tm = timer.construct();
        if (tm == null) {
            return false;
        }
        JSONArray payload = new JSONArray();
        payload.put((Object)tm);
        return this.sendOk("set_timer", payload);
    }

    public boolean setTimerEnabled(VacuumTimer timer) throws CommandExecutionException {
        if (timer == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray payload = new JSONArray();
        payload.put((Object)timer.getID());
        payload.put((Object)timer.getOnOff());
        return this.sendOk("upd_timer", payload);
    }

    public boolean removeTimer(VacuumTimer timer) throws CommandExecutionException {
        if (timer == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray payload = new JSONArray();
        payload.put((Object)timer.getID());
        return this.sendOk("del_timer", payload);
    }

    public VacuumDoNotDisturb getDoNotDisturb() throws CommandExecutionException {
        return new VacuumDoNotDisturb(this.sendToArray("get_dnd_timer"));
    }

    public boolean setDoNotDisturb(VacuumDoNotDisturb dnd) throws CommandExecutionException {
        if (dnd == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        return this.sendOk("set_dnd_timer", dnd.construct());
    }

    public boolean disableDoNotDisturb() throws CommandExecutionException {
        return this.sendOk("close_dnd_timer");
    }

    public boolean goToMapPosition(int x, int y) throws CommandExecutionException {
        y = (y - 512) * -1 + 512;
        return this.goTo((float)x * 0.05f, (float)y * 0.05f);
    }

    public boolean goTo(float x, float y) throws CommandExecutionException {
        Point p = new Point();
        p.setLocation((double)x * 1000.0, (double)y * 1000.0);
        return this.goTo(p);
    }

    public boolean goTo(Point p) throws CommandExecutionException {
        if (p == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray payload = new JSONArray();
        payload.put(p.x);
        payload.put(p.y);
        return this.sendOk("app_goto_target", payload);
    }

    public boolean cleanAreaFromMap(int x0, int y0, int x1, int y1, int passes) throws CommandExecutionException {
        y0 = (y0 - 512) * -1 + 512;
        y1 = (y1 - 512) * -1 + 512;
        return this.cleanArea((float)x0 * 0.05f, (float)y0 * 0.05f, (float)x1 * 0.05f, (float)y1 * 0.05f, passes);
    }

    public boolean cleanArea(float x0, float y0, float x1, float y1, int passes) throws CommandExecutionException {
        float t;
        if (x0 > x1) {
            t = x0;
            x0 = x1;
            x1 = t;
        }
        if (y0 > y1) {
            t = y0;
            y0 = y1;
            y1 = t;
        }
        Point p0 = new Point();
        p0.setLocation((double)x0 * 1000.0, (double)y0 * 1000.0);
        Point p1 = new Point();
        p1.setLocation((double)x1 * 1000.0, (double)y1 * 1000.0);
        return this.cleanArea(p0, p1, passes);
    }

    public boolean cleanArea(Point bottomLeft, Point topRight, int passes) throws CommandExecutionException {
        if (bottomLeft == null || topRight == null || passes < 1) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray payload = new JSONArray();
        payload.put(bottomLeft.x);
        payload.put(bottomLeft.y);
        payload.put(topRight.x);
        payload.put(topRight.y);
        payload.put(passes);
        JSONArray wrapper = new JSONArray();
        wrapper.put((Object)payload);
        return this.sendOk("app_zoned_clean", wrapper);
    }

    private JSONArray getCleaningSummary() throws CommandExecutionException {
        return this.sendToArray("get_clean_summary");
    }

    public long getTotalCleaningTime() throws CommandExecutionException {
        return this.getCleaningSummary().optLong(0);
    }

    public long getTotalCleanedArea() throws CommandExecutionException {
        return this.getCleaningSummary().optLong(1);
    }

    public long getTotalCleans() throws CommandExecutionException {
        return this.getCleaningSummary().optLong(2);
    }

    public VacuumCleanup[] getAllCleanups() throws CommandExecutionException {
        JSONArray cleanupIDs = this.getCleaningSummary().optJSONArray(3);
        if (cleanupIDs == null) {
            return null;
        }
        VacuumCleanup[] res = new VacuumCleanup[cleanupIDs.length()];
        for (int i = 0; i < cleanupIDs.length(); ++i) {
            JSONArray send = new JSONArray();
            send.put(cleanupIDs.optLong(i));
            JSONArray ar = this.sendToArray("get_clean_record", send).optJSONArray(0);
            res[i] = new VacuumCleanup(ar);
        }
        return res;
    }

    public int getSoundVolume() throws CommandExecutionException {
        JSONArray res = this.sendToArray("get_sound_volume");
        if (res == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        int vol = res.optInt(0, -1);
        if (vol < 0) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return vol;
    }

    public boolean setSoundVolume(int volume) throws CommandExecutionException {
        if (volume < 0) {
            volume = 0;
        }
        if (volume > 100) {
            volume = 100;
        }
        JSONArray payload = new JSONArray();
        payload.put(volume);
        return this.sendOk("change_sound_volume", payload);
    }

    public boolean testSoundVolume() throws CommandExecutionException {
        return this.sendOk("test_sound_volume");
    }

    public boolean manualControlStart() throws CommandExecutionException {
        this.manualControlSequence = 1;
        return this.sendOk("app_rc_start");
    }

    public boolean manualControlStop() throws CommandExecutionException {
        this.manualControlSequence = -1;
        return this.sendOk("app_rc_end");
    }

    public boolean manualControlMove(float rotationSpeed, float speed, int runDuration) throws CommandExecutionException {
        if (this.manualControlSequence < 1) {
            this.manualControlStart();
        }
        JSONObject payload = new JSONObject();
        if (rotationSpeed > 180.0f) {
            rotationSpeed = 180.0f;
        }
        if (rotationSpeed < -180.0f) {
            rotationSpeed = -180.0f;
        }
        float rotationRadians = (float)Math.round((double)(rotationSpeed / 180.0f) * 272.0) / 100.0f;
        payload.put("omega", rotationRadians);
        if (speed >= 0.3f) {
            speed = 0.29f;
        }
        if (speed <= -0.3f) {
            speed = -0.29f;
        }
        payload.put("velocity", speed);
        if (runDuration < 0) {
            runDuration = 1000;
        }
        payload.put("duration", runDuration);
        payload.put("seqnum", this.manualControlSequence);
        ++this.manualControlSequence;
        JSONArray send = new JSONArray();
        send.put((Object)payload);
        return this.sendOk("app_rc_move", send);
    }

    public VacuumSounpackInstallState installSoundpack(String url, String md5, int soundId) throws CommandExecutionException {
        if (url == null || md5 == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONObject install = new JSONObject();
        install.put("url", (Object)url);
        install.put("md5", (Object)md5);
        install.put("sid", soundId);
        JSONArray ret = this.sendToArray("dnld_install_sound", install);
        if (ret == null) {
            return null;
        }
        return new VacuumSounpackInstallState(ret.optJSONObject(0));
    }

    public VacuumSounpackInstallState soundpackInstallStatus() throws CommandExecutionException {
        JSONArray ret = this.sendToArray("get_sound_progress");
        if (ret == null) {
            return null;
        }
        return new VacuumSounpackInstallState(ret.optJSONObject(0));
    }

    public JSONObject getCarpetModeState() throws CommandExecutionException {
        JSONArray ret = this.sendToArray("get_carpet_mode");
        if (ret == null) {
            return null;
        }
        return ret.optJSONObject(0);
    }

    public boolean setCarpetMode(boolean enabled, int high, int low, int integral, int stallTime) throws CommandExecutionException {
        JSONObject payload = new JSONObject();
        payload.put("enable", enabled ? 1 : 0);
        payload.put("current_high", high);
        payload.put("current_low", low);
        payload.put("current_integral", integral);
        payload.put("stall_time", stallTime);
        JSONArray send = new JSONArray();
        send.put((Object)payload);
        return this.sendOk("set_carpet_mode", send);
    }

    public String getSerialnumber() throws CommandExecutionException {
        JSONArray ret = this.sendToArray("get_serial_number");
        if (ret == null) {
            return null;
        }
        return ret.optJSONObject(0).optString("serial_number");
    }
}

