/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import java.time.LocalTime;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class VacuumDoNotDisturb {
    private LocalTime start;
    private LocalTime end;
    private boolean enabled;

    public VacuumDoNotDisturb(LocalTime start, LocalTime end, boolean enabled) {
        if (start == null) {
            start = LocalTime.of(22, 0);
        }
        this.start = start;
        if (end == null) {
            end = LocalTime.of(8, 0);
        }
        this.end = end;
        this.enabled = enabled;
    }

    public VacuumDoNotDisturb(LocalTime start, LocalTime end) {
        if (start == null) {
            start = LocalTime.of(22, 0);
        }
        this.start = start;
        if (end == null) {
            end = LocalTime.of(8, 0);
        }
        this.end = end;
        this.enabled = true;
    }

    public VacuumDoNotDisturb(JSONArray dnd) {
        JSONObject obj = dnd.optJSONObject(0);
        if (obj != null) {
            this.start = LocalTime.of(obj.optInt("start_hour"), obj.optInt("start_minute"));
            this.end = LocalTime.of(obj.optInt("end_hour"), obj.optInt("end_minute"));
            this.enabled = obj.optInt("enabled", 1) == 1;
        } else {
            this.start = LocalTime.of(dnd.optInt(0), dnd.optInt(1));
            this.end = LocalTime.of(dnd.optInt(2), dnd.optInt(3));
            this.enabled = true;
        }
    }

    public LocalTime getStart() {
        return this.start;
    }

    public LocalTime getEnd() {
        return this.end;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public JSONArray construct() {
        return this.construct(false);
    }

    public JSONArray construct(boolean server) {
        JSONArray dnd = new JSONArray();
        if (server) {
            JSONObject srv = new JSONObject();
            srv.put("start_hour", this.start.getHour());
            srv.put("start_minute", this.start.getMinute());
            srv.put("end_hour", this.end.getHour());
            srv.put("end_minute", this.end.getMinute());
            srv.put("enabled", this.enabled ? 1 : 0);
            dnd.put((Object)srv);
        } else {
            dnd.put(this.start.getHour());
            dnd.put(this.start.getMinute());
            dnd.put(this.end.getHour());
            dnd.put(this.end.getMinute());
        }
        return dnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumDoNotDisturb that = (VacuumDoNotDisturb)o;
        return this.enabled == that.enabled && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.enabled);
    }

    public String toString() {
        return "VacuumDoNotDisturb{start=" + this.start + ", end=" + this.end + ", enabled=" + this.enabled + '}';
    }
}

