/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;

public class VacuumMap
implements Serializable {
    private static final long serialVersionUID = 6328146796574327681L;
    private transient BufferedImage map;
    private transient List<Point2D.Float> path = new LinkedList<Point2D.Float>();
    private Rectangle boundingBox;
    private int overSample;

    public VacuumMap(BufferedReader image, BufferedReader slam, int overSample) {
        if (overSample < 1) {
            overSample = 1;
        }
        this.overSample = overSample;
        this.map = new BufferedImage(1024 * overSample, 1024 * overSample, 5);
        this.boundingBox = new Rectangle(1024 * overSample, 1024 * overSample);
        try {
            this.readMap(image);
            this.readSlam(slam);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readMap(BufferedReader image) throws IOException {
        int x = 0;
        int y = 0;
        int top = this.map.getHeight();
        int bottom = 0;
        int left = this.map.getWidth();
        int right = 0;
        if (image.readLine() == null) {
            return;
        }
        if (image.readLine() == null) {
            return;
        }
        while (true) {
            int[] rgb;
            if ((rgb = new int[]{image.read(), image.read(), image.read()})[0] < 0 || rgb[1] < 0 || rgb[2] < 0) {
                this.boundingBox = new Rectangle(left, top, right - left + 1, bottom - top + 1);
                return;
            }
            for (int i = 0; i < rgb.length; ++i) {
                rgb[i] = rgb[i] & 0xFF;
            }
            for (int j = 0; j < this.overSample; ++j) {
                for (int i = 0; i < this.overSample; ++i) {
                    this.map.setRGB(x + i, y + j, new Color(rgb[0], rgb[1], rgb[2]).getRGB());
                }
            }
            if (rgb[0] != 125 || rgb[1] != 125 || rgb[2] != 125) {
                if (x < left) {
                    left = x;
                }
                if (x > right) {
                    right = x + (this.overSample - 1);
                }
                if (y < top) {
                    top = y;
                }
                if (y > bottom) {
                    bottom = y + (this.overSample - 1);
                }
            }
            if ((x += this.overSample) >= this.map.getWidth()) {
                x = 0;
                y += this.overSample;
            }
            if (y < this.map.getHeight()) continue;
            y = 0;
        }
    }

    private void readSlam(BufferedReader slam) throws IOException {
        String line;
        boolean locked = true;
        while ((line = slam.readLine()) != null) {
            String[] split;
            if (line.contains("reset")) {
                this.path = new LinkedList<Point2D.Float>();
            }
            if (line.contains("lock")) {
                locked = true;
            }
            if (line.contains("unlock")) {
                locked = false;
            }
            if (locked || !line.contains("estimate") || (split = line.split("\\s+")).length != 5) continue;
            try {
                float x = Float.valueOf(split[2]).floatValue() * (20.0f * (float)this.overSample);
                float y = Float.valueOf(split[3]).floatValue() * (-20.0f * (float)this.overSample);
            }
            catch (Exception e) {
                continue;
            }
            this.path.add(new Point2D.Float(x += (float)this.map.getWidth() / 2.0f, y += (float)this.map.getHeight() / 2.0f));
        }
    }

    public BufferedImage getMap() {
        return this.map;
    }

    public List<Point2D.Float> getPath() {
        return this.path;
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public int[] mapPointScale(Point p) {
        if (p == null) {
            p = new Point(0, 0);
        }
        int[] scaled = new int[]{p.x / this.overSample, p.y / this.overSample};
        return scaled;
    }

    public int[] mapRectangleScale(Rectangle rec) {
        if (rec == null) {
            rec = new Rectangle(0, 0, 0, 0);
        }
        int[] scaled = new int[]{rec.x / this.overSample, rec.y / this.overSample, rec.x / this.overSample + rec.width / this.overSample, rec.y / this.overSample + rec.height / this.overSample};
        return scaled;
    }

    public BufferedImage getMapWithPathInBounds() {
        return this.getMapWithPathInBounds(null, null);
    }

    public BufferedImage getMapWithPathInBounds(Color startColor, Color pathColor) {
        BufferedImage raw = this.getMapWithPath(startColor, pathColor);
        return raw.getSubimage(this.boundingBox.x, this.boundingBox.y, this.boundingBox.width, this.boundingBox.height);
    }

    public BufferedImage getMapWithPath() {
        return this.getMapWithPath(null, null);
    }

    public BufferedImage getMapWithPath(Color startColor, Color pathColor) {
        if (startColor == null) {
            startColor = Color.GREEN;
        }
        if (pathColor == null) {
            pathColor = Color.BLUE;
        }
        BufferedImage pathMap = new BufferedImage(1024 * this.overSample, 1024 * this.overSample, 5);
        Graphics2D img = pathMap.createGraphics();
        img.drawImage(this.map, null, 0, 0);
        img.setBackground(startColor);
        img.setColor(startColor);
        int[] home = new int[]{pathMap.getWidth() / 2 - 3 * this.overSample, pathMap.getHeight() / 2 - 3 * this.overSample};
        img.fillOval(home[0], home[1], 6 * this.overSample, 6 * this.overSample);
        img.setColor(pathColor);
        BasicStroke bs = new BasicStroke(1.0f);
        img.setStroke(bs);
        Point2D.Float prev = null;
        for (Point2D.Float p : this.path) {
            if (prev == null) {
                prev = p;
                continue;
            }
            img.drawLine((int)prev.x, (int)prev.y, (int)p.x, (int)p.y);
            prev = p;
        }
        return pathMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumMap vacuumMap = (VacuumMap)o;
        if (this.map.getWidth() != vacuumMap.map.getWidth() || this.map.getHeight() != vacuumMap.map.getHeight()) {
            return false;
        }
        int w = this.map.getWidth();
        int h = this.map.getHeight();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (this.map.getRGB(i, j) == vacuumMap.map.getRGB(i, j)) continue;
                return false;
            }
        }
        return this.overSample == vacuumMap.overSample && Objects.equals(this.path, vacuumMap.path) && Objects.equals(this.boundingBox, vacuumMap.boundingBox);
    }

    public int hashCode() {
        return Objects.hash(this.map.getHeight(), this.map.getWidth(), this.path, this.boundingBox, this.overSample);
    }

    public String toString() {
        return "VacuumMap{map=width:" + this.map.getWidth() + "; height:" + this.map.getHeight() + ", pathEntries=" + this.path.size() + ", boundingBox=" + this.boundingBox + ", overSample=" + this.overSample + '}';
    }

    private byte[] mapToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.map, "png", baos);
        baos.flush();
        byte[] imgInByte = baos.toByteArray();
        baos.close();
        return imgInByte;
    }

    private void bytesToMap(byte[] source) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        this.map = ImageIO.read(bais);
        if (this.map == null) {
            this.map = new BufferedImage(1024 * this.overSample, 1024 * this.overSample, 5);
        }
    }

    private byte[] pathToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.path);
        oos.flush();
        baos.flush();
        byte[] outputTrimmed = baos.toByteArray();
        oos.close();
        baos.close();
        return outputTrimmed;
    }

    private void bytesToPath(byte[] source) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        try {
            this.path = (List)o;
        }
        catch (ClassCastException e) {
            throw new IOException("Cant convert to path");
        }
        ois.close();
        bais.close();
    }

    private byte[] compress(byte[] data) {
        byte[] output = new byte[data.length + 1000];
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        byte[] outputTrimmed = new byte[compressor.deflate(output)];
        System.arraycopy(output, 0, outputTrimmed, 0, outputTrimmed.length);
        return outputTrimmed;
    }

    private void inflate(byte[] compressed, byte[] restored) throws IOException {
        Inflater inflate = new Inflater();
        inflate.setInput(compressed);
        inflate.finished();
        try {
            int restoredBytes = inflate.inflate(restored);
            if (restoredBytes != restored.length) {
                throw new IOException("Image size does not match");
            }
        }
        catch (DataFormatException e) {
            throw new IOException("Inflation failed");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        byte[] imgBytes = this.mapToBytes();
        byte[] compressedMap = this.compress(imgBytes);
        byte[] pathBytes = this.pathToBytes();
        byte[] compressedPath = this.compress(pathBytes);
        out.writeInt(compressedMap.length);
        out.writeInt(imgBytes.length);
        out.writeInt(compressedPath.length);
        out.writeInt(pathBytes.length);
        out.write(compressedMap);
        out.write(compressedPath);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] compressedMap = new byte[in.readInt()];
        byte[] mapBytes = new byte[in.readInt()];
        byte[] compressedPath = new byte[in.readInt()];
        byte[] pathBytes = new byte[in.readInt()];
        in.readFully(compressedMap);
        in.readFully(compressedPath);
        this.inflate(compressedMap, mapBytes);
        this.inflate(compressedPath, pathBytes);
        this.bytesToMap(mapBytes);
        this.bytesToPath(pathBytes);
    }
}

