/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import de.sg_o.app.miio.base.CommandExecutionException;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;

public class VacuumTimer {
    private String ID;
    private boolean enabled;
    private LocalTime time;
    private Set<DayOfWeek> runDays;
    private JSONArray job;

    public VacuumTimer(String ID, boolean enabled, LocalTime time, Set<DayOfWeek> runDays, JSONArray job) {
        if (ID == null) {
            ID = Long.valueOf(System.currentTimeMillis()).toString();
        }
        this.ID = ID;
        this.enabled = enabled;
        this.time = time;
        if (runDays == null) {
            runDays = new HashSet<DayOfWeek>();
        }
        this.runDays = runDays;
        this.job = job;
    }

    public VacuumTimer(String ID, boolean enabled, int hour, int minute, Set<DayOfWeek> runDays) {
        if (ID == null) {
            ID = Long.valueOf(System.currentTimeMillis()).toString();
        }
        this.ID = ID;
        this.enabled = enabled;
        if (hour > 23) {
            hour = 23;
        }
        if (hour < 0) {
            hour = 0;
        }
        if (minute > 59) {
            minute = 59;
        }
        if (minute < 0) {
            minute = 0;
        }
        this.time = LocalTime.of(hour, minute);
        if (runDays == null) {
            runDays = new HashSet<DayOfWeek>();
        }
        this.runDays = runDays;
    }

    public VacuumTimer(JSONArray timer) throws CommandExecutionException {
        String cron;
        JSONArray jobArray;
        if (timer == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        int length = timer.length();
        this.runDays = new HashSet<DayOfWeek>();
        this.ID = timer.optString(0, Long.valueOf(System.currentTimeMillis()).toString());
        if (length > 2) {
            this.enabled = timer.optString(1).equals("on");
            jobArray = timer.optJSONArray(2);
        } else {
            this.enabled = true;
            jobArray = timer.optJSONArray(1);
        }
        if (jobArray != null) {
            cron = jobArray.optString(0, null);
            if (cron == null) {
                throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
            }
        } else {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        this.parseCron(cron);
        this.job = jobArray.optJSONArray(1);
    }

    private void parseCron(String cron) throws CommandExecutionException {
        if (cron == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        String[] values = cron.split("\\s+");
        if (values.length != 5) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        try {
            int minute = Integer.valueOf(values[0]);
            int hour = Integer.valueOf(values[1]);
            this.time = LocalTime.of(hour, minute);
        }
        catch (NumberFormatException ignore) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        String[] dayValues = values[4].split(",");
        if (dayValues.length > 0 && !dayValues[0].equals("*")) {
            try {
                for (String day : dayValues) {
                    int d = Integer.valueOf(day);
                    if (d > 6) continue;
                    if (d == 0) {
                        d = 7;
                    }
                    this.runDays.add(DayOfWeek.of(d));
                }
            }
            catch (NumberFormatException ignore) {
                throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
            }
        }
    }

    private String generateCron() {
        if (this.time == null) {
            return null;
        }
        StringBuilder days = new StringBuilder();
        if (this.runDays.size() > 0) {
            for (DayOfWeek d : this.runDays) {
                int dValue = d.getValue();
                if (dValue == 7) {
                    dValue = 0;
                }
                days.append(dValue);
                days.append(",");
            }
            days.delete(days.length() - 1, days.length());
        } else {
            days.append("*");
        }
        return this.time.getMinute() + " " + this.time.getHour() + " * * " + days.toString();
    }

    public JSONArray construct() {
        return this.construct(false);
    }

    public JSONArray construct(boolean server) {
        JSONArray jobArray = new JSONArray();
        String cron = this.generateCron();
        if (cron == null) {
            return null;
        }
        jobArray.put((Object)cron);
        if (server) {
            if (this.job == null) {
                return null;
            }
            jobArray.put((Object)this.job);
        } else {
            JSONArray empty = new JSONArray();
            empty.put((Object)"");
            empty.put((Object)"");
            jobArray.put((Object)empty);
        }
        JSONArray timer = new JSONArray();
        timer.put((Object)this.ID);
        if (server) {
            timer.put((Object)this.getOnOff());
        }
        timer.put((Object)jobArray);
        return timer;
    }

    public String getID() {
        return this.ID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getOnOff() {
        return this.enabled ? "on" : "off";
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public Set<DayOfWeek> getRunDays() {
        return this.runDays;
    }

    public JSONArray getJob() {
        return this.job;
    }

    public void setJob(JSONArray job) {
        this.job = job;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumTimer that = (VacuumTimer)o;
        return this.enabled == that.enabled && Objects.equals(this.ID, that.ID);
    }

    public int hashCode() {
        return Objects.hash(this.ID, this.enabled);
    }

    public String toString() {
        return "VacuumTimer{ID='" + this.ID + '\'' + ", enabled=" + this.enabled + ", time=" + this.time + ", runDays=" + this.runDays + ", job=" + this.job + '}';
    }
}

