/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.base.messages;

import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.base.messages.Message;
import java.nio.charset.Charset;
import org.json.JSONArray;
import org.json.JSONObject;

public class Command
extends Message {
    private String method;
    private Object params;

    public Command(Token token, int deviceID, int timeStamp, long payloadID, String method, Object params) {
        super(token, 0, deviceID, timeStamp, payloadID);
        if (method == null) {
            method = "";
        }
        this.method = method;
        this.params = params;
    }

    public Command(byte[] message, Token token) {
        super(message, token);
        if (super.isValid() && message.length > 32) {
            byte[] payload = new byte[message.length - 32];
            System.arraycopy(message, 32, payload, 0, payload.length);
            payload = super.getToken().decrypt(payload);
            if (payload != null) {
                int i;
                Charset charset = Charset.forName("ISO-8859-1");
                for (i = 0; i < payload.length && payload[i] != 0; ++i) {
                }
                String pl = new String(payload, 0, i, charset);
                JSONObject ob = new JSONObject(pl);
                this.method = ob.optString("method", null);
                this.params = ob.optJSONObject("params");
                if (this.params == null) {
                    this.params = ob.optJSONArray("params");
                }
            }
        }
    }

    public Command() {
        super(null, -1, -1, -1, 0L);
        this.method = null;
        this.params = null;
    }

    public String getMethod() {
        return this.method;
    }

    public Object getParams() {
        return this.params;
    }

    private String constructPayload() {
        JSONObject out = new JSONObject();
        out.put("id", super.getPayloadID());
        if (this.method == null) {
            return null;
        }
        out.put("method", (Object)this.method);
        if (this.params != null) {
            JSONObject paramsObj;
            if (this.params.getClass() == JSONObject.class && (paramsObj = (JSONObject)this.params).length() > 0) {
                out.put("params", (Object)paramsObj);
            }
            if (this.params.getClass() == JSONArray.class) {
                paramsObj = (JSONArray)this.params;
                out.put("params", (Object)paramsObj);
            }
        } else {
            out.put("params", (Object)new JSONArray());
        }
        return out.toString();
    }

    public byte[] create() {
        if (super.isHello()) {
            return super.create(null);
        }
        return super.create(this.constructPayload());
    }
}

