/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.base.messages;

import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.util.ByteArray;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.json.JSONObject;

public abstract class Message {
    private static final short HEADER = 8497;
    static final int HELLO_UNKNOWN = -1;
    static final int HELLO_DEVICE_ID = -1;
    static final int HELLO_TIME_STAMP = -1;
    static final int NORMAL_UNKNOWN = 0;
    private Token token;
    private int unknownHeader;
    private int deviceID;
    private int timeStamp;
    private long payloadID;
    private boolean valid;

    public Message(Token token, int unknownHeader, int deviceID, int timeStamp, long payloadID) {
        this.token = token == null ? new Token("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16) : token;
        this.unknownHeader = unknownHeader;
        this.deviceID = deviceID;
        this.timeStamp = timeStamp;
        this.payloadID = payloadID;
        this.valid = true;
    }

    public Message(byte[] message, Token token) {
        this.token = token == null ? new Token("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16) : token;
        if (!Message.testMessage(message, this.token)) {
            this.valid = false;
        } else {
            byte[] worker = new byte[4];
            System.arraycopy(message, 4, worker, 0, 4);
            this.unknownHeader = (int)ByteArray.fromBytes(worker);
            System.arraycopy(message, 8, worker, 0, 4);
            this.deviceID = (int)ByteArray.fromBytes(worker);
            System.arraycopy(message, 12, worker, 0, 4);
            this.timeStamp = (int)ByteArray.fromBytes(worker);
            if (this.unknownHeader == -1 || message.length == 32) {
                worker = new byte[16];
                System.arraycopy(message, 16, worker, 0, 16);
                this.token = new Token(worker);
            }
            if (message.length > 32) {
                byte[] payload = new byte[message.length - 32];
                System.arraycopy(message, 32, payload, 0, payload.length);
                String pl = Message.decryptPayload(payload, this.token);
                if (pl != null) {
                    JSONObject ob = new JSONObject(pl);
                    this.payloadID = ob.optLong("id");
                }
            }
            this.valid = true;
        }
    }

    public static boolean testMessage(byte[] message, Token tk) {
        if (message == null) {
            return false;
        }
        if (message.length < 32) {
            return false;
        }
        byte[] worker = new byte[2];
        System.arraycopy(message, 0, worker, 0, 2);
        if ((short)ByteArray.fromBytes(worker) != 8497) {
            return false;
        }
        System.arraycopy(message, 2, worker, 0, 2);
        if ((int)ByteArray.fromBytes(worker) != message.length) {
            return false;
        }
        worker = new byte[4];
        System.arraycopy(message, 4, worker, 0, 4);
        int ukHeader = (int)ByteArray.fromBytes(worker);
        if (ukHeader != -1 && message.length != 32) {
            MessageDigest md;
            byte[] md5 = new byte[16];
            System.arraycopy(message, 16, md5, 0, 16);
            System.arraycopy(tk.getToken(), 0, message, 16, 16);
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                return false;
            }
            md.update(message);
            return Arrays.equals(md.digest(), md5);
        }
        return true;
    }

    public static String decryptPayload(byte[] payload, Token tk) {
        if (tk == null) {
            return null;
        }
        if ((payload = tk.decrypt(payload)) != null) {
            int i;
            Charset charset = Charset.forName("ISO-8859-1");
            for (i = 0; i < payload.length && payload[i] != 0; ++i) {
            }
            return new String(payload, 0, i, charset);
        }
        return null;
    }

    public Token getToken() {
        return this.token;
    }

    public boolean isHello() {
        return this.unknownHeader == -1;
    }

    public int getDeviceID() {
        return this.deviceID;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public long getPayloadID() {
        return this.payloadID;
    }

    public boolean isValid() {
        return this.valid;
    }

    private byte[] getBytePayload(String payload) {
        if (payload == null) {
            return new byte[0];
        }
        CharsetEncoder enc = Charset.forName("ISO-8859-1").newEncoder();
        int len = payload.length();
        byte[] b = new byte[len + 1];
        ByteBuffer buf = ByteBuffer.wrap(b);
        enc.encode(CharBuffer.wrap(payload), buf, true);
        b[len] = 0;
        return b;
    }

    private byte[] getPayload(String payload) {
        return this.token.encrypt(this.getBytePayload(payload));
    }

    public byte[] create(String pl) {
        if (!this.valid) {
            return null;
        }
        byte[] payload = new byte[]{};
        if (pl != null) {
            payload = this.getPayload(pl);
        }
        byte[] msg = new byte[32 + payload.length];
        short length = (short)msg.length;
        System.arraycopy(ByteArray.toBytes(8497L, 2), 0, msg, 0, 2);
        System.arraycopy(ByteArray.toBytes(length, 2), 0, msg, 2, 2);
        System.arraycopy(ByteArray.toBytes(this.unknownHeader, 4), 0, msg, 4, 4);
        System.arraycopy(ByteArray.toBytes(this.deviceID, 4), 0, msg, 8, 4);
        System.arraycopy(ByteArray.toBytes(this.timeStamp, 4), 0, msg, 12, 4);
        System.arraycopy(this.token.getToken(), 0, msg, 16, 16);
        System.arraycopy(payload, 0, msg, 32, payload.length);
        if (!this.isHello()) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
            md.update(msg);
            System.arraycopy(md.digest(), 0, msg, 16, 16);
        }
        return msg;
    }
}

