/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import java.io.Serializable;
import java.util.Objects;
import org.json.JSONObject;

public class VacuumConsumableStatus
implements Serializable {
    private static final long serialVersionUID = 8580701665863054538L;
    public static final int MAIN_BRUSH_TIME_BETWEEN_CHANGE = 1080000;
    public static final int SIDE_BRUSH_TIME_BETWEEN_CHANGE = 720000;
    public static final int FILTER_TIME_BETWEEN_CHANGE = 540000;
    public static final int SENSOR_TIME_BETWEEN_CLEANING = 108000;
    private int mainBrushWorkTime = 0;
    private int sensorTimeSinceCleaning = 0;
    private int sideBrushWorkTime = 0;
    private int filterWorkTime = 0;

    public VacuumConsumableStatus(int mainBrushWorkTime, int sensorTimeSinceCleaning, int sideBrushWorkTime, int filterWorkTime) {
        this.mainBrushWorkTime = mainBrushWorkTime;
        this.sensorTimeSinceCleaning = sensorTimeSinceCleaning;
        this.sideBrushWorkTime = sideBrushWorkTime;
        this.filterWorkTime = filterWorkTime;
    }

    public VacuumConsumableStatus(JSONObject consumables) {
        if (consumables != null) {
            this.mainBrushWorkTime = consumables.optInt(Names.MAIN_BRUSH.toString());
            this.sensorTimeSinceCleaning = consumables.optInt(Names.SENSOR.toString());
            this.sideBrushWorkTime = consumables.optInt(Names.SIDE_BRUSH.toString());
            this.filterWorkTime = consumables.optInt(Names.FILTER.toString());
        }
    }

    public JSONObject construct() {
        JSONObject payload = new JSONObject();
        payload.put(Names.MAIN_BRUSH.toString(), this.mainBrushWorkTime);
        payload.put(Names.SENSOR.toString(), this.sensorTimeSinceCleaning);
        payload.put(Names.SIDE_BRUSH.toString(), this.sideBrushWorkTime);
        payload.put(Names.FILTER.toString(), this.filterWorkTime);
        return payload;
    }

    public void reset(String name) {
        if (name.equals(Names.MAIN_BRUSH.toString())) {
            this.mainBrushWorkTime = 0;
        }
        if (name.equals(Names.SENSOR.toString())) {
            this.sensorTimeSinceCleaning = 0;
        }
        if (name.equals(Names.SIDE_BRUSH.toString())) {
            this.sideBrushWorkTime = 0;
        }
        if (name.equals(Names.FILTER.toString())) {
            this.filterWorkTime = 0;
        }
    }

    public int getMainBrushWorkTime() {
        return this.mainBrushWorkTime;
    }

    public int getSensorTimeSinceCleaning() {
        return this.sensorTimeSinceCleaning;
    }

    public int getSideBrushWorkTime() {
        return this.sideBrushWorkTime;
    }

    public int getFilterWorkTime() {
        return this.filterWorkTime;
    }

    public void setMainBrushWorkTime(int mainBrushWorkTime) {
        this.mainBrushWorkTime = mainBrushWorkTime;
    }

    public void setSensorTimeSinceCleaning(int sensorTimeSinceCleaning) {
        this.sensorTimeSinceCleaning = sensorTimeSinceCleaning;
    }

    public void setSideBrushWorkTime(int sideBrushWorkTime) {
        this.sideBrushWorkTime = sideBrushWorkTime;
    }

    public void setFilterWorkTime(int filterWorkTime) {
        this.filterWorkTime = filterWorkTime;
    }

    public int getMainBrushWorkTimeLeft() {
        return 1080000 - this.mainBrushWorkTime;
    }

    public int getSensorTimeSinceCleaningLeft() {
        return 108000 - this.sensorTimeSinceCleaning;
    }

    public int getSideBrushWorkTimeLeft() {
        return 720000 - this.sideBrushWorkTime;
    }

    public int getFilterWorkTimeLeft() {
        return 540000 - this.filterWorkTime;
    }

    public float getMainBrushWorkPercent() {
        return (float)this.mainBrushWorkTime / 1080000.0f * 100.0f;
    }

    public float getSensorPercentSinceCleaning() {
        return (float)this.sensorTimeSinceCleaning / 108000.0f * 100.0f;
    }

    public float getSideBrushWorkPercent() {
        return (float)this.sideBrushWorkTime / 720000.0f * 100.0f;
    }

    public float getFilterWorkPercent() {
        return (float)this.filterWorkTime / 540000.0f * 100.0f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumConsumableStatus that = (VacuumConsumableStatus)o;
        return this.mainBrushWorkTime == that.mainBrushWorkTime && this.sensorTimeSinceCleaning == that.sensorTimeSinceCleaning && this.sideBrushWorkTime == that.sideBrushWorkTime && this.filterWorkTime == that.filterWorkTime;
    }

    public int hashCode() {
        return Objects.hash(this.mainBrushWorkTime, this.sensorTimeSinceCleaning, this.sideBrushWorkTime, this.filterWorkTime);
    }

    public String toString() {
        return "VacuumConsumableStatus{mainBrushWorkTime=" + this.mainBrushWorkTime + ", sensorTimeSinceCleaning=" + this.sensorTimeSinceCleaning + ", sideBrushWorkTime=" + this.sideBrushWorkTime + ", filterWorkTime=" + this.filterWorkTime + '}';
    }

    public static enum Names {
        MAIN_BRUSH("main_brush_work_time"),
        SIDE_BRUSH("side_brush_work_time"),
        FILTER("filter_work_time"),
        SENSOR("sensor_dirty_time");

        private final String name;

        private Names(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

