/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;

public class VacuumSounpackInstallState
implements Serializable {
    private static final long serialVersionUID = -2391464429205045105L;
    private int progress;
    private State state;
    private Error error;
    private int sid;

    public VacuumSounpackInstallState(int progress, State state, Error error, int sid) {
        if (progress < 0) {
            progress = 0;
        }
        if (progress > 100) {
            progress = 100;
        }
        this.progress = progress;
        if (state == null) {
            state = State.UNKNOWN;
        }
        this.state = state;
        if (error == null) {
            error = Error.UNKNOWN;
        }
        this.error = error;
        this.sid = sid;
    }

    public VacuumSounpackInstallState(JSONObject info) {
        if (info == null) {
            this.progress = 0;
            this.state = State.UNKNOWN;
            this.error = Error.UNKNOWN;
            this.sid = -1;
        } else {
            this.progress = info.optInt("progress", 0);
            this.state = State.valueOf(info.optInt("state", State.UNKNOWN.getState()));
            this.error = Error.valueOf(info.optInt("error", Error.UNKNOWN.getCode()));
            this.sid = info.optInt("sid_in_progress", -1);
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (progress < 0) {
            progress = 0;
        }
        if (progress > 100) {
            progress = 100;
        }
        this.progress = progress;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (state == null) {
            state = State.UNKNOWN;
        }
        this.state = state;
    }

    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        if (error == null) {
            error = Error.UNKNOWN;
        }
        this.error = error;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        if (this.error == null) {
            this.error = Error.UNKNOWN;
        }
        this.sid = sid;
    }

    public JSONObject construct(boolean includeSid) {
        JSONObject ret = new JSONObject();
        ret.put("progress", this.progress);
        ret.put("state", this.state.getState());
        ret.put("error", this.error.getCode());
        if (includeSid) {
            ret.put("sid_in_progress", this.sid);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumSounpackInstallState that = (VacuumSounpackInstallState)o;
        return this.progress == that.progress && this.sid == that.sid && this.state == that.state && this.error == that.error;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.progress, this.state, this.error, this.sid});
    }

    public String toString() {
        return "VacuumSounpackInstallState{progress=" + this.progress + ", state=" + this.state.toString() + ", error=" + this.error.toString() + ", sid=" + this.sid + '}';
    }

    public static enum Error {
        NONE(0),
        ERROR_1(1),
        DOWNLOAD(2),
        CHECKSUM(3),
        ERROR_4(4),
        UNKNOWN(5);

        private final int code;
        private static Map<Integer, Error> map;

        private Error(int code) {
            this.code = code;
        }

        public static Error valueOf(int code) {
            Error er = map.get(code);
            if (er == null) {
                return UNKNOWN;
            }
            return er;
        }

        public int getCode() {
            return this.code;
        }

        static {
            map = new HashMap<Integer, Error>();
            for (Error er : Error.values()) {
                map.put(er.code, er);
            }
        }
    }

    public static enum State {
        UNKNOWN(0),
        DOWNLOAD(1),
        INSTALLING(2),
        DONE(3),
        ERROR(4);

        private final int state;
        private static Map<Integer, State> map;

        private State(int state) {
            this.state = state;
        }

        public static State valueOf(int state) {
            State st = map.get(state);
            if (st == null) {
                return UNKNOWN;
            }
            return st;
        }

        public int getState() {
            return this.state;
        }

        static {
            map = new HashMap<Integer, State>();
            for (State st : State.values()) {
                map.put(st.state, st);
            }
        }
    }
}

