/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.server;

import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.base.messages.Command;
import de.sg_o.app.miio.base.messages.Response;
import de.sg_o.app.miio.server.OnServerEventListener;
import de.sg_o.app.miio.util.ByteArray;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.json.JSONObject;

public class Server
extends Thread {
    private List<OnServerEventListener> listener = new ArrayList<OnServerEventListener>();
    private DatagramSocket socket;
    private boolean running;
    private byte[] buf = new byte[65507];
    private Token tk;
    private int deviceId;
    private String model;
    private String firmware;
    private String hardware;
    private JSONObject network;
    private String macAddress;
    private long lifeTime;
    private JSONObject accessPoint;

    public Server(Token tk, int deviceId, String model, String firmware, String hardware, JSONObject network, String macAddress, long lifeTime, JSONObject accessPoint) throws SocketException {
        if (tk == null) {
            Random rd = new Random();
            byte[] invalidTokenBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
            byte[] tokenBytes = new byte[16];
            System.arraycopy(invalidTokenBytes, 0, tokenBytes, 0, 16);
            while (Arrays.equals(tokenBytes, invalidTokenBytes)) {
                rd.nextBytes(tokenBytes);
            }
            tk = new Token(tokenBytes);
        }
        this.tk = tk;
        this.deviceId = deviceId;
        if (model == null) {
            model = "miio.generic";
        }
        this.model = model;
        if (firmware == null) {
            firmware = "0.0.1_000001";
        }
        this.firmware = firmware;
        if (hardware == null) {
            hardware = "Linux";
        }
        this.hardware = hardware;
        if (network == null) {
            network = new JSONObject();
            network.put("gw", (Object)"127.0.0.1");
            network.put("localIp", (Object)"127.0.0.1");
            network.put("mask", (Object)"255.0.0.0");
        }
        this.network = network;
        if (macAddress == null) {
            macAddress = "02:00:00:00:00:01";
        }
        this.macAddress = macAddress;
        this.lifeTime = lifeTime;
        if (accessPoint == null) {
            accessPoint = new JSONObject();
            accessPoint.put("rssi", -10);
            accessPoint.put("bssid", (Object)"02:00:00:00:00:00");
            accessPoint.put("ssid", (Object)"WLAN Router");
        }
        this.accessPoint = accessPoint;
        this.socket = new DatagramSocket(54321);
        this.socket.setSoTimeout(1000);
    }

    public void registerOnServerEventListener(OnServerEventListener listener) {
        this.listener.add(listener);
    }

    public void terminate() {
        this.running = false;
        while (!this.socket.isClosed()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            Response resp;
            DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length);
            try {
                this.socket.receive(packet);
            }
            catch (IOException ignored) {
                continue;
            }
            byte[] worker = new byte[2];
            System.arraycopy(this.buf, 2, worker, 0, 2);
            int length = (int)ByteArray.fromBytes(worker);
            worker = new byte[length];
            System.arraycopy(this.buf, 0, worker, 0, length);
            Command msg = new Command(worker, this.tk);
            InetAddress address = packet.getAddress();
            int port = packet.getPort();
            int timeStamp = (int)(System.currentTimeMillis() / 1000L);
            if (msg.isHello()) {
                resp = new Response(this.tk, this.deviceId, timeStamp);
            } else {
                if (msg.getDeviceID() != this.deviceId) continue;
                Object data = this.executeCommand(msg.getMethod(), msg.getParams());
                if (data == null) {
                    data = "unknown_method";
                }
                resp = new Response(this.tk, this.deviceId, timeStamp, msg.getPayloadID(), data);
            }
            byte[] respMsg = resp.create();
            System.arraycopy(respMsg, 0, this.buf, 0, respMsg.length);
            packet = new DatagramPacket(this.buf, respMsg.length, address, port);
            try {
                this.socket.send(packet);
            }
            catch (IOException iOException) {}
        }
        this.socket.close();
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public Token getTk() {
        return this.tk;
    }

    public String getModel() {
        return this.model;
    }

    public String getFirmware() {
        return this.firmware;
    }

    public String getHardware() {
        return this.hardware;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public JSONObject getNetwork() {
        return this.network;
    }

    public void setNetwork(JSONObject network) {
        if (network == null) {
            return;
        }
        this.network = network;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public JSONObject getAccessPoint() {
        return this.accessPoint;
    }

    public void setAccessPoint(JSONObject accessPoint) {
        if (accessPoint == null) {
            return;
        }
        this.accessPoint = accessPoint;
    }

    private Object executeCommand(String method, Object params) {
        if (method == null) {
            return null;
        }
        switch (method) {
            case "miIO.info": {
                return this.generateInfo();
            }
        }
        if (!this.listener.isEmpty()) {
            OnServerEventListener lis;
            Object ret = null;
            Iterator<OnServerEventListener> iterator = this.listener.iterator();
            while (iterator.hasNext() && (ret = (lis = iterator.next()).onCommandListener(method, params)) == null) {
            }
            return ret;
        }
        return null;
    }

    private JSONObject generateInfo() {
        JSONObject obj = new JSONObject();
        obj.put("hw_ver", (Object)this.hardware);
        obj.put("netif", (Object)this.network);
        obj.put("model", (Object)this.model);
        obj.put("fw_ver", (Object)this.firmware);
        obj.put("mac", (Object)this.macAddress);
        obj.put("life", this.lifeTime);
        obj.put("ap", (Object)this.accessPoint);
        obj.put("token", (Object)this.tk.toString());
        return obj;
    }
}

