/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;

public class VacuumStatus
implements Serializable {
    private static final long serialVersionUID = 7121689240387054887L;
    private boolean dndEnabled = false;
    private boolean mapPresent = false;
    private int cleanArea = 0;
    private int fanPower = 60;
    private int msgVersion = 8;
    private boolean inCleaning = false;
    private Error errorCode = Error.UNKNOWN;
    private State state = State.UNKNOWN;
    private int battery = 100;
    private int msgSeq = 0;
    private int cleanTime = 0;

    public VacuumStatus(boolean dndEnabled, boolean mapPresent, int cleanArea, int fanPower, int msgVersion, boolean inCleaning, Error errorCode, State state, int battery, int msgSeq, int cleanTime) {
        this.dndEnabled = dndEnabled;
        this.mapPresent = mapPresent;
        this.cleanArea = cleanArea;
        this.fanPower = fanPower;
        this.msgVersion = msgVersion;
        this.inCleaning = inCleaning;
        this.errorCode = errorCode;
        this.state = state;
        this.battery = battery;
        this.msgSeq = msgSeq;
        this.cleanTime = cleanTime;
    }

    public VacuumStatus(JSONObject status) {
        if (status != null) {
            this.dndEnabled = status.optInt("dnd_enabled") == 1;
            this.mapPresent = status.optInt("map_present") == 1;
            this.cleanArea = status.optInt("clean_area");
            this.fanPower = status.optInt("fan_power");
            this.msgVersion = status.optInt("msg_ver");
            this.inCleaning = status.optInt("in_cleaning") == 1;
            this.errorCode = Error.valueOf(status.optInt("error_code"));
            this.state = State.valueOf(status.optInt("state"));
            this.battery = status.optInt("battery");
            this.msgSeq = status.optInt("msg_seq");
            this.cleanTime = status.optInt("clean_time");
        }
    }

    public JSONObject construct() {
        JSONObject payload = new JSONObject();
        payload.put("dnd_enabled", this.dndEnabled ? 1 : 0);
        payload.put("map_present", this.mapPresent ? 1 : 0);
        payload.put("clean_area", this.cleanArea);
        payload.put("fan_power", this.fanPower);
        payload.put("msg_ver", this.msgVersion);
        payload.put("in_cleaning", this.inCleaning ? 1 : 0);
        payload.put("error_code", this.errorCode.getCode());
        payload.put("state", this.state.getState());
        payload.put("battery", this.battery);
        payload.put("msg_seq", this.msgSeq);
        payload.put("clean_time", this.cleanTime);
        return payload;
    }

    public boolean isDndEnabled() {
        return this.dndEnabled;
    }

    public void setDndEnabled(boolean dndEnabled) {
        this.dndEnabled = dndEnabled;
    }

    public boolean isMapPresent() {
        return this.mapPresent;
    }

    public void setMapPresent(boolean mapPresent) {
        this.mapPresent = mapPresent;
    }

    public int getCleanArea() {
        return this.cleanArea;
    }

    public void setCleanArea(int cleanArea) {
        this.cleanArea = cleanArea;
    }

    public int getFanPower() {
        return this.fanPower;
    }

    public void setFanPower(int fanPower) {
        this.fanPower = fanPower;
    }

    public int getMsgVersion() {
        return this.msgVersion;
    }

    public void setMsgVersion(int msgVersion) {
        this.msgVersion = msgVersion;
    }

    public boolean isInCleaning() {
        return this.inCleaning;
    }

    public void setInCleaning(boolean inCleaning) {
        this.inCleaning = inCleaning;
    }

    public Error getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Error errorCode) {
        this.errorCode = errorCode;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public int getBattery() {
        return this.battery;
    }

    public void setBattery(int battery) {
        this.battery = battery;
    }

    public int getMsgSeq() {
        return this.msgSeq;
    }

    public void setMsgSeq(int msgSeq) {
        this.msgSeq = msgSeq;
    }

    public int getCleanTime() {
        return this.cleanTime;
    }

    public void setCleanTime(int cleanTime) {
        this.cleanTime = cleanTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumStatus that = (VacuumStatus)o;
        return this.dndEnabled == that.dndEnabled && this.mapPresent == that.mapPresent && this.cleanArea == that.cleanArea && this.fanPower == that.fanPower && this.msgVersion == that.msgVersion && this.inCleaning == that.inCleaning && this.battery == that.battery && this.msgSeq == that.msgSeq && this.cleanTime == that.cleanTime && this.errorCode == that.errorCode && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dndEnabled, this.mapPresent, this.cleanArea, this.fanPower, this.msgVersion, this.inCleaning, this.errorCode, this.state, this.battery, this.msgSeq, this.cleanTime});
    }

    public String toString() {
        return "VacuumStatus{dndEnabled=" + this.dndEnabled + ", mapPresent=" + this.mapPresent + ", cleanArea=" + this.cleanArea + ", fanPower=" + this.fanPower + ", msgVersion=" + this.msgVersion + ", inCleaning=" + this.inCleaning + ", errorCode=" + this.errorCode.toString() + ", state=" + this.state.toString() + ", battery=" + this.battery + ", msgSeq=" + this.msgSeq + ", cleanTime=" + this.cleanTime + '}';
    }

    public static enum Error {
        NONE(0),
        LDS(1),
        COLLISION_SENSOR(2),
        MOVE_DEVICE(3),
        CLEAN_CLIFF_SENSOR(4),
        CLEAN_MAIN_BRUSH(5),
        CLEAN_SIDE_BRUSH(6),
        WHEELS(7),
        REMOVE_OBSTACLES(8),
        REPLACE_DUSTBIN(9),
        CLEAN_FILTER(10),
        MAGNETIC_FIELD(11),
        BATTERY_LOW(12),
        CHARGING_FAULT(13),
        BATTERY_FAULT(14),
        WALL_SENSOR(15),
        UNEVEN_SURFACE(16),
        SIDE_BRUSH_SYSTEM_RESET(17),
        FAN_SYSTEM_REBOOT(18),
        BASE_POWERED(19),
        UNKNOWN(20);

        private final int code;
        private static Map<Integer, Error> map;

        private Error(int code) {
            this.code = code;
        }

        public static Error valueOf(int code) {
            Error er = map.get(code);
            if (er == null) {
                return UNKNOWN;
            }
            return er;
        }

        public int getCode() {
            return this.code;
        }

        static {
            map = new HashMap<Integer, Error>();
            for (Error er : Error.values()) {
                map.put(er.code, er);
            }
        }
    }

    public static enum State {
        UNKNOWN(0),
        STARTUP(1),
        CHARGER_CONNECTION_LOST(2),
        IDLE(3),
        REMOTE_CONTROL(4),
        CLEANING(5),
        GOING_HOME(6),
        MANUAL(7),
        CHARGING(8),
        CHARGING_ERROR(9),
        PAUSED(10),
        SPOT_CLEANUP(11),
        ERROR(12),
        SHUTDOWN(13),
        UPDATING(14),
        DOCKING(15),
        GOING_TO_TARGET(16),
        CLEANING_ZONE(17);

        private final int state;
        private static Map<Integer, State> map;

        private State(int state) {
            this.state = state;
        }

        public static State valueOf(int state) {
            State st = map.get(state);
            if (st == null) {
                return UNKNOWN;
            }
            return st;
        }

        public int getState() {
            return this.state;
        }

        static {
            map = new HashMap<Integer, State>();
            for (State st : State.values()) {
                map.put(st.state, st);
            }
        }
    }
}

