/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import java.io.Serializable;
import java.util.Objects;
import org.joda.time.Instant;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;

public class VacuumCleanup
implements Serializable {
    private static final long serialVersionUID = -4764098548055264774L;
    private Instant start;
    private Instant end;
    private long runtime;
    private long area;
    private boolean completed;

    public VacuumCleanup(Instant start, Instant end, long runtime, long area, boolean completed) {
        if (start == null || end == null || runtime < 0L) {
            start = Instant.now();
            end = start.plus(1000L);
            runtime = 1L;
        }
        this.start = start;
        this.end = end;
        this.runtime = runtime;
        if (area < 0L) {
            area = 0L;
        }
        this.area = area;
        this.completed = completed;
    }

    public VacuumCleanup(JSONArray msg) {
        if (msg == null) {
            this.start = Instant.now();
            this.end = this.start.plus(1000L);
            this.runtime = 1L;
        } else {
            this.start = Instant.ofEpochSecond((long)msg.optLong(0, Instant.now().getMillis()));
            this.end = Instant.ofEpochSecond((long)msg.optLong(1, this.start.plus(1000L).getMillis()));
            this.runtime = msg.optLong(2, 1L);
            this.area = msg.optLong(3);
            this.completed = msg.optInt(5) == 1;
        }
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public long getArea() {
        return this.area;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public JSONArray construct() {
        JSONArray ret = new JSONArray();
        ret.put(this.start.getMillis() / 1000L);
        ret.put(this.end.getMillis() / 1000L);
        ret.put(this.runtime);
        ret.put(this.area);
        ret.put(0);
        ret.put(this.completed ? 1 : 0);
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumCleanup that = (VacuumCleanup)o;
        return this.runtime == that.runtime && this.area == that.area && this.completed == that.completed && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.runtime, this.area, this.completed);
    }

    public String toString() {
        return "VacuumCleanup{start=" + this.start.toString(ISODateTimeFormat.dateTimeNoMillis()) + ", end=" + this.end.toString(ISODateTimeFormat.dateTimeNoMillis()) + ", runtime=" + this.runtime + ", area=" + this.area + ", completed=" + this.completed + '}';
    }
}

