/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.vacuum;

import de.sg_o.app.miio.base.CommandExecutionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joda.time.LocalTime;
import org.json.JSONArray;

public class VacuumTimer
implements Serializable {
    private static final long serialVersionUID = 4679120578276423163L;
    private String ID;
    private boolean enabled;
    private LocalTime time;
    private HashSet<DayOfWeek> runDays;
    private transient JSONArray job;

    public VacuumTimer(String ID, boolean enabled, LocalTime time, HashSet<DayOfWeek> runDays, JSONArray job) {
        if (ID == null) {
            ID = Long.valueOf(System.currentTimeMillis()).toString();
        }
        this.ID = ID;
        this.enabled = enabled;
        this.time = time;
        if (runDays == null) {
            runDays = new HashSet();
        }
        this.runDays = runDays;
        this.job = job;
    }

    public VacuumTimer(String ID, boolean enabled, int hour, int minute, HashSet<DayOfWeek> runDays) {
        if (ID == null) {
            ID = Long.valueOf(System.currentTimeMillis()).toString();
        }
        this.ID = ID;
        this.enabled = enabled;
        if (hour > 23) {
            hour = 23;
        }
        if (hour < 0) {
            hour = 0;
        }
        if (minute > 59) {
            minute = 59;
        }
        if (minute < 0) {
            minute = 0;
        }
        this.time = new LocalTime(hour, minute);
        if (runDays == null) {
            runDays = new HashSet();
        }
        this.runDays = runDays;
    }

    public VacuumTimer(JSONArray timer) throws CommandExecutionException {
        String cron;
        JSONArray jobArray;
        if (timer == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        int length = timer.length();
        this.runDays = new HashSet();
        this.ID = timer.optString(0, Long.valueOf(System.currentTimeMillis()).toString());
        if (length > 2) {
            this.enabled = timer.optString(1).equals("on");
            jobArray = timer.optJSONArray(2);
        } else {
            this.enabled = true;
            jobArray = timer.optJSONArray(1);
        }
        if (jobArray != null) {
            cron = jobArray.optString(0, null);
            if (cron == null) {
                throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
            }
        } else {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        this.parseCron(cron);
        this.job = jobArray.optJSONArray(1);
    }

    private void parseCron(String cron) throws CommandExecutionException {
        if (cron == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        String[] values = cron.split("\\s+");
        if (values.length != 5) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        try {
            int minute = Integer.valueOf(values[0]);
            int hour = Integer.valueOf(values[1]);
            this.time = new LocalTime(hour, minute);
        }
        catch (NumberFormatException ignore) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        String[] dayValues = values[4].split(",");
        if (dayValues.length > 0 && !dayValues[0].equals("*")) {
            try {
                for (String day : dayValues) {
                    int d = Integer.valueOf(day);
                    if (d > 6) continue;
                    this.runDays.add(DayOfWeek.valueOf(d));
                }
            }
            catch (NumberFormatException ignore) {
                throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
            }
        }
    }

    private String generateCron() {
        if (this.time == null) {
            return null;
        }
        StringBuilder days = new StringBuilder();
        if (this.runDays.size() > 0) {
            for (DayOfWeek d : this.runDays) {
                int dValue = d.getValue();
                days.append(dValue);
                days.append(",");
            }
            days.delete(days.length() - 1, days.length());
        } else {
            days.append("*");
        }
        return this.time.getMinuteOfHour() + " " + this.time.getHourOfDay() + " * * " + days.toString();
    }

    public JSONArray construct() {
        return this.construct(false);
    }

    public JSONArray construct(boolean server) {
        JSONArray jobArray = new JSONArray();
        String cron = this.generateCron();
        if (cron == null) {
            return null;
        }
        jobArray.put((Object)cron);
        if (server) {
            if (this.job == null) {
                return null;
            }
            jobArray.put((Object)this.job);
        } else {
            JSONArray empty = new JSONArray();
            empty.put((Object)"");
            empty.put((Object)"");
            jobArray.put((Object)empty);
        }
        JSONArray timer = new JSONArray();
        timer.put((Object)this.ID);
        if (server) {
            timer.put((Object)this.getOnOff());
        }
        timer.put((Object)jobArray);
        return timer;
    }

    public String getID() {
        return this.ID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getOnOff() {
        return this.enabled ? "on" : "off";
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public Set<DayOfWeek> getRunDays() {
        return this.runDays;
    }

    public JSONArray getJob() {
        return this.job;
    }

    public void setJob(JSONArray job) {
        this.job = job;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumTimer that = (VacuumTimer)o;
        for (DayOfWeek d : this.runDays) {
            if (that.runDays.contains((Object)d)) continue;
            return false;
        }
        return this.enabled == that.enabled && Objects.equals(this.ID, that.ID);
    }

    public int hashCode() {
        return Objects.hash(this.ID, this.enabled);
    }

    public String toString() {
        return "VacuumTimer{ID='" + this.ID + '\'' + ", enabled=" + this.enabled + ", time=" + this.time.toString("HH:mm") + ", runDays=" + this.runDays + ", job=" + this.job + '}';
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.job.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.job = new JSONArray((String)in.readObject());
    }

    public static enum DayOfWeek {
        SUNDAY(0),
        MONDAY(1),
        TUESDAY(2),
        WEDNESDAY(3),
        THURSDAY(4),
        FRIDAY(5),
        SATURDAY(6);

        private final int value;
        private static Map<Integer, DayOfWeek> map;

        private DayOfWeek(int value) {
            this.value = value;
        }

        public static DayOfWeek valueOf(int number) {
            DayOfWeek st = map.get(number);
            if (st == null) {
                return MONDAY;
            }
            return st;
        }

        public int getValue() {
            return this.value;
        }

        static {
            map = new HashMap<Integer, DayOfWeek>();
            for (DayOfWeek st : DayOfWeek.values()) {
                map.put(st.value, st);
            }
        }
    }
}

