/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.yeelight;

import de.sg_o.app.miio.base.CommandExecutionException;
import de.sg_o.app.miio.base.Device;
import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.yeelight.Prop;
import java.net.InetAddress;
import java.util.Map;
import org.json.JSONArray;

public abstract class Light
extends Device {
    public Light(InetAddress ip, Token token, String[] acceptableModels, int timeout, int retries) {
        super(ip, token, acceptableModels, timeout, retries);
    }

    public Map<Prop.Names, String> getProps(Prop.Names[] props) throws CommandExecutionException {
        Prop prop = new Prop(props);
        return prop.parseResponse(this.sendToArray("get_prop", prop.getRequestArray()));
    }

    public String getSingleProp(Prop.Names prop) throws CommandExecutionException {
        Map<Prop.Names, String> value = this.getProps(new Prop.Names[]{prop});
        String valueString = value.get((Object)prop);
        if (valueString == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        return valueString;
    }

    public int getIntProp(Prop.Names prop) throws CommandExecutionException {
        String value = this.getSingleProp(prop);
        if (value.equals("")) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
    }

    public int getDeviceMode() throws CommandExecutionException {
        return this.getIntProp(Prop.Names.COLOR_MODE);
    }

    public boolean setColorTemperature(int temperature, boolean smoothChange, int duration) throws CommandExecutionException {
        if (temperature < 1700) {
            temperature = 1700;
        }
        if (temperature > 6500) {
            temperature = 6500;
        }
        if (duration < 30) {
            duration = 30;
        }
        JSONArray col = new JSONArray();
        col.put(temperature);
        col.put((Object)(smoothChange ? "smooth" : "sudden"));
        col.put(duration);
        return this.sendOk("set_ct_abx", col);
    }

    public int getColorTemperature() throws CommandExecutionException {
        return this.getIntProp(Prop.Names.COLOR_TEMPERATURE);
    }

    public boolean setRGB(int c, boolean smoothChange, int duration) throws CommandExecutionException {
        int colorInt;
        if (duration < 30) {
            duration = 30;
        }
        if ((colorInt = c & 0xFFFFFF) < 1) {
            colorInt = 65793;
        }
        JSONArray col = new JSONArray();
        col.put(colorInt);
        col.put((Object)(smoothChange ? "smooth" : "sudden"));
        col.put(duration);
        return this.sendOk("set_rgb", col);
    }

    public int getRGB() throws CommandExecutionException {
        return this.getIntProp(Prop.Names.RGB_COLOR);
    }

    public boolean setHSV(int hue, int saturation, boolean smoothChange, int duration) throws CommandExecutionException {
        if (hue < 0) {
            hue = 0;
        }
        if (hue > 359) {
            hue = 359;
        }
        if (saturation < 0) {
            saturation = 0;
        }
        if (saturation > 100) {
            saturation = 100;
        }
        if (duration < 30) {
            duration = 30;
        }
        JSONArray col = new JSONArray();
        col.put(hue);
        col.put(saturation);
        col.put((Object)(smoothChange ? "smooth" : "sudden"));
        col.put(duration);
        return this.sendOk("set_hsv", col);
    }

    public int getHue() throws CommandExecutionException {
        return this.getIntProp(Prop.Names.HUE);
    }

    public int getSaturation() throws CommandExecutionException {
        return this.getIntProp(Prop.Names.SATURATION);
    }

    public boolean setBrightness(int brightness, boolean smoothChange, int duration) throws CommandExecutionException {
        if (brightness < 1) {
            brightness = 1;
        }
        if (brightness > 100) {
            brightness = 100;
        }
        if (duration < 30) {
            duration = 30;
        }
        JSONArray col = new JSONArray();
        col.put(brightness);
        col.put((Object)(smoothChange ? "smooth" : "sudden"));
        col.put(duration);
        return this.sendOk("set_bright", col);
    }

    public int getBrightness() throws CommandExecutionException {
        return this.getIntProp(Prop.Names.BRIGHTNESS);
    }

    public boolean setPower(boolean on, boolean smoothChange, int duration) throws CommandExecutionException {
        JSONArray col = new JSONArray();
        col.put((Object)(on ? "on" : "off"));
        col.put((Object)(smoothChange ? "smooth" : "sudden"));
        col.put(duration);
        return this.sendOk("set_power", col);
    }

    public boolean togglePower() throws CommandExecutionException {
        return this.sendOk("toggle", new JSONArray());
    }

    public boolean isOn() throws CommandExecutionException {
        return this.getSingleProp(Prop.Names.POWER).equals("on");
    }

    public boolean setAsDefault() throws CommandExecutionException {
        return this.sendOk("set_default", new JSONArray());
    }

    public boolean powerOffAfterTime(int minutes) throws CommandExecutionException {
        JSONArray col = new JSONArray();
        col.put(0);
        col.put(minutes);
        return this.sendOk("cron_add", col);
    }

    public boolean stopPowerOffAfterTime() throws CommandExecutionException {
        JSONArray col = new JSONArray();
        col.put(0);
        return this.sendOk("cron_del", col);
    }

    public int getTimeUntilPowerOff() throws CommandExecutionException {
        return this.getIntProp(Prop.Names.SLEEP_TIME_LEFT);
    }

    public boolean setName(String name) throws CommandExecutionException {
        if (name == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray col = new JSONArray();
        col.put((Object)name);
        return this.sendOk("set_name", col);
    }

    public String getName() throws CommandExecutionException {
        return this.getSingleProp(Prop.Names.DEVICE_NAME);
    }
}

