/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miio.yeelight;

import de.sg_o.app.miio.base.CommandExecutionException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;

public class Prop {
    private Names[] props;

    public Prop(Names[] props) {
        if (props == null) {
            props = new Names[]{};
        }
        this.props = props;
    }

    public Names[] getProps() {
        return this.props;
    }

    public JSONArray getRequestArray() throws CommandExecutionException {
        if (this.props.length < 1) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_PARAMETERS);
        }
        JSONArray ret = new JSONArray();
        for (Names p : this.props) {
            ret.put((Object)p.toString());
        }
        return ret;
    }

    public Map<Names, String> parseResponse(JSONArray response) throws CommandExecutionException {
        if (response == null) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        if (response.length() != this.props.length) {
            throw new CommandExecutionException(CommandExecutionException.Error.INVALID_RESPONSE);
        }
        HashMap<Names, String> ret = new HashMap<Names, String>(this.props.length);
        for (int i = 0; i < this.props.length; ++i) {
            ret.put(this.props[i], response.optString(i, ""));
        }
        return ret;
    }

    public static enum Names {
        POWER("power"),
        BRIGHTNESS("bright"),
        COLOR_TEMPERATURE("ct"),
        RGB_COLOR("rgb"),
        HUE("hue"),
        SATURATION("sat"),
        COLOR_MODE("color_mode"),
        COLOR_FLOW_ENABLED("flowing"),
        SLEEP_TIME_LEFT("delayoff"),
        FLOW_PARAMETERS("flow_params"),
        MUSIC_MODE_ENABLED("music_on"),
        DEVICE_NAME("name"),
        BACKGROUND_LIGHT_POWER("bg_power"),
        BACKGROUND_LIGHT_FLOWING("bg_flowing"),
        BACKGROUND_LIGHT_FLOW_PARAMETERS("bg_flow_params"),
        BACKGROUND_LIGHT_COLOR_TEMPERATURE("bg_ct"),
        BACKGROUND_LIGHT_COLOR_MODE("bg_lmode"),
        BACKGROUND_LIGHT_BRIGHTNESS("bg_bright"),
        BACKGROUND_LIGHT_RGB_COLOR("bg_rgb"),
        BACKGROUND_LIGHT_HUE("bg_hue"),
        BACKGROUND_LIGHT_SATURATION("bg_sat"),
        NIGHT_MODE_BRIGHTNESS("nl_br");

        private final String name;

        private Names(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

