/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miioMapServer;

import de.sg_o.app.miioMapServer.ServerThread;
import de.sg_o.proto.MapErrorProto;
import de.sg_o.proto.MapPackageColorProto;
import de.sg_o.proto.MapPackageProto;
import de.sg_o.proto.MapSlamProto;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;

public class VacuumMap
implements Serializable {
    private static final long serialVersionUID = 6328146796574327681L;
    private static final Logger LOGGER = Logger.getLogger(ServerThread.class.getName());
    private transient BufferedImage map;
    private transient List<Point2D.Float> path = new LinkedList<Point2D.Float>();
    private Rectangle boundingBox;
    private int overSample;
    private int numberOfSlamLines = 0;
    private boolean slamLocked = true;

    public VacuumMap(BufferedReader image, BufferedReader slam, int overSample, Level logLevel) {
        if (logLevel != null) {
            LOGGER.setLevel(logLevel);
        } else {
            LOGGER.setLevel(Level.OFF);
        }
        if (overSample < 1) {
            overSample = 1;
        }
        this.overSample = overSample;
        LOGGER.fine("Creating empty image");
        this.map = new BufferedImage(1024, 1024, 5);
        LOGGER.fine("Creating maximum bounding box");
        this.boundingBox = new Rectangle(1024, 1024);
        try {
            LOGGER.info("Reading image");
            this.readMap(image);
            LOGGER.info("Reading slam");
            this.readSlam(slam);
        }
        catch (Exception e) {
            LOGGER.warning("Reading failed: " + e);
        }
    }

    public VacuumMap(MapPackageProto.MapPackage image, MapSlamProto.MapSlam slam, int overSample) {
        if (overSample < 1) {
            overSample = 1;
        }
        this.overSample = overSample;
        this.map = new BufferedImage(1024, 1024, 5);
        this.boundingBox = new Rectangle(1024, 1024);
        this.decodeMapPackage(image);
        this.decodeMapSlam(slam);
    }

    private void readMap(BufferedReader image) throws IOException {
        LOGGER.fine("Initializing bounding box creation");
        int x = 0;
        int y = 0;
        int top = this.map.getHeight();
        int bottom = 0;
        int left = this.map.getWidth();
        int right = 0;
        if (image.readLine() == null) {
            LOGGER.warning("File format invalid");
            return;
        }
        if (image.readLine() == null) {
            LOGGER.warning("File format invalid");
            return;
        }
        while (true) {
            LOGGER.fine("Reading pixel: " + x + "," + y);
            int[] rgb = new int[]{image.read(), image.read(), image.read()};
            if (rgb[0] < 0 || rgb[1] < 0 || rgb[2] < 0) {
                LOGGER.info("End of map file reached");
                this.boundingBox = new Rectangle(left, top, right - left + 1, bottom - top + 1);
                return;
            }
            for (int i = 0; i < rgb.length; ++i) {
                rgb[i] = rgb[i] & 0xFF;
            }
            LOGGER.fine("Setting pixel");
            this.map.setRGB(x, y, new Color(rgb[0], rgb[1], rgb[2]).getRGB());
            if (rgb[0] != 125 || rgb[1] != 125 || rgb[2] != 125) {
                LOGGER.fine("Updating bounding box");
                if (x < left) {
                    left = x;
                }
                if (x > right) {
                    right = x;
                }
                if (y < top) {
                    top = y;
                }
                if (y > bottom) {
                    bottom = y;
                }
            }
            if (++x >= this.map.getWidth()) {
                x = 0;
                ++y;
            }
            if (y < this.map.getHeight()) continue;
            LOGGER.info("Restarting at the start of the image");
            y = 0;
        }
    }

    private void readSlam(BufferedReader slam) throws IOException {
        String line;
        while ((line = slam.readLine()) != null) {
            LOGGER.fine("Parsing line: " + line);
            ++this.numberOfSlamLines;
            if (line.contains("reset")) {
                LOGGER.fine("Reset");
                this.path = new LinkedList<Point2D.Float>();
            }
            if (line.contains("lock")) {
                LOGGER.fine("Lock");
                this.slamLocked = true;
            }
            if (line.contains("unlock")) {
                LOGGER.fine("Unlock");
                this.slamLocked = false;
            }
            if (this.slamLocked || !line.contains("estimate")) continue;
            LOGGER.fine("Parsing estimate");
            String[] split = line.split("\\s+");
            if (split.length != 5) {
                LOGGER.info("Estimate of wrong length");
                continue;
            }
            try {
                LOGGER.fine("Parsing coordinates");
                float x = Float.valueOf(split[2]).floatValue() * 20.0f;
                float y = Float.valueOf(split[3]).floatValue() * -20.0f;
                this.path.add(new Point2D.Float(x, y));
            }
            catch (Exception e) {
                LOGGER.warning("Parsing coordinates failed: " + e);
            }
        }
    }

    public void appendSlam(BufferedReader slam) {
        try {
            for (int i = 0; i < this.numberOfSlamLines; ++i) {
                if (slam.readLine() != null) continue;
                return;
            }
            this.readSlam(slam);
        }
        catch (Exception e) {
            LOGGER.warning("Parsing slam failed: " + e);
        }
    }

    public synchronized BufferedImage getMap() {
        BufferedImage outMap = new BufferedImage(1024 * this.overSample, 1024 * this.overSample, 5);
        AffineTransform at = new AffineTransform();
        at.scale(this.overSample, this.overSample);
        AffineTransformOp op = new AffineTransformOp(at, 1);
        op.filter(this.map, outMap);
        return outMap;
    }

    public synchronized List<Point2D.Float> getPath() {
        LinkedList<Point2D.Float> outPath = new LinkedList<Point2D.Float>();
        for (Point2D.Float p : this.path) {
            outPath.add(new Point2D.Float((p.x + (float)this.map.getWidth() / 2.0f) * (float)this.overSample, (p.y + (float)this.map.getHeight() / 2.0f) * (float)this.overSample));
        }
        return outPath;
    }

    public synchronized int getPathSize() {
        return this.path.size();
    }

    public synchronized Rectangle getBoundingBox() {
        Rectangle tmp = new Rectangle();
        tmp.x = this.boundingBox.x * this.overSample;
        tmp.y = this.boundingBox.y * this.overSample;
        tmp.width = this.boundingBox.width * this.overSample;
        tmp.height = this.boundingBox.height * this.overSample;
        return tmp;
    }

    public synchronized int getOverSample() {
        return this.overSample;
    }

    public synchronized void setOverSample(int overSample) {
        if (overSample < 1) {
            overSample = 1;
        }
        this.overSample = overSample;
    }

    public synchronized int[] mapPointScale(Point p) {
        if (p == null) {
            p = new Point(0, 0);
        }
        int[] scaled = new int[]{p.x / this.overSample, p.y / this.overSample};
        return scaled;
    }

    public synchronized int[] mapRectangleScale(Rectangle rec) {
        if (rec == null) {
            rec = new Rectangle(0, 0, 0, 0);
        }
        int[] scaled = new int[]{rec.x / this.overSample, rec.y / this.overSample, rec.x / this.overSample + rec.width / this.overSample, rec.y / this.overSample + rec.height / this.overSample};
        return scaled;
    }

    public BufferedImage getMapWithPathInBounds() {
        return this.getMapWithPathInBounds(null, null);
    }

    public BufferedImage getMapWithPathInBounds(Color startColor, Color pathColor) {
        BufferedImage raw = this.getMapWithPath(startColor, pathColor);
        Rectangle tmp = this.getBoundingBox();
        return raw.getSubimage(tmp.x, tmp.y, tmp.width, tmp.height);
    }

    public BufferedImage getMapWithPath() {
        return this.getMapWithPath(null, null);
    }

    public synchronized BufferedImage getMapWithPath(Color startColor, Color pathColor) {
        if (startColor == null) {
            startColor = Color.GREEN;
        }
        if (pathColor == null) {
            pathColor = Color.BLUE;
        }
        BufferedImage pathMap = new BufferedImage(1024 * this.overSample, 1024 * this.overSample, 5);
        Graphics2D img = pathMap.createGraphics();
        AffineTransform at = new AffineTransform();
        at.scale(this.overSample, this.overSample);
        AffineTransformOp op = new AffineTransformOp(at, 1);
        img.drawImage(this.map, op, 0, 0);
        img.setBackground(startColor);
        img.setColor(startColor);
        int[] home = new int[]{pathMap.getWidth() / 2 - 3 * this.overSample, pathMap.getHeight() / 2 - 3 * this.overSample};
        img.fillOval(home[0], home[1], 6 * this.overSample, 6 * this.overSample);
        img.setColor(pathColor);
        BasicStroke bs = new BasicStroke(1.0f);
        img.setStroke(bs);
        Point2D.Float prev = null;
        for (Point2D.Float p : this.getPath()) {
            if (prev == null) {
                prev = p;
                continue;
            }
            img.drawLine((int)prev.x, (int)prev.y, (int)p.x, (int)p.y);
            prev = p;
        }
        return pathMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        boolean ret;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumMap vacuumMap = (VacuumMap)o;
        if (this.map.getWidth() != vacuumMap.map.getWidth() || this.map.getHeight() != vacuumMap.map.getHeight()) {
            return false;
        }
        int w = this.map.getWidth();
        int h = this.map.getHeight();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (this.map.getRGB(i, j) == vacuumMap.map.getRGB(i, j)) continue;
                return false;
            }
        }
        VacuumMap vacuumMap2 = this;
        synchronized (vacuumMap2) {
            ret = this.overSample == vacuumMap.overSample && Objects.equals(this.path, vacuumMap.path) && Objects.equals(this.boundingBox, vacuumMap.boundingBox);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int ret;
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            ret = Objects.hash(this.map.getHeight(), this.map.getWidth(), this.path, this.boundingBox, this.overSample);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String ret;
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            ret = "de.sg_o.app.miioMapServer.VacuumMap{map=width:" + this.map.getWidth() * this.overSample + "; height:" + this.map.getHeight() * this.overSample + ", pathEntries=" + this.path.size() + ", boundingBox=" + this.getBoundingBox() + ", overSample=" + this.overSample + '}';
        }
        return ret;
    }

    public synchronized MapPackageProto.MapPackage getMapPackage() {
        LOGGER.info("Getting the map within bounds");
        BufferedImage mapInBounds = this.map.getSubimage(this.boundingBox.x, this.boundingBox.y, this.boundingBox.width, this.boundingBox.height);
        HashMap<Integer, MapPackageColorProto.MapPackageColor.Builder> colorMap = new HashMap<Integer, MapPackageColorProto.MapPackageColor.Builder>();
        LOGGER.info("Creating all colors");
        for (int j = 0; j < mapInBounds.getHeight(); ++j) {
            for (int i = 0; i < mapInBounds.getWidth(); ++i) {
                LOGGER.fine("Getting color for pixel: " + i + "," + j);
                int color = mapInBounds.getRGB(i, j);
                LOGGER.fine("Checking whether the color is already in the colorMap");
                MapPackageColorProto.MapPackageColor.Builder builder = (MapPackageColorProto.MapPackageColor.Builder)colorMap.get(color);
                if (builder == null) {
                    LOGGER.fine("Adding new color: " + color);
                    MapPackageColorProto.MapPackageColor.Builder nBuilder = MapPackageColorProto.MapPackageColor.newBuilder();
                    nBuilder.setColor(color);
                    int comp = (j << 16) + i;
                    nBuilder.addCoordinates(comp);
                    colorMap.put(color, nBuilder);
                    continue;
                }
                LOGGER.fine("Adding to existing color");
                int comp = (j << 16) + i;
                builder.addCoordinates(comp);
            }
        }
        MapPackageProto.MapPackage.Builder pack = MapPackageProto.MapPackage.newBuilder();
        pack.setError(MapErrorProto.MapError.newBuilder().setCode(MapErrorProto.MapError.ErrorCode.NONE).build());
        LOGGER.info("Adding bounding box to output");
        pack.setActiveX(this.boundingBox.x);
        pack.setActiveY(this.boundingBox.y);
        pack.setActiveW(this.boundingBox.width);
        pack.setActiveH(this.boundingBox.height);
        LOGGER.info("Adding all colors to output");
        for (MapPackageColorProto.MapPackageColor.Builder b : colorMap.values()) {
            MapPackageColorProto.MapPackageColor col = b.build();
            LOGGER.fine("Adding color: " + col.toString());
            pack.addData(col);
        }
        LOGGER.info("Building output");
        return pack.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeMapPackage(MapPackageProto.MapPackage image) {
        if (image == null) {
            return;
        }
        this.boundingBox.x = image.getActiveX();
        this.boundingBox.y = image.getActiveY();
        this.boundingBox.width = image.getActiveW();
        this.boundingBox.height = image.getActiveH();
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            Graphics2D gr = this.map.createGraphics();
            gr.setColor(new Color(125, 125, 125));
            gr.fillRect(0, 0, this.map.getWidth(), this.map.getHeight());
            for (MapPackageColorProto.MapPackageColor c : image.getDataList()) {
                int color = c.getColor();
                for (int pos : c.getCoordinatesList()) {
                    this.map.setRGB(this.boundingBox.x + (pos & 0xFF), this.boundingBox.y + (pos >> 16 & 0xFF), color);
                }
            }
        }
    }

    public MapSlamProto.MapSlam getMapPath() {
        return this.getMapPath(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapSlamProto.MapSlam getMapPath(int start) {
        LOGGER.info("Getting path from " + start);
        MapErrorProto.MapError.Builder err = MapErrorProto.MapError.newBuilder();
        MapSlamProto.MapSlam.Builder slam = MapSlamProto.MapSlam.newBuilder();
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            if (start >= this.path.size() || start < 0) {
                LOGGER.warning("Path out of range");
                err.setCode(MapErrorProto.MapError.ErrorCode.SLAM_OUT_OF_RANGE);
                return slam.setError(err.build()).build();
            }
            for (int i = start; i < this.path.size(); ++i) {
                LOGGER.fine("Adding point: " + i);
                MapSlamProto.MapSlam.Point.Builder point = MapSlamProto.MapSlam.Point.newBuilder();
                Point2D.Float p = this.path.get(i);
                point.setX(p.x);
                point.setY(p.y);
                slam.addPoints(point.build());
            }
        }
        err.setCode(MapErrorProto.MapError.ErrorCode.NONE);
        slam.setError(err.build());
        LOGGER.info("Building slam message");
        return slam.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeMapSlam(MapSlamProto.MapSlam slam) {
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            this.path = new LinkedList<Point2D.Float>();
        }
        this.appendMapSlam(slam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMapSlam(MapSlamProto.MapSlam slam) {
        if (slam == null) {
            return;
        }
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            for (MapSlamProto.MapSlam.Point p : slam.getPointsList()) {
                this.path.add(new Point2D.Float(p.getX(), p.getY()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] mapToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            ImageIO.write((RenderedImage)this.map, "png", baos);
        }
        baos.flush();
        byte[] imgInByte = baos.toByteArray();
        baos.close();
        return imgInByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bytesToMap(byte[] source) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            this.map = ImageIO.read(bais);
            if (this.map == null) {
                this.map = new BufferedImage(1024, 1024, 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] pathToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            oos.writeObject(this.path);
        }
        oos.flush();
        baos.flush();
        byte[] outputTrimmed = baos.toByteArray();
        oos.close();
        baos.close();
        return outputTrimmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bytesToPath(byte[] source) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        try {
            VacuumMap vacuumMap = this;
            synchronized (vacuumMap) {
                this.path = (List)o;
            }
        }
        catch (ClassCastException e) {
            throw new IOException("Can't convert to path");
        }
        ois.close();
        bais.close();
    }

    private byte[] compress(byte[] data) {
        byte[] output = new byte[data.length + 1000];
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        byte[] outputTrimmed = new byte[compressor.deflate(output)];
        System.arraycopy(output, 0, outputTrimmed, 0, outputTrimmed.length);
        return outputTrimmed;
    }

    private void inflate(byte[] compressed, byte[] restored) throws IOException {
        Inflater inflate = new Inflater();
        inflate.setInput(compressed);
        inflate.finished();
        try {
            int restoredBytes = inflate.inflate(restored);
            if (restoredBytes != restored.length) {
                throw new IOException("Image size does not match");
            }
        }
        catch (DataFormatException e) {
            throw new IOException("Inflation failed");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        byte[] imgBytes = this.mapToBytes();
        byte[] compressedMap = this.compress(imgBytes);
        byte[] pathBytes = this.pathToBytes();
        byte[] compressedPath = this.compress(pathBytes);
        out.writeInt(compressedMap.length);
        out.writeInt(imgBytes.length);
        out.writeInt(compressedPath.length);
        out.writeInt(pathBytes.length);
        out.write(compressedMap);
        out.write(compressedPath);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] compressedMap = new byte[in.readInt()];
        byte[] mapBytes = new byte[in.readInt()];
        byte[] compressedPath = new byte[in.readInt()];
        byte[] pathBytes = new byte[in.readInt()];
        in.readFully(compressedMap);
        in.readFully(compressedPath);
        this.inflate(compressedMap, mapBytes);
        this.inflate(compressedPath, pathBytes);
        this.bytesToMap(mapBytes);
        this.bytesToPath(pathBytes);
    }
}

