/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miioMapServer;

import de.sg_o.app.miioMapServer.ServerThread;
import de.sg_o.proto.MapErrorProto;
import de.sg_o.proto.MapPackageColorProto;
import de.sg_o.proto.MapPackageProto;
import de.sg_o.proto.MapSlamProto;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class VacuumMap
implements Serializable {
    private static final long serialVersionUID = 6328146796574327681L;
    private static final int MAP_WIDTH = 1024;
    private static final int MAP_HEIGHT = 1024;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    private static final Logger LOGGER = Logger.getLogger(ServerThread.class.getName());
    private transient int[] map;
    private transient List<float[]> path = new LinkedList<float[]>();
    private int[] boundingBox;
    private int overSample;
    private int numberOfSlamLines = 0;
    private boolean slamLocked = true;

    public VacuumMap(BufferedReader image, BufferedReader slam, int overSample, Level logLevel) {
        if (logLevel != null) {
            LOGGER.setLevel(logLevel);
        } else {
            LOGGER.setLevel(Level.OFF);
        }
        if (overSample < 1) {
            overSample = 1;
        }
        this.overSample = overSample;
        LOGGER.fine("Creating empty image");
        this.map = new int[0x100000];
        LOGGER.fine("Creating maximum bounding box");
        this.boundingBox = new int[]{0, 0, 1024, 1024};
        try {
            LOGGER.info("Reading image");
            this.readMap(image);
            LOGGER.info("Reading slam");
            this.readSlam(slam);
        }
        catch (Exception e) {
            LOGGER.warning("Reading failed: " + e);
        }
    }

    public VacuumMap(MapPackageProto.MapPackage image, MapSlamProto.MapSlam slam, int overSample) {
        if (overSample < 1) {
            overSample = 1;
        }
        this.overSample = overSample;
        this.map = new int[0x100000];
        this.boundingBox = new int[]{0, 0, 1024, 1024};
        this.decodeMapPackage(image);
        this.decodeMapSlam(slam);
    }

    private void readMap(BufferedReader image) throws IOException {
        LOGGER.fine("Initializing bounding box creation");
        int x = 0;
        int y = 0;
        int top = 1024;
        int bottom = 0;
        int left = 1024;
        int right = 0;
        if (image.readLine() == null) {
            LOGGER.warning("File format invalid");
            return;
        }
        if (image.readLine() == null) {
            LOGGER.warning("File format invalid");
            return;
        }
        while (true) {
            LOGGER.fine("Reading pixel: " + x + "," + y);
            int[] rgb = new int[]{image.read(), image.read(), image.read()};
            if (rgb[0] < 0 || rgb[1] < 0 || rgb[2] < 0) {
                LOGGER.info("End of map file reached");
                this.boundingBox = new int[]{left, top, right - left + 1, bottom - top + 1};
                return;
            }
            for (int i = 0; i < rgb.length; ++i) {
                rgb[i] = rgb[i] & 0xFF;
            }
            LOGGER.fine("Setting pixel");
            this.map[x + y * 1024] = this.toColorInt(rgb[0], rgb[1], rgb[2], 255);
            if (rgb[0] != 125 || rgb[1] != 125 || rgb[2] != 125) {
                LOGGER.fine("Updating bounding box");
                if (x < left) {
                    left = x;
                }
                if (x > right) {
                    right = x;
                }
                if (y < top) {
                    top = y;
                }
                if (y > bottom) {
                    bottom = y;
                }
            }
            if (++x >= 1024) {
                x = 0;
                ++y;
            }
            if (y < 1024) continue;
            LOGGER.info("Restarting at the start of the image");
            y = 0;
        }
    }

    private void readSlam(BufferedReader slam) throws IOException {
        String line;
        while ((line = slam.readLine()) != null) {
            LOGGER.fine("Parsing line: " + line);
            ++this.numberOfSlamLines;
            if (line.contains("reset")) {
                LOGGER.fine("Reset");
                this.path = new LinkedList<float[]>();
            }
            if (line.contains("lock")) {
                LOGGER.fine("Lock");
                this.slamLocked = true;
            }
            if (line.contains("unlock")) {
                LOGGER.fine("Unlock");
                this.slamLocked = false;
            }
            if (this.slamLocked || !line.contains("estimate")) continue;
            LOGGER.fine("Parsing estimate");
            String[] split = line.split("\\s+");
            if (split.length != 5) {
                LOGGER.info("Estimate of wrong length");
                continue;
            }
            try {
                LOGGER.fine("Parsing coordinates");
                float x = Float.valueOf(split[2]).floatValue() * 20.0f;
                float y = Float.valueOf(split[3]).floatValue() * -20.0f;
                this.path.add(new float[]{x, y});
            }
            catch (Exception e) {
                LOGGER.warning("Parsing coordinates failed: " + e);
            }
        }
    }

    public void appendSlam(BufferedReader slam) {
        try {
            for (int i = 0; i < this.numberOfSlamLines; ++i) {
                if (slam.readLine() != null) continue;
                return;
            }
            this.readSlam(slam);
        }
        catch (Exception e) {
            LOGGER.warning("Parsing slam failed: " + e);
        }
    }

    public synchronized int[] getMap() {
        int width = 1024 * this.overSample;
        int height = 1024 * this.overSample;
        int[] outMap = new int[width * height];
        for (int y = 0; y < 1024; ++y) {
            for (int x = 0; x < 1024; ++x) {
                int color = this.map[x + y * 1024];
                for (int b = 0; b < this.overSample; ++b) {
                    for (int a = 0; a < this.overSample; ++a) {
                        int c = x * this.overSample + a;
                        int d = y * this.overSample + b;
                        outMap[c + d * 1024 * this.overSample] = color;
                    }
                }
            }
        }
        return outMap;
    }

    public synchronized List<float[]> getPath() {
        LinkedList<float[]> outPath = new LinkedList<float[]>();
        for (float[] p : this.path) {
            outPath.add(new float[]{(p[0] + 512.0f) * (float)this.overSample, (p[1] + 512.0f) * (float)this.overSample});
        }
        return outPath;
    }

    public synchronized int getPathSize() {
        return this.path.size();
    }

    public synchronized int[] getBoundingBox() {
        int[] tmp = new int[]{this.boundingBox[0] * this.overSample, this.boundingBox[1] * this.overSample, this.boundingBox[2] * this.overSample, this.boundingBox[3] * this.overSample};
        return tmp;
    }

    public synchronized int getOverSample() {
        return this.overSample;
    }

    public synchronized void setOverSample(int overSample) {
        if (overSample < 1) {
            overSample = 1;
        }
        this.overSample = overSample;
    }

    public synchronized int[] mapPointScale(int[] p) {
        if (p == null) {
            p = new int[]{0, 0};
        }
        int[] scaled = new int[]{p[0] / this.overSample, p[1] / this.overSample};
        return scaled;
    }

    public synchronized int[] mapRectangleScale(int[] rec) {
        if (rec == null) {
            rec = new int[]{0, 0, 0, 0};
        }
        int[] scaled = new int[]{rec[0] / this.overSample, rec[1] / this.overSample, rec[0] / this.overSample + rec[2] / this.overSample, rec[1] / this.overSample + rec[3] / this.overSample};
        return scaled;
    }

    public int[] getMapWithPathInBounds() {
        return this.getMapWithPathInBounds(null, null);
    }

    public int[] getMapWithPathInBounds(Integer startColor, Integer pathColor) {
        int[] raw = this.getMapWithPath(startColor, pathColor);
        int[] tmp = this.getBoundingBox();
        int[] out = new int[tmp[2] * tmp[3]];
        for (int y = 0; y < tmp[3]; ++y) {
            for (int x = 0; x < tmp[2]; ++x) {
                int a = x + tmp[0];
                int b = y + tmp[1];
                out[x + y * tmp[2]] = raw[a + b * 1024 * this.overSample];
            }
        }
        return out;
    }

    public int[] getMapWithPath() {
        return this.getMapWithPath(null, null);
    }

    public synchronized int[] getMapWithPath(Integer startColor, Integer pathColor) {
        if (startColor == null) {
            startColor = -16711936;
        }
        if (pathColor == null) {
            pathColor = -16776961;
        }
        int sColor = startColor;
        int pColor = pathColor;
        int[] pathMap = this.getMap();
        this.drawRectangle(1024 * this.overSample / 2 - 10, 1024 * this.overSample / 2 - 10, 20, 20, pathMap, 1024 * this.overSample, sColor);
        List<float[]> path = this.getPath();
        float[] oldP = null;
        for (float[] p : path) {
            if (oldP == null) {
                oldP = p;
                continue;
            }
            int x0 = Math.round(oldP[0]);
            int y0 = Math.round(oldP[1]);
            int x1 = Math.round(p[0]);
            int y1 = Math.round(p[1]);
            this.drawLine(x0, y0, x1, y1, pathMap, 1024 * this.overSample, pColor);
            oldP = p;
        }
        return pathMap;
    }

    private void drawRectangle(int x0, int y0, int w, int h, int[] map, int mapWidth, int color) {
        for (int j = y0; j < y0 + h; ++j) {
            for (int i = x0; i < x0 + w; ++i) {
                map[i + j * mapWidth] = color;
            }
        }
    }

    private void drawLine(int x0, int y0, int x1, int y1, int[] map, int w, int color) {
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            map[x0 + y0 * w] = color;
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        boolean ret;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacuumMap vacuumMap = (VacuumMap)o;
        if (this.map.length != vacuumMap.map.length) {
            return false;
        }
        for (int i = 0; i < this.map.length; ++i) {
            if (this.map[i] == vacuumMap.map[i]) continue;
            return false;
        }
        VacuumMap vacuumMap2 = this;
        synchronized (vacuumMap2) {
            ret = this.overSample == vacuumMap.overSample && Objects.equals(this.path.size(), vacuumMap.path.size()) && Arrays.equals(this.boundingBox, vacuumMap.boundingBox);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int ret;
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            ret = Objects.hash(this.path.size(), this.boundingBox[0], this.boundingBox[1], this.boundingBox[2], this.boundingBox[3], this.overSample);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String ret;
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            ret = "de.sg_o.app.miioMapServer.VacuumMap{map=width:" + 1024 * this.overSample + "; height:" + 1024 * this.overSample + ", pathEntries=" + this.path.size() + ", boundingBox=" + Arrays.toString(this.getBoundingBox()) + ", overSample=" + this.overSample + '}';
        }
        return ret;
    }

    private int[] getMapInBounds() {
        int[] tmp = this.boundingBox;
        int[] out = new int[tmp[2] * tmp[3]];
        for (int y = 0; y < tmp[3]; ++y) {
            for (int x = 0; x < tmp[2]; ++x) {
                int a = x + tmp[0];
                int b = y + tmp[1];
                out[x + y * tmp[2]] = this.map[a + b * 1024];
            }
        }
        return out;
    }

    public synchronized MapPackageProto.MapPackage getMapPackage() {
        LOGGER.info("Getting the map within bounds");
        int[] mapInBounds = this.getMapInBounds();
        HashMap<Integer, MapPackageColorProto.MapPackageColor.Builder> colorMap = new HashMap<Integer, MapPackageColorProto.MapPackageColor.Builder>();
        LOGGER.info("Creating all colors");
        for (int j = 0; j < this.boundingBox[3]; ++j) {
            for (int i = 0; i < this.boundingBox[2]; ++i) {
                LOGGER.fine("Getting color for pixel: " + i + "," + j);
                int color = mapInBounds[i + j * this.boundingBox[2]];
                LOGGER.fine("Checking whether the color is already in the colorMap");
                MapPackageColorProto.MapPackageColor.Builder builder = (MapPackageColorProto.MapPackageColor.Builder)colorMap.get(color);
                if (builder == null) {
                    LOGGER.fine("Adding new color: " + color);
                    MapPackageColorProto.MapPackageColor.Builder nBuilder = MapPackageColorProto.MapPackageColor.newBuilder();
                    nBuilder.setColor(color);
                    int comp = (j << 16) + i;
                    nBuilder.addCoordinates(comp);
                    colorMap.put(color, nBuilder);
                    continue;
                }
                LOGGER.fine("Adding to existing color");
                int comp = (j << 16) + i;
                builder.addCoordinates(comp);
            }
        }
        MapPackageProto.MapPackage.Builder pack = MapPackageProto.MapPackage.newBuilder();
        pack.setError(MapErrorProto.MapError.newBuilder().setCode(MapErrorProto.MapError.ErrorCode.NONE).build());
        LOGGER.info("Adding bounding box to output");
        pack.setActiveX(this.boundingBox[0]);
        pack.setActiveY(this.boundingBox[1]);
        pack.setActiveW(this.boundingBox[2]);
        pack.setActiveH(this.boundingBox[3]);
        LOGGER.info("Adding all colors to output");
        for (MapPackageColorProto.MapPackageColor.Builder b : colorMap.values()) {
            MapPackageColorProto.MapPackageColor col = b.build();
            LOGGER.fine("Adding color: " + col.toString());
            pack.addData(col);
        }
        LOGGER.info("Building output");
        return pack.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeMapPackage(MapPackageProto.MapPackage image) {
        if (image == null) {
            return;
        }
        this.boundingBox[0] = image.getActiveX();
        this.boundingBox[1] = image.getActiveY();
        this.boundingBox[2] = image.getActiveW();
        this.boundingBox[3] = image.getActiveH();
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            for (int i = 0; i < this.map.length; ++i) {
                this.map[i] = this.toColorInt(125, 125, 125, 255);
            }
            for (MapPackageColorProto.MapPackageColor c : image.getDataList()) {
                int color = c.getColor();
                for (int pos : c.getCoordinatesList()) {
                    this.map[this.boundingBox[0] + (pos & 0xFFFF) + (this.boundingBox[1] + (pos >> 16 & 0xFFFF)) * 1024] = color;
                }
            }
        }
    }

    public MapSlamProto.MapSlam getMapPath() {
        return this.getMapPath(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapSlamProto.MapSlam getMapPath(int start) {
        LOGGER.info("Getting path from " + start);
        MapErrorProto.MapError.Builder err = MapErrorProto.MapError.newBuilder();
        MapSlamProto.MapSlam.Builder slam = MapSlamProto.MapSlam.newBuilder();
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            if (start >= this.path.size() || start < 0) {
                LOGGER.warning("Path out of range");
                err.setCode(MapErrorProto.MapError.ErrorCode.SLAM_OUT_OF_RANGE);
                return slam.setError(err.build()).build();
            }
            for (int i = start; i < this.path.size(); ++i) {
                LOGGER.fine("Adding point: " + i);
                MapSlamProto.MapSlam.Point.Builder point = MapSlamProto.MapSlam.Point.newBuilder();
                float[] p = this.path.get(i);
                point.setX(p[0]);
                point.setY(p[1]);
                slam.addPoints(point.build());
            }
        }
        err.setCode(MapErrorProto.MapError.ErrorCode.NONE);
        slam.setError(err.build());
        LOGGER.info("Building slam message");
        return slam.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeMapSlam(MapSlamProto.MapSlam slam) {
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            this.path = new LinkedList<float[]>();
        }
        this.appendMapSlam(slam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMapSlam(MapSlamProto.MapSlam slam) {
        if (slam == null) {
            return;
        }
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            for (MapSlamProto.MapSlam.Point p : slam.getPointsList()) {
                this.path.add(new float[]{p.getX(), p.getY()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] mapToBytes() {
        byte[] out = new byte[this.map.length * 4];
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            for (int i = 0; i < this.map.length; ++i) {
                out[i * 4] = (byte)(this.map[i] & 0xFF);
                out[i * 4 + 1] = (byte)(this.map[i] >> 8 & 0xFF);
                out[i * 4 + 2] = (byte)(this.map[i] >> 16 & 0xFF);
                out[i * 4 + 3] = (byte)(this.map[i] >> 24 & 0xFF);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bytesToMap(byte[] source) throws IOException {
        this.map = new int[0x100000];
        if (this.map.length * 4 != source.length) {
            throw new IOException();
        }
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            for (int i = 0; i < this.map.length; ++i) {
                int tmp = 0;
                tmp |= source[i * 4 + 3] & 0xFF;
                tmp <<= 8;
                tmp |= source[i * 4 + 2] & 0xFF;
                tmp <<= 8;
                tmp |= source[i * 4 + 1] & 0xFF;
                tmp <<= 8;
                this.map[i] = tmp |= source[i * 4] & 0xFF;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] pathToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        VacuumMap vacuumMap = this;
        synchronized (vacuumMap) {
            oos.writeObject(this.path);
        }
        oos.flush();
        baos.flush();
        byte[] outputTrimmed = baos.toByteArray();
        oos.close();
        baos.close();
        return outputTrimmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bytesToPath(byte[] source) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        try {
            VacuumMap vacuumMap = this;
            synchronized (vacuumMap) {
                this.path = (List)o;
            }
        }
        catch (ClassCastException e) {
            throw new IOException("Can't convert to path");
        }
        ois.close();
        bais.close();
    }

    private byte[] compress(byte[] data) {
        byte[] output = new byte[data.length + 1000];
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        byte[] outputTrimmed = new byte[compressor.deflate(output)];
        System.arraycopy(output, 0, outputTrimmed, 0, outputTrimmed.length);
        return outputTrimmed;
    }

    private void inflate(byte[] compressed, byte[] restored) throws IOException {
        Inflater inflate = new Inflater();
        inflate.setInput(compressed);
        inflate.finished();
        try {
            int restoredBytes = inflate.inflate(restored);
            if (restoredBytes != restored.length) {
                throw new IOException("Image size does not match");
            }
        }
        catch (DataFormatException e) {
            throw new IOException("Inflation failed");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        byte[] imgBytes = this.mapToBytes();
        byte[] compressedMap = this.compress(imgBytes);
        byte[] pathBytes = this.pathToBytes();
        byte[] compressedPath = this.compress(pathBytes);
        out.writeInt(compressedMap.length);
        out.writeInt(imgBytes.length);
        out.writeInt(compressedPath.length);
        out.writeInt(pathBytes.length);
        out.write(compressedMap);
        out.write(compressedPath);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] compressedMap = new byte[in.readInt()];
        byte[] mapBytes = new byte[in.readInt()];
        byte[] compressedPath = new byte[in.readInt()];
        byte[] pathBytes = new byte[in.readInt()];
        in.readFully(compressedMap);
        in.readFully(compressedPath);
        this.inflate(compressedMap, mapBytes);
        this.inflate(compressedPath, pathBytes);
        this.bytesToMap(mapBytes);
        this.bytesToPath(pathBytes);
    }

    private int toColorInt(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

