/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miioMapServer;

import de.sg_o.app.miioMapServer.VacuumMap;
import de.sg_o.proto.MapPackageProto;
import de.sg_o.proto.MapSlamProto;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class Maps {
    private static final Logger LOGGER = Logger.getLogger(Maps.class.getName());
    private final File activeMapDirectory;
    private final File previousMapsDirectory;
    private MapPackageProto.MapPackage activeMap;
    private File activeMapSlam;
    private MapPackageProto.MapPackage lastMap;
    private MapSlamProto.MapSlam lastPath;
    private int lastMapNumber = 0;
    private long activeMapLastModified = 0L;
    private LinkedHashMap<String, File[]> previousMaps = new LinkedHashMap();

    public Maps(File activeMapDirectory, File previousMapsDirectory, Level logLevel) throws IOException {
        if (logLevel != null) {
            LOGGER.setLevel(logLevel);
        }
        LOGGER.info("Starting map directory checking");
        if (activeMapDirectory == null || previousMapsDirectory == null) {
            throw new IOException();
        }
        if (!activeMapDirectory.exists() || !previousMapsDirectory.exists()) {
            throw new IOException();
        }
        if (!activeMapDirectory.isDirectory() || !previousMapsDirectory.isDirectory()) {
            throw new IOException();
        }
        LOGGER.info("Map directories fine");
        this.activeMapDirectory = activeMapDirectory;
        this.previousMapsDirectory = previousMapsDirectory;
        LOGGER.info("Generating active map");
        this.generateActiveMap();
        LOGGER.info("Finished generating active map");
        LOGGER.info("Generating old maps list");
        this.generatePreviousMaps();
        LOGGER.info("Finished generating old maps list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateActiveMap() {
        File mapFile = null;
        File slamFile = null;
        if (this.activeMapDirectory == null) {
            LOGGER.warning("Active map directory not set");
            this.activeMap = null;
            return;
        }
        File[] files = this.activeMapDirectory.listFiles();
        if (files == null) {
            LOGGER.warning("Unable to list files in active map directory");
            this.activeMap = null;
            return;
        }
        LOGGER.info("Going through files to find active map and slam");
        for (File f : files) {
            if (f.isDirectory()) continue;
            LOGGER.fine("Active map directory file: " + f.getName());
            if (f.getName().startsWith("navmap") && f.getName().endsWith(".ppm")) {
                LOGGER.info("Found navmap");
                mapFile = f;
            }
            if (!f.getName().equals("SLAM_fprintf.log")) continue;
            LOGGER.info("Found SLAM");
            slamFile = f;
        }
        if (mapFile == null || slamFile == null) {
            LOGGER.info("No valid active map found");
            this.activeMap = null;
            return;
        }
        if (this.activeMapLastModified == mapFile.lastModified()) {
            LOGGER.info("Map file doesn't need updating");
            return;
        }
        try {
            Maps maps = this;
            synchronized (maps) {
                LOGGER.info("Creating active de.sg_o.app.miioMapServer.VacuumMap");
                this.activeMap = VacuumMap.directToMapPackage(new BufferedReader(new FileReader(mapFile)));
                this.activeMapSlam = slamFile;
                LOGGER.info("Created active de.sg_o.app.miioMapServer.VacuumMap");
                this.activeMapLastModified = mapFile.lastModified();
            }
        }
        catch (IOException iOException) {
            LOGGER.warning("Unable to open active map files");
            this.activeMap = null;
        }
    }

    private void generatePreviousMaps() {
        if (this.previousMapsDirectory == null) {
            LOGGER.warning("Previous maps directory not set");
            this.previousMaps = new LinkedHashMap();
            return;
        }
        File[] files = this.previousMapsDirectory.listFiles();
        if (files == null) {
            LOGGER.warning("Unable to list files in previous maps directory");
            this.previousMaps = new LinkedHashMap();
            return;
        }
        for (File f : files) {
            if (!f.isDirectory()) continue;
            LOGGER.fine("Previous map directory: " + f.getName());
            this.extractMap(f);
        }
        LOGGER.info("Checking for the latest previous map");
        String latestMapName = null;
        for (String s : this.previousMaps.keySet()) {
            LOGGER.fine("Checking previous map: " + s);
            String[] split = s.split("\\.");
            if (split.length < 1) {
                LOGGER.info("The directory name could not be parsed: " + s);
                continue;
            }
            try {
                int i = Integer.valueOf(split[0]);
                if (i <= this.lastMapNumber) continue;
                LOGGER.fine("Found newer map" + i);
                this.lastMapNumber = i;
                latestMapName = s;
            }
            catch (Exception e) {
                LOGGER.info("The directory name could not be parsed: " + s + ": " + e.toString());
            }
        }
        if (latestMapName != null) {
            LOGGER.info("Generating latest old vacuumMap");
            this.lastMap = this.getOldMap(latestMapName);
            this.lastPath = this.getOldPath(latestMapName);
            LOGGER.info("Generated latest old vacuumMap");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractMap(File folder) {
        File mapFile = null;
        File slamFile = null;
        if (folder == null) {
            LOGGER.warning("Map directory for extraction not set");
            return;
        }
        if (this.previousMaps.containsKey(folder.getName())) {
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            LOGGER.warning("Unable to list files in directory for extraction");
            return;
        }
        LOGGER.info("Going through files to find previous map and slam");
        for (File f : files) {
            LOGGER.fine("Previous map directory file: " + f.getName());
            if (f.isDirectory()) continue;
            if (f.getName().startsWith("navmap") && f.getName().endsWith(".gz")) {
                LOGGER.info("Found navmap");
                mapFile = f;
            }
            if (!f.getName().startsWith("SLAM_fprintf.log") || !f.getName().endsWith(".gz")) continue;
            LOGGER.info("Found SLAM");
            slamFile = f;
        }
        if (mapFile == null || slamFile == null) {
            LOGGER.info("No valid previous map found");
            return;
        }
        Maps maps = this;
        synchronized (maps) {
            LOGGER.info("Preparing storing of map name and files");
            File[] mapFiles = new File[]{mapFile, slamFile};
            LOGGER.info("Storing of map name and files");
            this.previousMaps.put(folder.getName(), mapFiles);
            LOGGER.info("Stored of map name and files");
        }
    }

    public MapPackageProto.MapPackage getOldMap(String name) {
        if (name == null) {
            LOGGER.warning("No old map file provided to parse");
            return null;
        }
        File[] map = this.previousMaps.get(name);
        if (map == null) {
            LOGGER.warning("Old map " + name + " not found");
            return null;
        }
        if (map.length != 2) {
            LOGGER.warning("Old map entry not of correct length");
            return null;
        }
        LOGGER.info("Decompressing map file");
        BufferedReader mapReader = this.unzipFile(map[0]);
        LOGGER.info("Done decompressing");
        if (mapReader == null) {
            LOGGER.warning("Decompression failed");
            return null;
        }
        LOGGER.info("Generating old map");
        try {
            return VacuumMap.directToMapPackage(mapReader);
        }
        catch (IOException e) {
            LOGGER.warning("Unable to open old map file");
            return null;
        }
    }

    public MapSlamProto.MapSlam getOldPath(String name) {
        if (name == null) {
            LOGGER.warning("No old map file provided to parse");
            return null;
        }
        File[] map = this.previousMaps.get(name);
        if (map == null) {
            LOGGER.warning("Old map " + name + " not found");
            return null;
        }
        if (map.length != 2) {
            LOGGER.warning("Old map entry not of correct length");
            return null;
        }
        LOGGER.info("Decompressing SLAM file");
        BufferedReader slamReader = this.unzipFile(map[1]);
        LOGGER.info("Done decompressing");
        if (slamReader == null) {
            LOGGER.warning("Decompression failed");
            return null;
        }
        LOGGER.info("Generating old map");
        try {
            return VacuumMap.directToPath(slamReader);
        }
        catch (IOException e) {
            LOGGER.warning("Unable to open old path file");
            return null;
        }
    }

    private BufferedReader unzipFile(File compressed) {
        GZIPInputStream gin;
        if (compressed == null) {
            LOGGER.warning("File for extraction not set");
            return null;
        }
        try {
            LOGGER.info("Generating GZIPInputStream");
            gin = new GZIPInputStream(new FileInputStream(compressed));
        }
        catch (IOException e) {
            LOGGER.warning("GZIPInputStream could not be created");
            return null;
        }
        LOGGER.fine("Creating small buffer for decompression");
        byte[] buf = new byte[1024];
        try {
            int len;
            LOGGER.fine("Creating big buffer for decompression");
            byte[] all = new byte[0x400000];
            int i = 0;
            LOGGER.info("Starting decompression");
            while ((len = gin.read(buf)) > 0) {
                LOGGER.fine("Decompression round " + (i + 1));
                LOGGER.fine("Decompressed " + len + "bytes. Copping to to big buffer");
                System.arraycopy(buf, 0, all, i, len);
                i += len;
            }
            LOGGER.info("Creating decompressed InputStream");
            ByteArrayInputStream is = new ByteArrayInputStream(all, 0, i);
            LOGGER.info("Creating uncompressed BufferedReader");
            return new BufferedReader(new InputStreamReader(is));
        }
        catch (IOException e) {
            LOGGER.warning("Decompression failed: " + e.toString());
            return null;
        }
    }

    public MapPackageProto.MapPackage getActiveMap() {
        return this.activeMap;
    }

    public MapPackageProto.MapPackage getLastMap() {
        return this.lastMap;
    }

    public MapSlamProto.MapSlam getLastPath() {
        return this.lastPath;
    }

    public Set<String> getPreviousMaps() {
        return this.previousMaps.keySet();
    }

    public boolean hasActiveMap() {
        return this.activeMap != null;
    }

    public int numberOfPreviousMaps() {
        return this.previousMaps.size();
    }

    public void updateActiveMap() {
        this.generateActiveMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapSlamProto.MapSlam getActivePathFrom(int start) {
        if (this.activeMapSlam == null) {
            LOGGER.info("No slam file set");
            return null;
        }
        if (!this.activeMapSlam.exists()) {
            LOGGER.info("Slam file does not exist");
            return null;
        }
        if (this.activeMap == null) {
            LOGGER.info("Active map not set");
            return null;
        }
        try {
            Maps maps = this;
            synchronized (maps) {
                LOGGER.info("Appending slam");
                return VacuumMap.directToPath(new BufferedReader(new FileReader(this.activeMapSlam)), start);
            }
        }
        catch (IOException e) {
            LOGGER.warning("Appending slam failed");
            return null;
        }
    }

    public void updatePreviousMaps() {
        this.generatePreviousMaps();
    }
}

