/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miioMapServer;

import de.sg_o.app.miioMapServer.Server;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class Run {
    public static void main(String[] args) throws IOException {
        File currentMap = new File("/run/shm/");
        File oldMap = new File("/mnt/data/rockrobo/rrlog");
        File log = new File("/mnt/data/server/logs/mapServer.log");
        File token = new File("/mnt/data/miio/device.token");
        if (!log.getParentFile().exists()) {
            log.getParentFile().mkdirs();
        }
        Level lv = Level.INFO;
        for (Map.Entry<Args, String> e : Run.parseArgs(args)) {
            if (e.getKey().equals((Object)Args.LOG_LEVEL)) {
                lv = Run.parseLevel(e.getValue());
            }
            if (e.getKey().equals((Object)Args.CURRENT_MAP)) {
                currentMap = new File(e.getValue());
            }
            if (e.getKey().equals((Object)Args.OLD_MAP)) {
                oldMap = new File(e.getValue());
            }
            if (e.getKey().equals((Object)Args.LOG_FILE)) {
                log = e.getValue().equals("") ? null : new File(e.getValue());
            }
            if (e.getKey().equals((Object)Args.TOKEN)) {
                token = new File(e.getValue());
            }
            if (e.getKey().equals((Object)Args.VERSION)) {
                Run.printVersion();
                return;
            }
            if (!e.getKey().equals((Object)Args.HELP)) continue;
            Run.printVersion();
            Run.printHelp();
            return;
        }
        Server s0 = new Server(currentMap, oldMap, 54331, token, lv, log);
        s0.run();
    }

    private static List<Map.Entry<Args, String>> parseArgs(String[] args) {
        LinkedList<Map.Entry<Args, String>> argMap = new LinkedList<Map.Entry<Args, String>>();
        if (args == null) {
            return argMap;
        }
        if (args.length < 1) {
            return argMap;
        }
        for (int i = 0; i < args.length; ++i) {
            String d = args[i];
            if (d.startsWith("-")) {
                if (d.length() < 2) continue;
                Args arg = Args.valueOfString(d.substring(1, 2));
                if (arg.equals((Object)Args.UNKNOWN)) {
                    argMap.add(new AbstractMap.SimpleEntry<Args, String>(arg, d));
                    continue;
                }
                if (arg.equals((Object)Args.MULTIPLE)) {
                    if (d.length() < 3) continue;
                    argMap.add(new AbstractMap.SimpleEntry<Args, String>(arg, d.substring(2)));
                    continue;
                }
                if (++i >= args.length) {
                    argMap.add(new AbstractMap.SimpleEntry<Args, String>(arg, ""));
                    break;
                }
                if (args[i].startsWith("-")) {
                    --i;
                    argMap.add(new AbstractMap.SimpleEntry<Args, String>(arg, ""));
                    continue;
                }
                argMap.add(new AbstractMap.SimpleEntry<Args, String>(arg, args[i]));
                continue;
            }
            if (d.length() < 1) continue;
            argMap.add(new AbstractMap.SimpleEntry<Args, String>(Args.UNKNOWN, d));
        }
        return argMap;
    }

    private static Level parseLevel(String in) {
        switch (in) {
            case "warning": {
                return Level.WARNING;
            }
            case "info": {
                return Level.INFO;
            }
            case "fine": {
                return Level.FINE;
            }
            case "finer": {
                return Level.FINER;
            }
            case "finest": {
                return Level.FINEST;
            }
            case "all": {
                return Level.ALL;
            }
            case "off": {
                return Level.OFF;
            }
        }
        return Level.INFO;
    }

    private static void printHelp() {
        Args[] all;
        System.out.println();
        System.out.println("Program arguments:");
        System.out.println();
        for (Args arg : all = Args.getAll()) {
            if (arg.equals((Object)Args.UNKNOWN) || arg.equals((Object)Args.MULTIPLE)) continue;
            System.out.println(arg.toString());
        }
    }

    private static void printVersion() {
        Properties properties = new Properties();
        try {
            properties.load(Run.class.getResourceAsStream("project.properties"));
            System.out.println(properties.getProperty("artifactId") + ": " + properties.getProperty("version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static enum Args {
        UNKNOWN("", ""),
        MULTIPLE("-", ""),
        CURRENT_MAP("c", "Specify the path where the directory where current map is stored."),
        OLD_MAP("o", "Specify the path where the directory where old maps directories are stored."),
        LOG_FILE("l", "Specify the file the log should be written to."),
        LOG_LEVEL("d", "Specify the log level. warning; info; fine; finer; finest; all; off"),
        TOKEN("t", "Specify the path to the file where the token is stored in"),
        VERSION("v", "Print the version of this program"),
        HELP("?", "Prints this help");

        private final String arg;
        private final String description;
        private static Map<String, Args> map;

        private Args(String arg, String description) {
            this.arg = arg;
            this.description = description;
        }

        public static Args valueOfString(String arg) {
            Args st = map.get(arg);
            if (st == null) {
                return UNKNOWN;
            }
            return st;
        }

        public String toString() {
            return "-" + this.arg + ": " + this.description;
        }

        public static Args[] getAll() {
            return map.values().toArray(new Args[0]);
        }

        static {
            map = new HashMap<String, Args>();
            for (Args st : Args.values()) {
                map.put(st.arg, st);
            }
        }
    }
}

