/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miioMapServer;

import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.util.ByteArray;
import de.sg_o.app.miioMapServer.Maps;
import de.sg_o.proto.MapErrorProto;
import de.sg_o.proto.MapInfoProto;
import de.sg_o.proto.MapPackageProto;
import de.sg_o.proto.MapRequestProto;
import de.sg_o.proto.MapSlamProto;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(ServerThread.class.getName());
    private Socket socket;
    private Maps mapHandler;
    private Token tk;
    private boolean authenticated = false;

    public ServerThread(Socket socket, Maps mapHandler, Token tk, Level logLevel) throws IOException {
        super("MapServerThread");
        if (logLevel != null) {
            LOGGER.setLevel(logLevel);
        }
        LOGGER.info("Generating server thread");
        if (socket == null) {
            LOGGER.warning("Socket null");
            throw new IOException();
        }
        this.socket = socket;
        if (mapHandler == null) {
            LOGGER.warning("Map handler null");
            throw new IOException();
        }
        this.mapHandler = mapHandler;
        if (tk == null) {
            LOGGER.warning("Token null");
            throw new IOException("No token provided");
        }
        this.tk = tk;
    }

    @Override
    public void run() {
        OutputStream outputStream;
        InputStream inputStream;
        LOGGER.info("Starting server thread");
        try {
            LOGGER.info("Getting input stream");
            inputStream = this.socket.getInputStream();
            LOGGER.info("Getting output stream");
            outputStream = this.socket.getOutputStream();
            LOGGER.info("Got all streams");
        }
        catch (IOException e) {
            LOGGER.warning("Error getting streams: " + e.toString());
            this.forceClose();
            return;
        }
        while (this.socket.isConnected()) {
            try {
                MapRequestProto.MapRequest request;
                LOGGER.info("Trying to receive request");
                while ((request = MapRequestProto.MapRequest.parseDelimitedFrom(inputStream)) == null) {
                }
                LOGGER.info("Got request");
                this.sendResponse(request, outputStream);
            }
            catch (IOException e) {
                LOGGER.warning("Error receiving request: " + e.toString());
                this.forceClose();
                return;
            }
        }
    }

    private void sendResponse(MapRequestProto.MapRequest req, OutputStream output) {
        if (req == null) {
            return;
        }
        if (output == null) {
            return;
        }
        LOGGER.info("Parsing Code");
        MapRequestProto.MapRequest.RequestCode code = req.getCode();
        switch (code) {
            case MAP_INFO: {
                LOGGER.info("MAP_INFO detected");
                this.sendInfo(output);
                break;
            }
            case GET_ACTIVE_MAP: {
                LOGGER.info("GET_ACTIVE_MAP detected");
                this.sendActiveMap(output);
                break;
            }
            case GET_PREVIOUS_MAP: {
                LOGGER.info("GET_PREVIOUS_MAP detected");
                this.sendPreviousMap(output);
                break;
            }
            case GET_OLD_MAP: {
                LOGGER.info("GET_OLD_MAP detected");
                this.sendOldMap(req.getOpt(), output);
                break;
            }
            case GET_ACTIVE_MAP_SLAM: {
                LOGGER.info("GET_ACTIVE_MAP_SLAM detected");
                this.sendActiveMapSlam(req.getOptInt(), output);
                break;
            }
            case GET_PREVIOUS_MAP_SLAM: {
                LOGGER.info("GET_PREVIOUS_MAP_SLAM detected");
                this.sendPreviousMapSlam(output);
                break;
            }
            case GET_OLD_MAP_SLAM: {
                LOGGER.info("GET_OLD_MAP_SLAM detected");
                this.sendOldMapSlam(req.getOpt(), output);
                break;
            }
            case AUTHENTICATE: {
                LOGGER.info("AUTHENTICATE detected");
                this.authenticate(req.getOpt(), output);
                break;
            }
            case END_COMMUNICATION: {
                this.forceClose();
            }
        }
    }

    private void authenticate(String auth, OutputStream output) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        MapRequestProto.MapRequest.Builder resp = MapRequestProto.MapRequest.newBuilder();
        if (auth == null) {
            try {
                LOGGER.warning("No encrypted auth message received");
                resp.setOpt(ByteArray.bytesToHex((byte[])this.tk.encrypt("error".getBytes("ASCII"))));
                resp.build().writeDelimitedTo(output);
                this.forceClose();
                return;
            }
            catch (IOException e) {
                this.forceClose();
            }
        }
        LOGGER.info("Decoding auth message");
        byte[] msg = this.tk.decrypt(ByteArray.hexToBytes((String)auth));
        LOGGER.info("Decoded auth message");
        this.authenticated = Arrays.equals(new byte[]{104, 101, 108, 108, 111}, msg);
        LOGGER.info("Compared auth message");
        resp.setCode(MapRequestProto.MapRequest.RequestCode.AUTHENTICATE);
        try {
            if (this.authenticated) {
                LOGGER.info("Authentication success");
                resp.setOpt(ByteArray.bytesToHex((byte[])this.tk.encrypt("ok".getBytes("ASCII"))));
                resp.build().writeDelimitedTo(output);
            } else {
                LOGGER.info("Authentication failed");
                resp.setOpt(ByteArray.bytesToHex((byte[])this.tk.encrypt("error".getBytes("ASCII"))));
                resp.build().writeDelimitedTo(output);
                this.forceClose();
            }
        }
        catch (IOException e) {
            LOGGER.warning("Couldn't send authentication response");
            this.forceClose();
        }
    }

    private void sendInfo(OutputStream output) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        LOGGER.info("Updating active map");
        this.mapHandler.updateActiveMap();
        LOGGER.info("Updating previous maps");
        this.mapHandler.updatePreviousMaps();
        MapInfoProto.MapInfo.Builder builder = MapInfoProto.MapInfo.newBuilder();
        if (this.authenticated) {
            LOGGER.info("Adding information");
            builder.setActiveMapAvailable(this.mapHandler.hasActiveMap());
            builder.addAllOldMaps(this.mapHandler.getPreviousMaps());
            builder.setError(this.constructError(MapErrorProto.MapError.ErrorCode.NONE, ""));
        } else {
            LOGGER.warning("Not authenticated");
            builder.setActiveMapAvailable(false);
            builder.setError(this.constructError(MapErrorProto.MapError.ErrorCode.NOT_AUTHENTICATED, ""));
        }
        try {
            LOGGER.info("Sending info");
            builder.build().writeDelimitedTo(output);
        }
        catch (IOException ignore) {
            LOGGER.warning("Couldn't send information");
        }
    }

    private void sendActiveMap(OutputStream output) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        LOGGER.info("Updating active map");
        this.mapHandler.updateActiveMap();
        LOGGER.info("Sending active map");
        this.sendMap(this.mapHandler.getActiveMap(), output, MapErrorProto.MapError.ErrorCode.MAP_NOT_AVAILABLE);
    }

    private void sendActiveMapSlam(int start, OutputStream output) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        LOGGER.info("Sending active map slam");
        this.sendSlam(this.mapHandler.getActivePathFrom(start), output, MapErrorProto.MapError.ErrorCode.MAP_NOT_AVAILABLE);
    }

    private void sendPreviousMap(OutputStream output) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        LOGGER.info("Updating previous map");
        this.mapHandler.updatePreviousMaps();
        LOGGER.info("Sending previous map");
        this.sendMap(this.mapHandler.getLastMap(), output, MapErrorProto.MapError.ErrorCode.MAP_NOT_AVAILABLE);
    }

    private void sendPreviousMapSlam(OutputStream output) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        LOGGER.info("Updating previous map");
        this.mapHandler.updatePreviousMaps();
        LOGGER.info("Sending previous map slam");
        this.sendSlam(this.mapHandler.getLastPath(), output, MapErrorProto.MapError.ErrorCode.MAP_NOT_AVAILABLE);
    }

    private void sendOldMap(String name, OutputStream output) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        if (name == null) {
            MapPackageProto.MapPackage.Builder builder = MapPackageProto.MapPackage.newBuilder();
            LOGGER.warning("Name not provided");
            builder.setError(this.constructError(MapErrorProto.MapError.ErrorCode.COMMUNICATION_ERROR, ""));
            try {
                builder.build().writeDelimitedTo(output);
            }
            catch (IOException ignore) {
                LOGGER.warning("Couldn't send error message");
            }
            return;
        }
        LOGGER.info("Sending old map: " + name);
        this.sendMap(this.mapHandler.getOldMap(name), output, MapErrorProto.MapError.ErrorCode.MAP_NOT_FOUND);
    }

    private void sendOldMapSlam(String name, OutputStream output) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        if (name == null) {
            MapPackageProto.MapPackage.Builder builder = MapPackageProto.MapPackage.newBuilder();
            LOGGER.warning("Name not provided");
            builder.setError(this.constructError(MapErrorProto.MapError.ErrorCode.COMMUNICATION_ERROR, ""));
            try {
                builder.build().writeDelimitedTo(output);
            }
            catch (IOException ignore) {
                LOGGER.warning("Couldn't send error message");
            }
            return;
        }
        LOGGER.info("Sending old map slam: " + name);
        this.sendSlam(this.mapHandler.getOldPath(name), output, MapErrorProto.MapError.ErrorCode.MAP_NOT_FOUND);
    }

    private void sendMap(MapPackageProto.MapPackage map, OutputStream output, MapErrorProto.MapError.ErrorCode applicableError) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        MapPackageProto.MapPackage.Builder builder = MapPackageProto.MapPackage.newBuilder();
        if (this.authenticated) {
            if (map == null) {
                LOGGER.warning("Map null");
                builder.setError(this.constructError(applicableError, "Map null"));
            } else {
                LOGGER.info("Generating map package and sending");
                try {
                    map.writeDelimitedTo(output);
                    return;
                }
                catch (IOException ignore) {
                    LOGGER.warning("Couldn't send map message");
                }
            }
        } else {
            LOGGER.warning("Not authenticated");
            builder.setError(this.constructError(MapErrorProto.MapError.ErrorCode.NOT_AUTHENTICATED, ""));
        }
        try {
            LOGGER.info("Sending map message");
            builder.build().writeDelimitedTo(output);
        }
        catch (IOException ignore) {
            LOGGER.warning("Couldn't send map message");
        }
    }

    private void sendSlam(MapSlamProto.MapSlam map, OutputStream output, MapErrorProto.MapError.ErrorCode applicableError) {
        if (output == null) {
            LOGGER.warning("OutputStream null");
            return;
        }
        MapSlamProto.MapSlam.Builder builder = MapSlamProto.MapSlam.newBuilder();
        if (this.authenticated) {
            if (map == null) {
                LOGGER.warning("Map null");
                builder.setError(this.constructError(applicableError, "Map null"));
            } else {
                LOGGER.info("Generating map slam and sending");
                try {
                    map.writeDelimitedTo(output);
                    return;
                }
                catch (IOException ignore) {
                    LOGGER.warning("Couldn't send map slam message");
                }
            }
        } else {
            LOGGER.warning("Not authenticated");
            builder.setError(this.constructError(MapErrorProto.MapError.ErrorCode.NOT_AUTHENTICATED, ""));
        }
        try {
            LOGGER.info("Sending map slam message");
            builder.build().writeDelimitedTo(output);
        }
        catch (IOException ignore) {
            LOGGER.warning("Couldn't send map slam message");
        }
    }

    private MapErrorProto.MapError constructError(MapErrorProto.MapError.ErrorCode code, String opt) {
        LOGGER.info("Constructing error message");
        MapErrorProto.MapError.Builder error = MapErrorProto.MapError.newBuilder();
        if (code == null) {
            LOGGER.warning("Code null");
            code = MapErrorProto.MapError.ErrorCode.UNKNOWN;
        }
        error.setCode(code);
        if (opt != null) {
            LOGGER.info("No opt string provided");
            error.setOpt(opt);
        }
        LOGGER.info("Building error message");
        return error.build();
    }

    private void forceClose() {
        try {
            LOGGER.info("Closing socket");
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.info("Couldn't close socket: " + e.toString());
        }
    }
}

