/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.manager;

import de.sg_o.lib.photoNet.printer.Discover;
import de.sg_o.lib.photoNet.printer.Printer;
import java.util.ArrayList;
import java.util.TreeMap;

public class Environment {
    private final Discover available;
    private final ArrayList<Printer> connected = new ArrayList();

    public Environment(String connected, int discoveryTimeout) {
        String[] printers;
        if (connected != null && (printers = connected.split(";")).length > 0) {
            for (String p : printers) {
                if (p.length() < 1) continue;
                try {
                    Printer pr = new Printer(p);
                    this.connected.add(pr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.available = new Discover(discoveryTimeout);
        this.available.update();
    }

    public Discover getDiscover() {
        return this.available;
    }

    public TreeMap<String, String> notConnected() {
        TreeMap<String, String> missing = new TreeMap<String, String>();
        if (!this.available.isValid()) {
            return missing;
        }
        TreeMap<String, String> discovered = this.available.getDiscovered();
        missing.putAll(discovered);
        for (Printer p : this.connected) {
            missing.remove(p.getIp());
        }
        return missing;
    }

    public Printer connect(String ip) {
        if (ip == null) {
            return null;
        }
        if (!this.available.isValid()) {
            return null;
        }
        TreeMap<String, String> discovered = this.available.getDiscovered();
        for (Printer p : this.connected) {
            if (!p.getIp().equals(ip)) continue;
            return p;
        }
        try {
            Printer p = new Printer(ip);
            this.connected.add(p);
            return p;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ArrayList<Printer> getConnected() {
        return this.connected;
    }

    public void disconnect(String ip) {
        if (ip == null) {
            return;
        }
        Printer toDelete = null;
        for (Printer p : this.connected) {
            if (!p.getIp().equals(ip)) continue;
            toDelete = p;
            break;
        }
        if (toDelete != null) {
            toDelete.disconnect();
            this.connected.remove(toDelete);
        }
    }

    public String save() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Printer p : this.connected) {
            if (first) {
                first = false;
            } else {
                builder.append(";");
            }
            builder.append(p.getIp());
        }
        return builder.toString();
    }
}

