/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import de.sg_o.lib.photoNet.netData.DataTransferBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DataDownloadFile {
    private final RandomAccessFile model;

    public DataDownloadFile(File modelFile) throws FileNotFoundException {
        if (modelFile == null) {
            throw new FileNotFoundException("File null");
        }
        if (modelFile.isDirectory()) {
            throw new FileNotFoundException("File is directory");
        }
        File parent = modelFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalStateException("Couldn't create dir: " + parent);
        }
        modelFile.delete();
        this.model = new RandomAccessFile(modelFile, "rw");
    }

    public boolean writeBlock(DataTransferBlock block) throws IOException {
        this.model.seek(block.getOffset());
        this.model.write(block.getData());
        return true;
    }

    public boolean writeBlock(byte[] raw) throws IOException {
        DataTransferBlock block = new DataTransferBlock(raw);
        if (!block.verifyChecksum()) {
            return false;
        }
        return this.writeBlock(block);
    }

    public void close() throws IOException {
        this.model.close();
    }
}

