/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import java.security.InvalidParameterException;

public class DataTransferBlock {
    private final byte[] data;
    private final long offset;
    private byte check = 0;

    public DataTransferBlock(byte[] data, long offset) {
        this.data = data;
        this.offset = offset;
        for (byte datum : data) {
            this.check = (byte)(this.check ^ datum);
        }
        for (int i = 0; i < 4; ++i) {
            this.check = (byte)((long)this.check ^ offset & 0xFFL);
            offset >>= 8;
        }
    }

    public DataTransferBlock(byte[] raw) {
        if (raw == null) {
            throw new NullPointerException();
        }
        if (raw.length < 7) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (raw[raw.length - 1] != -125) {
            throw new InvalidParameterException("Invalid identifier");
        }
        this.data = new byte[raw.length - 6];
        System.arraycopy(raw, 0, this.data, 0, this.data.length);
        this.check = raw[raw.length - 2];
        int ch4 = raw[raw.length - 3] & 0xFF;
        int ch3 = raw[raw.length - 4] & 0xFF;
        int ch2 = raw[raw.length - 5] & 0xFF;
        int ch1 = raw[raw.length - 6] & 0xFF;
        this.offset = ((long)ch4 << 24) + ((long)ch3 << 16) + ((long)ch2 << 8) + (long)ch1;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean verifyChecksum() {
        byte tmpCheck = 0;
        for (byte datum : this.data) {
            tmpCheck = (byte)(tmpCheck ^ datum);
        }
        long tmpOffset = this.offset;
        for (int i = 0; i < 4; ++i) {
            tmpCheck = (byte)((long)tmpCheck ^ tmpOffset & 0xFFL);
            tmpOffset >>= 8;
        }
        return tmpCheck == this.check;
    }

    public byte[] generate() {
        byte[] out = new byte[this.data.length + 6];
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        long tmpOffset = this.offset;
        for (int i = out.length - 6; i < out.length - 2; ++i) {
            out[i] = (byte)(tmpOffset & 0xFFL);
            tmpOffset >>= 8;
        }
        out[out.length - 2] = this.check;
        out[out.length - 1] = -125;
        return out;
    }
}

