/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import de.sg_o.lib.photoNet.netData.DataTransferBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DataUploadFile {
    private final RandomAccessFile model;
    private final int blockSize;
    private long offset = 0L;

    public DataUploadFile(File modelFile, int blockSize) throws FileNotFoundException {
        this.model = new RandomAccessFile(modelFile, "r");
        this.blockSize = blockSize;
    }

    public DataTransferBlock getBlock(long offset) throws IOException {
        byte[] buffer = new byte[this.blockSize];
        this.model.seek(offset);
        int lengthRead = this.model.read(buffer);
        if (lengthRead < buffer.length) {
            byte[] tmp = buffer;
            buffer = new byte[lengthRead];
            System.arraycopy(tmp, 0, buffer, 0, lengthRead);
        }
        return new DataTransferBlock(buffer, offset);
    }

    public DataTransferBlock getBlock() throws IOException {
        DataTransferBlock block = this.getBlock(this.offset);
        this.offset += (long)this.blockSize;
        return block;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void close() throws IOException {
        this.model.close();
    }
}

